/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.noise;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CachedNoiseHelper {
    private static final Map<Integer, Cache> DATA = new ConcurrentHashMap<Integer, Cache>();

    public static Cache getOrCreate(int hash) {
        Cache pull = DATA.get(hash);
        if (pull != null) {
            return pull;
        }
        Cache push = new Cache();
        DATA.put(hash, push);
        return push;
    }

    public static void resetAll() {
        DATA.forEach((i, c) -> ((Cache)c).reset());
    }

    public static void removeAll() {
        DATA.clear();
    }

    public static class Cache {
        private final float[] output3 = new float[65536];
        private final float[] output2 = new float[256];

        public float getNoise(int x, int y, int z) {
            return this.output3[x << 12 | z << 8 | y];
        }

        public float getNoise(int x, int z) {
            return this.output2[x << 4 | z];
        }

        public void writeNoise(int x, int y, int z, float noise) {
            this.output3[x << 12 | z << 8 | y] = noise;
        }

        public void writeNoise(int x, int z, float noise) {
            this.output2[x << 4 | z] = noise;
        }

        private void reset() {
            Arrays.fill(this.output3, 0.0f);
            Arrays.fill(this.output2, 0.0f);
        }
    }
}

