/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.model;

import com.personthecat.cavegenerator.model.EmptyRange;
import com.personthecat.cavegenerator.model.FloatRange;
import com.personthecat.cavegenerator.util.CommonMethods;
import java.util.Iterator;
import java.util.Random;
import org.jetbrains.annotations.NotNull;

public class Range
implements Iterable<Integer> {
    public final int min;
    public final int max;

    public Range(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public Range(int max) {
        this(max, max);
    }

    public static Range of(int a, int b) {
        return a > b ? new Range(b, a) : new Range(a, b);
    }

    public static Range of(int max) {
        return new Range(max);
    }

    public static FloatRange of(float a, float b) {
        return a > b ? new FloatRange(b, a) : new FloatRange(a, b);
    }

    public static FloatRange of(float a) {
        return new FloatRange(a);
    }

    public static Range checkedOrEmpty(int min, int max) {
        return max > min ? new Range(min, max) : EmptyRange.get();
    }

    public static EmptyRange empty() {
        return EmptyRange.get();
    }

    public int rand(Random rand) {
        return CommonMethods.numBetween(rand, this.min, this.max);
    }

    public boolean contains(int num) {
        return num >= this.min && num < this.max;
    }

    public int diff() {
        return this.max - this.min;
    }

    public boolean isEmpty() {
        return false;
    }

    @Override
    @NotNull
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            int i;
            {
                this.i = Range.this.min;
            }

            @Override
            public boolean hasNext() {
                return this.i < Range.this.max;
            }

            @Override
            public Integer next() {
                return this.i++;
            }
        };
    }

    public String toString() {
        return CommonMethods.f("Range[{}~{}]", this.min, this.max);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range other = (Range)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.min != other.min) {
            return false;
        }
        return this.max == other.max;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Range;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.min;
        result = result * 59 + this.max;
        return result;
    }
}

