/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.model;

import com.personthecat.cavegenerator.util.CommonMethods;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public enum Direction {
    UP,
    DOWN,
    NORTH,
    SOUTH,
    EAST,
    WEST,
    SIDE,
    ALL;


    public static Direction from(String s) {
        Optional<Direction> dir = CommonMethods.find(Direction.values(), v -> v.toString().equalsIgnoreCase(s));
        return dir.orElseThrow(() -> {
            String o = Arrays.toString((Object[])Direction.values());
            return CommonMethods.runExF("Error: Direction \"{}\" does not exist. The following are valid options:\n\n{}", s, o);
        });
    }

    public static class Container {
        private static final Container ALL_DIRECTIONS = new Container(true, true, true, true, true, true, true);
        public final boolean up;
        public final boolean down;
        public final boolean side;
        public final boolean north;
        public final boolean south;
        public final boolean east;
        public final boolean west;

        public static Container from(List<Direction> directions) {
            if (directions.isEmpty()) {
                return ALL_DIRECTIONS;
            }
            boolean up = false;
            boolean down = false;
            boolean side = false;
            boolean north = false;
            boolean south = false;
            boolean east = false;
            boolean west = false;
            for (Direction direction : directions) {
                switch (direction) {
                    case UP: {
                        up = true;
                        break;
                    }
                    case DOWN: {
                        down = true;
                        break;
                    }
                    case SIDE: {
                        side = true;
                        break;
                    }
                    case NORTH: {
                        north = true;
                        break;
                    }
                    case SOUTH: {
                        south = true;
                        break;
                    }
                    case EAST: {
                        east = true;
                        break;
                    }
                    case WEST: {
                        west = true;
                        break;
                    }
                    case ALL: {
                        return ALL_DIRECTIONS;
                    }
                }
            }
            return new Container(up, down, side, north, south, east, west);
        }

        public Container() {
            this.up = false;
            this.down = false;
            this.side = false;
            this.north = false;
            this.south = false;
            this.east = false;
            this.west = false;
        }

        public Container(boolean up, boolean down, boolean side, boolean north, boolean south, boolean east, boolean west) {
            this.up = up;
            this.down = down;
            this.side = side;
            this.north = north;
            this.south = south;
            this.east = east;
            this.west = west;
        }
    }
}

