/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.model;

import com.personthecat.cavegenerator.data.CaveBlockSettings;
import com.personthecat.cavegenerator.data.DecoratorSettings;
import com.personthecat.cavegenerator.data.PondSettings;
import com.personthecat.cavegenerator.model.ConfiguredCaveBlock;
import com.personthecat.cavegenerator.model.ConfiguredPond;
import com.personthecat.cavegenerator.model.ConfiguredShell;
import com.personthecat.cavegenerator.model.WallDecoratorMap;
import com.personthecat.cavegenerator.util.CommonMethods;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class Decorators {
    public final Predicate<IBlockState> canReplace;
    public final List<ConfiguredCaveBlock> caveBlocks;
    public final WallDecoratorMap wallMap;
    public final List<ConfiguredPond> ponds;
    public final ConfiguredShell shell;

    public static Decorators compile(DecoratorSettings settings, World world) {
        return Decorators.builder().canReplace(Decorators.compileCanReplace(settings)).caveBlocks(CommonMethods.map(settings.caveBlocks, b -> new ConfiguredCaveBlock((CaveBlockSettings)b, world))).wallMap(WallDecoratorMap.sort(settings.wallDecorators, world)).ponds(CommonMethods.map(settings.ponds, p -> new ConfiguredPond((PondSettings)p, world))).shell(new ConfiguredShell(settings.shell, world)).build();
    }

    private static Predicate<IBlockState> compileCanReplace(DecoratorSettings settings) {
        HashSet<IBlockState> replaceable = new HashSet<IBlockState>(settings.replaceableBlocks);
        if (replaceable.isEmpty()) {
            return s -> !s.func_177230_c().equals(Blocks.field_150357_h);
        }
        if (settings.replaceSolidBlocks) {
            return s -> s.func_185904_a().func_76220_a() && !s.func_177230_c().equals(Blocks.field_150357_h);
        }
        if (settings.replaceDecorators) {
            replaceable.addAll(settings.globalDecorators);
            settings.caveBlocks.forEach(c -> replaceable.addAll(c.states));
            settings.wallDecorators.forEach(w -> replaceable.addAll(w.states));
            settings.ponds.forEach(p -> replaceable.addAll(p.states));
            settings.shell.decorators.forEach(s -> replaceable.addAll(s.states));
        }
        if (replaceable.size() == 1) {
            IBlockState state = (IBlockState)replaceable.iterator().next();
            return state::equals;
        }
        return replaceable::contains;
    }

    private static Predicate<IBlockState> $default$canReplace() {
        return s -> !Blocks.field_150355_j.func_176223_P().equals(s);
    }

    private static List<ConfiguredCaveBlock> $default$caveBlocks() {
        return Collections.emptyList();
    }

    private static WallDecoratorMap $default$wallMap() {
        return WallDecoratorMap.builder().build();
    }

    private static List<ConfiguredPond> $default$ponds() {
        return Collections.emptyList();
    }

    private static ConfiguredShell $default$shell() {
        return ConfiguredShell.EMPTY_SHELL;
    }

    Decorators(Predicate<IBlockState> canReplace, List<ConfiguredCaveBlock> caveBlocks, WallDecoratorMap wallMap, List<ConfiguredPond> ponds, ConfiguredShell shell) {
        this.canReplace = canReplace;
        this.caveBlocks = caveBlocks;
        this.wallMap = wallMap;
        this.ponds = ponds;
        this.shell = shell;
    }

    public static DecoratorsBuilder builder() {
        return new DecoratorsBuilder();
    }

    public DecoratorsBuilder toBuilder() {
        return new DecoratorsBuilder().canReplace(this.canReplace).caveBlocks(this.caveBlocks).wallMap(this.wallMap).ponds(this.ponds).shell(this.shell);
    }

    public static class DecoratorsBuilder {
        private boolean canReplace$set;
        private Predicate<IBlockState> canReplace$value;
        private boolean caveBlocks$set;
        private List<ConfiguredCaveBlock> caveBlocks$value;
        private boolean wallMap$set;
        private WallDecoratorMap wallMap$value;
        private boolean ponds$set;
        private List<ConfiguredPond> ponds$value;
        private boolean shell$set;
        private ConfiguredShell shell$value;

        DecoratorsBuilder() {
        }

        public DecoratorsBuilder canReplace(Predicate<IBlockState> canReplace) {
            this.canReplace$value = canReplace;
            this.canReplace$set = true;
            return this;
        }

        public DecoratorsBuilder caveBlocks(List<ConfiguredCaveBlock> caveBlocks) {
            this.caveBlocks$value = caveBlocks;
            this.caveBlocks$set = true;
            return this;
        }

        public DecoratorsBuilder wallMap(WallDecoratorMap wallMap) {
            this.wallMap$value = wallMap;
            this.wallMap$set = true;
            return this;
        }

        public DecoratorsBuilder ponds(List<ConfiguredPond> ponds) {
            this.ponds$value = ponds;
            this.ponds$set = true;
            return this;
        }

        public DecoratorsBuilder shell(ConfiguredShell shell) {
            this.shell$value = shell;
            this.shell$set = true;
            return this;
        }

        public Decorators build() {
            Predicate canReplace$value = this.canReplace$value;
            if (!this.canReplace$set) {
                canReplace$value = Decorators.$default$canReplace();
            }
            List caveBlocks$value = this.caveBlocks$value;
            if (!this.caveBlocks$set) {
                caveBlocks$value = Decorators.$default$caveBlocks();
            }
            WallDecoratorMap wallMap$value = this.wallMap$value;
            if (!this.wallMap$set) {
                wallMap$value = Decorators.$default$wallMap();
            }
            List ponds$value = this.ponds$value;
            if (!this.ponds$set) {
                ponds$value = Decorators.$default$ponds();
            }
            ConfiguredShell shell$value = this.shell$value;
            if (!this.shell$set) {
                shell$value = Decorators.$default$shell();
            }
            return new Decorators(canReplace$value, caveBlocks$value, wallMap$value, ponds$value, shell$value);
        }

        public String toString() {
            return "Decorators.DecoratorsBuilder(canReplace$value=" + this.canReplace$value + ", caveBlocks$value=" + this.caveBlocks$value + ", wallMap$value=" + this.wallMap$value + ", ponds$value=" + this.ponds$value + ", shell$value=" + this.shell$value + ")";
        }
    }
}

