/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.data;

import com.personthecat.cavegenerator.data.ConditionSettings;
import com.personthecat.cavegenerator.data.OverrideSettings;
import com.personthecat.cavegenerator.model.BlockCheck;
import com.personthecat.cavegenerator.model.Direction;
import com.personthecat.cavegenerator.model.Range;
import com.personthecat.cavegenerator.util.HjsonMapper;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import org.hjson.JsonObject;

public class StructureSettings {
    private static final String FEATURE_NAME = "structures";
    private static final ConditionSettings DEFAULT_CONDITIONS = ConditionSettings.builder().height(Range.of(10, 50)).build();
    public final ConditionSettings conditions;
    public final String name;
    public final PlacementSettings placement;
    public final List<IBlockState> matchers;
    public final Direction.Container directions;
    public final List<BlockPos> airChecks;
    public final List<BlockPos> solidChecks;
    public final List<BlockPos> nonSolidChecks;
    public final List<BlockPos> waterChecks;
    public final List<BlockCheck> blockChecks;
    public final boolean checkSurface;
    public final BlockPos offset;
    public final float chance;
    public final int count;
    public final boolean debugSpawns;
    public final String command;
    public final boolean rotateRandomly;

    public static StructureSettings from(JsonObject json, OverrideSettings overrides) {
        ConditionSettings conditions = overrides.apply(DEFAULT_CONDITIONS.toBuilder()).build();
        return StructureSettings.copyInto(json, StructureSettings.builder().conditions(conditions));
    }

    public static StructureSettings from(JsonObject json) {
        return StructureSettings.copyInto(json, StructureSettings.builder());
    }

    private static StructureSettings copyInto(JsonObject json, StructureSettingsBuilder builder) {
        StructureSettings original = builder.build();
        return new HjsonMapper(json).mapRequiredString("name", FEATURE_NAME, builder::name).mapSelf(o -> builder.conditions(ConditionSettings.from(o, original.conditions))).mapPlacementSettings(builder::placement).mapStateList("matchers", builder::matchers).mapDirectionList("directions", l -> builder.directions(Direction.Container.from(l))).mapBlockPosList("airChecks", builder::airChecks).mapBlockPosList("solidChecks", builder::solidChecks).mapBlockPosList("nonSolidChecks", builder::nonSolidChecks).mapBlockPosList("waterChecks", builder::waterChecks).mapValueArray("blockChecks", BlockCheck::fromValue, builder::blockChecks).mapBool("checkSurface", builder::checkSurface).mapBlockPos("offset", builder::offset).mapFloat("chance", builder::chance).mapInt("count", builder::count).mapBool("debugSpawns", builder::debugSpawns).mapString("command", builder::command).mapBool("rotateRandomly", builder::rotateRandomly).release(builder::build);
    }

    private static ConditionSettings $default$conditions() {
        return DEFAULT_CONDITIONS;
    }

    private static PlacementSettings $default$placement() {
        return new PlacementSettings().func_186225_a(Blocks.field_150348_b);
    }

    private static List<IBlockState> $default$matchers() {
        return Collections.singletonList(Blocks.field_150348_b.func_176223_P());
    }

    private static Direction.Container $default$directions() {
        return new Direction.Container();
    }

    private static List<BlockPos> $default$airChecks() {
        return Collections.emptyList();
    }

    private static List<BlockPos> $default$solidChecks() {
        return Collections.emptyList();
    }

    private static List<BlockPos> $default$nonSolidChecks() {
        return Collections.emptyList();
    }

    private static List<BlockPos> $default$waterChecks() {
        return Collections.emptyList();
    }

    private static List<BlockCheck> $default$blockChecks() {
        return Collections.emptyList();
    }

    private static boolean $default$checkSurface() {
        return true;
    }

    private static BlockPos $default$offset() {
        return BlockPos.field_177992_a;
    }

    private static float $default$chance() {
        return 1.0f;
    }

    private static int $default$count() {
        return 1;
    }

    private static boolean $default$debugSpawns() {
        return false;
    }

    private static String $default$command() {
        return "";
    }

    private static boolean $default$rotateRandomly() {
        return false;
    }

    StructureSettings(ConditionSettings conditions, String name, PlacementSettings placement, List<IBlockState> matchers, Direction.Container directions, List<BlockPos> airChecks, List<BlockPos> solidChecks, List<BlockPos> nonSolidChecks, List<BlockPos> waterChecks, List<BlockCheck> blockChecks, boolean checkSurface, BlockPos offset, float chance, int count, boolean debugSpawns, String command, boolean rotateRandomly) {
        this.conditions = conditions;
        this.name = name;
        this.placement = placement;
        this.matchers = matchers;
        this.directions = directions;
        this.airChecks = airChecks;
        this.solidChecks = solidChecks;
        this.nonSolidChecks = nonSolidChecks;
        this.waterChecks = waterChecks;
        this.blockChecks = blockChecks;
        this.checkSurface = checkSurface;
        this.offset = offset;
        this.chance = chance;
        this.count = count;
        this.debugSpawns = debugSpawns;
        this.command = command;
        this.rotateRandomly = rotateRandomly;
    }

    public static StructureSettingsBuilder builder() {
        return new StructureSettingsBuilder();
    }

    public static final class Fields {
        public static final String conditions = "conditions";
        public static final String name = "name";
        public static final String placement = "placement";
        public static final String matchers = "matchers";
        public static final String directions = "directions";
        public static final String airChecks = "airChecks";
        public static final String solidChecks = "solidChecks";
        public static final String nonSolidChecks = "nonSolidChecks";
        public static final String waterChecks = "waterChecks";
        public static final String blockChecks = "blockChecks";
        public static final String checkSurface = "checkSurface";
        public static final String offset = "offset";
        public static final String chance = "chance";
        public static final String count = "count";
        public static final String debugSpawns = "debugSpawns";
        public static final String command = "command";
        public static final String rotateRandomly = "rotateRandomly";

        private Fields() {
        }
    }

    public static class StructureSettingsBuilder {
        private boolean conditions$set;
        private ConditionSettings conditions$value;
        private String name;
        private boolean placement$set;
        private PlacementSettings placement$value;
        private boolean matchers$set;
        private List<IBlockState> matchers$value;
        private boolean directions$set;
        private Direction.Container directions$value;
        private boolean airChecks$set;
        private List<BlockPos> airChecks$value;
        private boolean solidChecks$set;
        private List<BlockPos> solidChecks$value;
        private boolean nonSolidChecks$set;
        private List<BlockPos> nonSolidChecks$value;
        private boolean waterChecks$set;
        private List<BlockPos> waterChecks$value;
        private boolean blockChecks$set;
        private List<BlockCheck> blockChecks$value;
        private boolean checkSurface$set;
        private boolean checkSurface$value;
        private boolean offset$set;
        private BlockPos offset$value;
        private boolean chance$set;
        private float chance$value;
        private boolean count$set;
        private int count$value;
        private boolean debugSpawns$set;
        private boolean debugSpawns$value;
        private boolean command$set;
        private String command$value;
        private boolean rotateRandomly$set;
        private boolean rotateRandomly$value;

        StructureSettingsBuilder() {
        }

        public StructureSettingsBuilder conditions(ConditionSettings conditions) {
            this.conditions$value = conditions;
            this.conditions$set = true;
            return this;
        }

        public StructureSettingsBuilder name(String name) {
            this.name = name;
            return this;
        }

        public StructureSettingsBuilder placement(PlacementSettings placement) {
            this.placement$value = placement;
            this.placement$set = true;
            return this;
        }

        public StructureSettingsBuilder matchers(List<IBlockState> matchers) {
            this.matchers$value = matchers;
            this.matchers$set = true;
            return this;
        }

        public StructureSettingsBuilder directions(Direction.Container directions) {
            this.directions$value = directions;
            this.directions$set = true;
            return this;
        }

        public StructureSettingsBuilder airChecks(List<BlockPos> airChecks) {
            this.airChecks$value = airChecks;
            this.airChecks$set = true;
            return this;
        }

        public StructureSettingsBuilder solidChecks(List<BlockPos> solidChecks) {
            this.solidChecks$value = solidChecks;
            this.solidChecks$set = true;
            return this;
        }

        public StructureSettingsBuilder nonSolidChecks(List<BlockPos> nonSolidChecks) {
            this.nonSolidChecks$value = nonSolidChecks;
            this.nonSolidChecks$set = true;
            return this;
        }

        public StructureSettingsBuilder waterChecks(List<BlockPos> waterChecks) {
            this.waterChecks$value = waterChecks;
            this.waterChecks$set = true;
            return this;
        }

        public StructureSettingsBuilder blockChecks(List<BlockCheck> blockChecks) {
            this.blockChecks$value = blockChecks;
            this.blockChecks$set = true;
            return this;
        }

        public StructureSettingsBuilder checkSurface(boolean checkSurface) {
            this.checkSurface$value = checkSurface;
            this.checkSurface$set = true;
            return this;
        }

        public StructureSettingsBuilder offset(BlockPos offset) {
            this.offset$value = offset;
            this.offset$set = true;
            return this;
        }

        public StructureSettingsBuilder chance(float chance) {
            this.chance$value = chance;
            this.chance$set = true;
            return this;
        }

        public StructureSettingsBuilder count(int count) {
            this.count$value = count;
            this.count$set = true;
            return this;
        }

        public StructureSettingsBuilder debugSpawns(boolean debugSpawns) {
            this.debugSpawns$value = debugSpawns;
            this.debugSpawns$set = true;
            return this;
        }

        public StructureSettingsBuilder command(String command) {
            this.command$value = command;
            this.command$set = true;
            return this;
        }

        public StructureSettingsBuilder rotateRandomly(boolean rotateRandomly) {
            this.rotateRandomly$value = rotateRandomly;
            this.rotateRandomly$set = true;
            return this;
        }

        public StructureSettings build() {
            ConditionSettings conditions$value = this.conditions$value;
            if (!this.conditions$set) {
                conditions$value = StructureSettings.$default$conditions();
            }
            PlacementSettings placement$value = this.placement$value;
            if (!this.placement$set) {
                placement$value = StructureSettings.$default$placement();
            }
            List matchers$value = this.matchers$value;
            if (!this.matchers$set) {
                matchers$value = StructureSettings.$default$matchers();
            }
            Direction.Container directions$value = this.directions$value;
            if (!this.directions$set) {
                directions$value = StructureSettings.$default$directions();
            }
            List airChecks$value = this.airChecks$value;
            if (!this.airChecks$set) {
                airChecks$value = StructureSettings.$default$airChecks();
            }
            List solidChecks$value = this.solidChecks$value;
            if (!this.solidChecks$set) {
                solidChecks$value = StructureSettings.$default$solidChecks();
            }
            List nonSolidChecks$value = this.nonSolidChecks$value;
            if (!this.nonSolidChecks$set) {
                nonSolidChecks$value = StructureSettings.$default$nonSolidChecks();
            }
            List waterChecks$value = this.waterChecks$value;
            if (!this.waterChecks$set) {
                waterChecks$value = StructureSettings.$default$waterChecks();
            }
            List blockChecks$value = this.blockChecks$value;
            if (!this.blockChecks$set) {
                blockChecks$value = StructureSettings.$default$blockChecks();
            }
            boolean checkSurface$value = this.checkSurface$value;
            if (!this.checkSurface$set) {
                checkSurface$value = StructureSettings.$default$checkSurface();
            }
            BlockPos offset$value = this.offset$value;
            if (!this.offset$set) {
                offset$value = StructureSettings.$default$offset();
            }
            float chance$value = this.chance$value;
            if (!this.chance$set) {
                chance$value = StructureSettings.$default$chance();
            }
            int count$value = this.count$value;
            if (!this.count$set) {
                count$value = StructureSettings.$default$count();
            }
            boolean debugSpawns$value = this.debugSpawns$value;
            if (!this.debugSpawns$set) {
                debugSpawns$value = StructureSettings.$default$debugSpawns();
            }
            String command$value = this.command$value;
            if (!this.command$set) {
                command$value = StructureSettings.$default$command();
            }
            boolean rotateRandomly$value = this.rotateRandomly$value;
            if (!this.rotateRandomly$set) {
                rotateRandomly$value = StructureSettings.$default$rotateRandomly();
            }
            return new StructureSettings(conditions$value, this.name, placement$value, matchers$value, directions$value, airChecks$value, solidChecks$value, nonSolidChecks$value, waterChecks$value, blockChecks$value, checkSurface$value, offset$value, chance$value, count$value, debugSpawns$value, command$value, rotateRandomly$value);
        }

        public String toString() {
            return "StructureSettings.StructureSettingsBuilder(conditions$value=" + this.conditions$value + ", name=" + this.name + ", placement$value=" + this.placement$value + ", matchers$value=" + this.matchers$value + ", directions$value=" + this.directions$value + ", airChecks$value=" + this.airChecks$value + ", solidChecks$value=" + this.solidChecks$value + ", nonSolidChecks$value=" + this.nonSolidChecks$value + ", waterChecks$value=" + this.waterChecks$value + ", blockChecks$value=" + this.blockChecks$value + ", checkSurface$value=" + this.checkSurface$value + ", offset$value=" + this.offset$value + ", chance$value=" + this.chance$value + ", count$value=" + this.count$value + ", debugSpawns$value=" + this.debugSpawns$value + ", command$value=" + this.command$value + ", rotateRandomly$value=" + this.rotateRandomly$value + ")";
        }
    }
}

