/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.data;

import com.personthecat.cavegenerator.data.NoiseSettings;
import com.personthecat.cavegenerator.model.Range;
import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.util.HjsonMapper;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import org.hjson.JsonObject;

public class PondSettings {
    private static final String FEATURE_NAME = "wallDecorators";
    public final List<IBlockState> states;
    public final double integrity;
    public final Range height;
    public final int depth;
    public final List<IBlockState> matchers;
    public final Optional<NoiseSettings> noise;
    public static final NoiseSettings DEFAULT_NOISE = NoiseSettings.builder().frequency(0.02f).threshold(Range.of(0.0f)).stretch(1.0f).build();

    public static PondSettings from(JsonObject json) {
        PondSettingsBuilder builder = PondSettings.builder();
        return new HjsonMapper(json).mapRequiredStateList("states", FEATURE_NAME, builder::states).mapObject("noise", o -> PondSettings.copyNoise(o, builder)).mapFloat("integrity", builder::integrity).mapRange("height", builder::height).mapInt("depth", builder::depth).mapStateList("matchers", builder::matchers).release(builder::build);
    }

    private static void copyNoise(JsonObject json, PondSettingsBuilder builder) {
        builder.noise(CommonMethods.full(NoiseSettings.from(json, DEFAULT_NOISE)));
    }

    private static double $default$integrity() {
        return 1.0;
    }

    private static Range $default$height() {
        return Range.of(10, 50);
    }

    private static int $default$depth() {
        return 2;
    }

    private static List<IBlockState> $default$matchers() {
        return Collections.singletonList(Blocks.field_150348_b.func_176223_P());
    }

    private static Optional<NoiseSettings> $default$noise() {
        return CommonMethods.empty();
    }

    PondSettings(List<IBlockState> states, double integrity, Range height, int depth, List<IBlockState> matchers, Optional<NoiseSettings> noise) {
        this.states = states;
        this.integrity = integrity;
        this.height = height;
        this.depth = depth;
        this.matchers = matchers;
        this.noise = noise;
    }

    public static PondSettingsBuilder builder() {
        return new PondSettingsBuilder();
    }

    public static final class Fields {
        public static final String states = "states";
        public static final String integrity = "integrity";
        public static final String height = "height";
        public static final String depth = "depth";
        public static final String matchers = "matchers";
        public static final String noise = "noise";

        private Fields() {
        }
    }

    public static class PondSettingsBuilder {
        private List<IBlockState> states;
        private boolean integrity$set;
        private double integrity$value;
        private boolean height$set;
        private Range height$value;
        private boolean depth$set;
        private int depth$value;
        private boolean matchers$set;
        private List<IBlockState> matchers$value;
        private boolean noise$set;
        private Optional<NoiseSettings> noise$value;

        PondSettingsBuilder() {
        }

        public PondSettingsBuilder states(List<IBlockState> states) {
            this.states = states;
            return this;
        }

        public PondSettingsBuilder integrity(double integrity) {
            this.integrity$value = integrity;
            this.integrity$set = true;
            return this;
        }

        public PondSettingsBuilder height(Range height) {
            this.height$value = height;
            this.height$set = true;
            return this;
        }

        public PondSettingsBuilder depth(int depth) {
            this.depth$value = depth;
            this.depth$set = true;
            return this;
        }

        public PondSettingsBuilder matchers(List<IBlockState> matchers) {
            this.matchers$value = matchers;
            this.matchers$set = true;
            return this;
        }

        public PondSettingsBuilder noise(Optional<NoiseSettings> noise) {
            this.noise$value = noise;
            this.noise$set = true;
            return this;
        }

        public PondSettings build() {
            double integrity$value = this.integrity$value;
            if (!this.integrity$set) {
                integrity$value = PondSettings.$default$integrity();
            }
            Range height$value = this.height$value;
            if (!this.height$set) {
                height$value = PondSettings.$default$height();
            }
            int depth$value = this.depth$value;
            if (!this.depth$set) {
                depth$value = PondSettings.$default$depth();
            }
            List matchers$value = this.matchers$value;
            if (!this.matchers$set) {
                matchers$value = PondSettings.$default$matchers();
            }
            Optional noise$value = this.noise$value;
            if (!this.noise$set) {
                noise$value = PondSettings.$default$noise();
            }
            return new PondSettings(this.states, integrity$value, height$value, depth$value, matchers$value, noise$value);
        }

        public String toString() {
            return "PondSettings.PondSettingsBuilder(states=" + this.states + ", integrity$value=" + this.integrity$value + ", height$value=" + this.height$value + ", depth$value=" + this.depth$value + ", matchers$value=" + this.matchers$value + ", noise$value=" + this.noise$value + ")";
        }
    }
}

