/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.data;

import com.personthecat.cavegenerator.data.ConditionSettings;
import com.personthecat.cavegenerator.data.OverrideSettings;
import com.personthecat.cavegenerator.model.Range;
import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.util.HjsonMapper;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.state.IBlockState;
import org.hjson.JsonObject;

@ParametersAreNonnullByDefault
public class PillarSettings {
    private static final String FEATURE_NAME = "pillars";
    private static final ConditionSettings DEFAULT_CONDITIONS = ConditionSettings.builder().height(Range.of(10, 50)).build();
    public final ConditionSettings conditions;
    public final IBlockState state;
    public final int count;
    public final Range length;
    public final Optional<BlockStairs> stairBlock;

    public static PillarSettings from(JsonObject json, OverrideSettings overrides) {
        ConditionSettings conditions = overrides.apply(DEFAULT_CONDITIONS.toBuilder()).build();
        return PillarSettings.copyInto(json, PillarSettings.builder().conditions(conditions));
    }

    public static PillarSettings from(JsonObject json) {
        return PillarSettings.copyInto(json, PillarSettings.builder());
    }

    private static PillarSettings copyInto(JsonObject json, PillarSettingsBuilder builder) {
        PillarSettings original = builder.build();
        return new HjsonMapper(json).mapRequiredState("state", FEATURE_NAME, builder::state).mapSelf(o -> builder.conditions(ConditionSettings.from(o, original.conditions))).mapInt("count", builder::count).mapRange("length", builder::length).mapState("stairBlock", s -> builder.stairBlock(CommonMethods.full(PillarSettings.toStairBlock(s)))).release(builder::build);
    }

    private static BlockStairs toStairBlock(IBlockState state) {
        Block block = state.func_177230_c();
        if (block instanceof BlockStairs) {
            return (BlockStairs)block;
        }
        throw CommonMethods.runExF("Error: the input block, {}, is not a valid stair block.", block.toString());
    }

    private static ConditionSettings $default$conditions() {
        return DEFAULT_CONDITIONS;
    }

    private static int $default$count() {
        return 15;
    }

    private static Range $default$length() {
        return Range.of(5, 12);
    }

    private static Optional<BlockStairs> $default$stairBlock() {
        return CommonMethods.empty();
    }

    PillarSettings(ConditionSettings conditions, IBlockState state, int count, Range length, Optional<BlockStairs> stairBlock) {
        this.conditions = conditions;
        this.state = state;
        this.count = count;
        this.length = length;
        this.stairBlock = stairBlock;
    }

    public static PillarSettingsBuilder builder() {
        return new PillarSettingsBuilder();
    }

    public static final class Fields {
        public static final String conditions = "conditions";
        public static final String state = "state";
        public static final String count = "count";
        public static final String length = "length";
        public static final String stairBlock = "stairBlock";

        private Fields() {
        }
    }

    public static class PillarSettingsBuilder {
        private boolean conditions$set;
        private ConditionSettings conditions$value;
        private IBlockState state;
        private boolean count$set;
        private int count$value;
        private boolean length$set;
        private Range length$value;
        private boolean stairBlock$set;
        private Optional<BlockStairs> stairBlock$value;

        PillarSettingsBuilder() {
        }

        public PillarSettingsBuilder conditions(ConditionSettings conditions) {
            this.conditions$value = conditions;
            this.conditions$set = true;
            return this;
        }

        public PillarSettingsBuilder state(IBlockState state) {
            this.state = state;
            return this;
        }

        public PillarSettingsBuilder count(int count) {
            this.count$value = count;
            this.count$set = true;
            return this;
        }

        public PillarSettingsBuilder length(Range length) {
            this.length$value = length;
            this.length$set = true;
            return this;
        }

        public PillarSettingsBuilder stairBlock(Optional<BlockStairs> stairBlock) {
            this.stairBlock$value = stairBlock;
            this.stairBlock$set = true;
            return this;
        }

        public PillarSettings build() {
            ConditionSettings conditions$value = this.conditions$value;
            if (!this.conditions$set) {
                conditions$value = PillarSettings.$default$conditions();
            }
            int count$value = this.count$value;
            if (!this.count$set) {
                count$value = PillarSettings.$default$count();
            }
            Range length$value = this.length$value;
            if (!this.length$set) {
                length$value = PillarSettings.$default$length();
            }
            Optional stairBlock$value = this.stairBlock$value;
            if (!this.stairBlock$set) {
                stairBlock$value = PillarSettings.$default$stairBlock();
            }
            return new PillarSettings(conditions$value, this.state, count$value, length$value, stairBlock$value);
        }

        public String toString() {
            return "PillarSettings.PillarSettingsBuilder(conditions$value=" + this.conditions$value + ", state=" + this.state + ", count$value=" + this.count$value + ", length$value=" + this.length$value + ", stairBlock$value=" + this.stairBlock$value + ")";
        }
    }
}

