/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.data;

import com.personthecat.cavegenerator.config.FieldHistory;
import com.personthecat.cavegenerator.data.CaveBlockSettings;
import com.personthecat.cavegenerator.data.ConditionSettings;
import com.personthecat.cavegenerator.data.DecoratorSettings;
import com.personthecat.cavegenerator.data.NoiseMapSettings;
import com.personthecat.cavegenerator.data.NoiseRegionSettings;
import com.personthecat.cavegenerator.data.NoiseSettings;
import com.personthecat.cavegenerator.data.PondSettings;
import com.personthecat.cavegenerator.data.RoomSettings;
import com.personthecat.cavegenerator.data.ShellSettings;
import com.personthecat.cavegenerator.data.TunnelSettings;
import com.personthecat.cavegenerator.data.WallDecoratorSettings;
import com.personthecat.cavegenerator.model.Range;
import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.util.HjsonMapper;
import com.personthecat.cavegenerator.util.HjsonTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.biome.Biome;
import org.apache.commons.lang3.ArrayUtils;
import org.hjson.JsonObject;

public class OverrideSettings {
    public final Optional<Boolean> blacklistBiomes;
    public final Optional<List<Biome>> biomes;
    public final Optional<Boolean> blacklistDimensions;
    public final Optional<List<Integer>> dimensions;
    public final Optional<Range> height;
    public final Optional<NoiseMapSettings> floor;
    public final Optional<NoiseMapSettings> ceiling;
    public final Optional<NoiseRegionSettings> region;
    public final Optional<NoiseSettings> noise;
    public final Optional<List<IBlockState>> replaceableBlocks;
    public final Optional<Boolean> replaceDecorators;
    public final Optional<List<CaveBlockSettings>> caveBlocks;
    public final Optional<List<WallDecoratorSettings>> wallDecorators;
    public final Optional<List<PondSettings>> ponds;
    public final Optional<ShellSettings> shell;
    public final Optional<TunnelSettings> branches;
    public final Optional<RoomSettings> rooms;
    public final List<IBlockState> globalDecorators;

    public static OverrideSettings from(JsonObject json) {
        OverrideSettingsBuilder builder = OverrideSettings.builder().globalDecorators(OverrideSettings.getAllDecorators(json));
        return new HjsonMapper(json).mapBool("blacklistBiomes", b -> builder.blacklistBiomes(CommonMethods.full(b))).mapBiomes("biomes", l -> builder.biomes(CommonMethods.full(l))).mapBool("blacklistDimensions", b -> builder.blacklistBiomes(CommonMethods.full(b))).mapIntList("dimensions", l -> builder.dimensions(CommonMethods.full(l))).mapRange("height", r -> builder.height(CommonMethods.full(r))).mapObject("floor", o -> builder.floor(CommonMethods.full(NoiseMapSettings.from(o)))).mapObject("ceiling", o -> builder.ceiling(CommonMethods.full(NoiseMapSettings.from(o)))).mapObject("noise", o -> builder.noise(CommonMethods.full(NoiseSettings.from(o)))).mapStateList("replaceableBlocks", l -> builder.replaceableBlocks(CommonMethods.full(l))).mapBool("replaceDecorators", b -> builder.replaceDecorators(CommonMethods.full(b))).mapArray("caveBlocks", CaveBlockSettings::from, l -> builder.caveBlocks(CommonMethods.full(l))).mapArray("wallDecorators", WallDecoratorSettings::from, l -> builder.wallDecorators(CommonMethods.full(l))).mapArray("ponds", PondSettings::from, l -> builder.ponds(CommonMethods.full(l))).mapObject("shell", s -> builder.shell(CommonMethods.full(ShellSettings.from(s)))).mapObject("branches", b -> builder.branches(CommonMethods.full(TunnelSettings.from(b)))).mapObject("rooms", r -> builder.rooms(CommonMethods.full(RoomSettings.from(r)))).release(builder::build);
    }

    public ConditionSettings.ConditionSettingsBuilder apply(ConditionSettings.ConditionSettingsBuilder builder) {
        this.blacklistBiomes.ifPresent(builder::blacklistBiomes);
        this.biomes.ifPresent(builder::biomes);
        this.blacklistDimensions.ifPresent(builder::blacklistDimensions);
        this.dimensions.ifPresent(builder::dimensions);
        this.height.ifPresent(builder::height);
        this.floor.ifPresent(n -> builder.floor(CommonMethods.full(n)));
        this.ceiling.ifPresent(n -> builder.ceiling(CommonMethods.full(n)));
        this.region.ifPresent(n -> builder.region(CommonMethods.full(n)));
        this.noise.ifPresent(n -> builder.noise(CommonMethods.full(n)));
        return builder;
    }

    public DecoratorSettings.DecoratorSettingsBuilder apply(DecoratorSettings.DecoratorSettingsBuilder builder) {
        builder.globalDecorators(this.globalDecorators);
        this.replaceableBlocks.ifPresent(builder::replaceableBlocks);
        this.replaceDecorators.ifPresent(builder::replaceDecorators);
        this.caveBlocks.ifPresent(builder::caveBlocks);
        this.wallDecorators.ifPresent(builder::wallDecorators);
        this.ponds.ifPresent(builder::ponds);
        this.shell.ifPresent(builder::shell);
        return builder;
    }

    public TunnelSettings.TunnelSettingsBuilder apply(TunnelSettings.TunnelSettingsBuilder builder) {
        this.branches.ifPresent(b -> builder.branches(CommonMethods.full(b)));
        this.rooms.ifPresent(r -> builder.rooms(CommonMethods.full(r)));
        return builder;
    }

    private static List<IBlockState> getAllDecorators(JsonObject json) {
        ArrayList<IBlockState> decorators = new ArrayList<IBlockState>();
        OverrideSettings.addAllDecorators(decorators, json, new String[0]);
        OverrideSettings.addAllDecorators(decorators, json, "branches");
        OverrideSettings.addAllDecorators(decorators, json, "rooms");
        OverrideSettings.addAllDecorators(decorators, json, "tunnels");
        OverrideSettings.addAllDecorators(decorators, json, "tunnels", "branches");
        OverrideSettings.addAllDecorators(decorators, json, "ravines");
        OverrideSettings.addAllDecorators(decorators, json, "caverns");
        OverrideSettings.addAll(decorators, json, "states", "clusters");
        OverrideSettings.addAll(decorators, json, "state", "layers");
        return decorators;
    }

    private static void addAllDecorators(List<IBlockState> decorators, JsonObject json, String ... path) {
        FieldHistory.withPath((String[])ArrayUtils.add((Object[])path, (Object)"wallDecorators")).forEach(json, j -> OverrideSettings.addAll(decorators, j, "states", new String[0]));
        FieldHistory.withPath((String[])ArrayUtils.add((Object[])path, (Object)"caveBlocks")).forEach(json, j -> OverrideSettings.addAll(decorators, j, "states", new String[0]));
        FieldHistory.withPath((String[])ArrayUtils.add((Object[])path, (Object)"ponds")).forEach(json, j -> OverrideSettings.addAll(decorators, j, "states", new String[0]));
        FieldHistory.withPath((String[])ArrayUtils.addAll((Object[])path, (Object[])new String[]{"shell", "decorators"})).forEach(json, j -> OverrideSettings.addAll(decorators, j, "states", new String[0]));
    }

    private static void addAll(List<IBlockState> decorators, JsonObject json, String field, String ... path) {
        FieldHistory.withPath(path).forEach(json, j -> HjsonTools.getStateList(j, field).ifPresent(decorators::addAll));
    }

    private static Optional<Boolean> $default$blacklistBiomes() {
        return CommonMethods.empty();
    }

    private static Optional<List<Biome>> $default$biomes() {
        return CommonMethods.empty();
    }

    private static Optional<Boolean> $default$blacklistDimensions() {
        return CommonMethods.empty();
    }

    private static Optional<List<Integer>> $default$dimensions() {
        return CommonMethods.empty();
    }

    private static Optional<Range> $default$height() {
        return CommonMethods.empty();
    }

    private static Optional<NoiseMapSettings> $default$floor() {
        return CommonMethods.empty();
    }

    private static Optional<NoiseMapSettings> $default$ceiling() {
        return CommonMethods.empty();
    }

    private static Optional<NoiseRegionSettings> $default$region() {
        return CommonMethods.empty();
    }

    private static Optional<NoiseSettings> $default$noise() {
        return CommonMethods.empty();
    }

    private static Optional<List<IBlockState>> $default$replaceableBlocks() {
        return CommonMethods.empty();
    }

    private static Optional<Boolean> $default$replaceDecorators() {
        return CommonMethods.empty();
    }

    private static Optional<List<CaveBlockSettings>> $default$caveBlocks() {
        return CommonMethods.empty();
    }

    private static Optional<List<WallDecoratorSettings>> $default$wallDecorators() {
        return CommonMethods.empty();
    }

    private static Optional<List<PondSettings>> $default$ponds() {
        return CommonMethods.empty();
    }

    private static Optional<ShellSettings> $default$shell() {
        return CommonMethods.empty();
    }

    private static Optional<TunnelSettings> $default$branches() {
        return CommonMethods.empty();
    }

    private static Optional<RoomSettings> $default$rooms() {
        return CommonMethods.empty();
    }

    private static List<IBlockState> $default$globalDecorators() {
        return Collections.emptyList();
    }

    OverrideSettings(Optional<Boolean> blacklistBiomes, Optional<List<Biome>> biomes, Optional<Boolean> blacklistDimensions, Optional<List<Integer>> dimensions, Optional<Range> height, Optional<NoiseMapSettings> floor, Optional<NoiseMapSettings> ceiling, Optional<NoiseRegionSettings> region, Optional<NoiseSettings> noise, Optional<List<IBlockState>> replaceableBlocks, Optional<Boolean> replaceDecorators, Optional<List<CaveBlockSettings>> caveBlocks, Optional<List<WallDecoratorSettings>> wallDecorators, Optional<List<PondSettings>> ponds, Optional<ShellSettings> shell, Optional<TunnelSettings> branches, Optional<RoomSettings> rooms, List<IBlockState> globalDecorators) {
        this.blacklistBiomes = blacklistBiomes;
        this.biomes = biomes;
        this.blacklistDimensions = blacklistDimensions;
        this.dimensions = dimensions;
        this.height = height;
        this.floor = floor;
        this.ceiling = ceiling;
        this.region = region;
        this.noise = noise;
        this.replaceableBlocks = replaceableBlocks;
        this.replaceDecorators = replaceDecorators;
        this.caveBlocks = caveBlocks;
        this.wallDecorators = wallDecorators;
        this.ponds = ponds;
        this.shell = shell;
        this.branches = branches;
        this.rooms = rooms;
        this.globalDecorators = globalDecorators;
    }

    public static OverrideSettingsBuilder builder() {
        return new OverrideSettingsBuilder();
    }

    public static final class Fields {
        public static final String blacklistBiomes = "blacklistBiomes";
        public static final String biomes = "biomes";
        public static final String blacklistDimensions = "blacklistDimensions";
        public static final String dimensions = "dimensions";
        public static final String height = "height";
        public static final String floor = "floor";
        public static final String ceiling = "ceiling";
        public static final String region = "region";
        public static final String noise = "noise";
        public static final String replaceableBlocks = "replaceableBlocks";
        public static final String replaceDecorators = "replaceDecorators";
        public static final String caveBlocks = "caveBlocks";
        public static final String wallDecorators = "wallDecorators";
        public static final String ponds = "ponds";
        public static final String shell = "shell";
        public static final String branches = "branches";
        public static final String rooms = "rooms";
        public static final String globalDecorators = "globalDecorators";

        private Fields() {
        }
    }

    public static class OverrideSettingsBuilder {
        private boolean blacklistBiomes$set;
        private Optional<Boolean> blacklistBiomes$value;
        private boolean biomes$set;
        private Optional<List<Biome>> biomes$value;
        private boolean blacklistDimensions$set;
        private Optional<Boolean> blacklistDimensions$value;
        private boolean dimensions$set;
        private Optional<List<Integer>> dimensions$value;
        private boolean height$set;
        private Optional<Range> height$value;
        private boolean floor$set;
        private Optional<NoiseMapSettings> floor$value;
        private boolean ceiling$set;
        private Optional<NoiseMapSettings> ceiling$value;
        private boolean region$set;
        private Optional<NoiseRegionSettings> region$value;
        private boolean noise$set;
        private Optional<NoiseSettings> noise$value;
        private boolean replaceableBlocks$set;
        private Optional<List<IBlockState>> replaceableBlocks$value;
        private boolean replaceDecorators$set;
        private Optional<Boolean> replaceDecorators$value;
        private boolean caveBlocks$set;
        private Optional<List<CaveBlockSettings>> caveBlocks$value;
        private boolean wallDecorators$set;
        private Optional<List<WallDecoratorSettings>> wallDecorators$value;
        private boolean ponds$set;
        private Optional<List<PondSettings>> ponds$value;
        private boolean shell$set;
        private Optional<ShellSettings> shell$value;
        private boolean branches$set;
        private Optional<TunnelSettings> branches$value;
        private boolean rooms$set;
        private Optional<RoomSettings> rooms$value;
        private boolean globalDecorators$set;
        private List<IBlockState> globalDecorators$value;

        OverrideSettingsBuilder() {
        }

        public OverrideSettingsBuilder blacklistBiomes(Optional<Boolean> blacklistBiomes) {
            this.blacklistBiomes$value = blacklistBiomes;
            this.blacklistBiomes$set = true;
            return this;
        }

        public OverrideSettingsBuilder biomes(Optional<List<Biome>> biomes) {
            this.biomes$value = biomes;
            this.biomes$set = true;
            return this;
        }

        public OverrideSettingsBuilder blacklistDimensions(Optional<Boolean> blacklistDimensions) {
            this.blacklistDimensions$value = blacklistDimensions;
            this.blacklistDimensions$set = true;
            return this;
        }

        public OverrideSettingsBuilder dimensions(Optional<List<Integer>> dimensions) {
            this.dimensions$value = dimensions;
            this.dimensions$set = true;
            return this;
        }

        public OverrideSettingsBuilder height(Optional<Range> height) {
            this.height$value = height;
            this.height$set = true;
            return this;
        }

        public OverrideSettingsBuilder floor(Optional<NoiseMapSettings> floor) {
            this.floor$value = floor;
            this.floor$set = true;
            return this;
        }

        public OverrideSettingsBuilder ceiling(Optional<NoiseMapSettings> ceiling) {
            this.ceiling$value = ceiling;
            this.ceiling$set = true;
            return this;
        }

        public OverrideSettingsBuilder region(Optional<NoiseRegionSettings> region) {
            this.region$value = region;
            this.region$set = true;
            return this;
        }

        public OverrideSettingsBuilder noise(Optional<NoiseSettings> noise) {
            this.noise$value = noise;
            this.noise$set = true;
            return this;
        }

        public OverrideSettingsBuilder replaceableBlocks(Optional<List<IBlockState>> replaceableBlocks) {
            this.replaceableBlocks$value = replaceableBlocks;
            this.replaceableBlocks$set = true;
            return this;
        }

        public OverrideSettingsBuilder replaceDecorators(Optional<Boolean> replaceDecorators) {
            this.replaceDecorators$value = replaceDecorators;
            this.replaceDecorators$set = true;
            return this;
        }

        public OverrideSettingsBuilder caveBlocks(Optional<List<CaveBlockSettings>> caveBlocks) {
            this.caveBlocks$value = caveBlocks;
            this.caveBlocks$set = true;
            return this;
        }

        public OverrideSettingsBuilder wallDecorators(Optional<List<WallDecoratorSettings>> wallDecorators) {
            this.wallDecorators$value = wallDecorators;
            this.wallDecorators$set = true;
            return this;
        }

        public OverrideSettingsBuilder ponds(Optional<List<PondSettings>> ponds) {
            this.ponds$value = ponds;
            this.ponds$set = true;
            return this;
        }

        public OverrideSettingsBuilder shell(Optional<ShellSettings> shell) {
            this.shell$value = shell;
            this.shell$set = true;
            return this;
        }

        public OverrideSettingsBuilder branches(Optional<TunnelSettings> branches) {
            this.branches$value = branches;
            this.branches$set = true;
            return this;
        }

        public OverrideSettingsBuilder rooms(Optional<RoomSettings> rooms) {
            this.rooms$value = rooms;
            this.rooms$set = true;
            return this;
        }

        public OverrideSettingsBuilder globalDecorators(List<IBlockState> globalDecorators) {
            this.globalDecorators$value = globalDecorators;
            this.globalDecorators$set = true;
            return this;
        }

        public OverrideSettings build() {
            Optional blacklistBiomes$value = this.blacklistBiomes$value;
            if (!this.blacklistBiomes$set) {
                blacklistBiomes$value = OverrideSettings.$default$blacklistBiomes();
            }
            Optional biomes$value = this.biomes$value;
            if (!this.biomes$set) {
                biomes$value = OverrideSettings.$default$biomes();
            }
            Optional blacklistDimensions$value = this.blacklistDimensions$value;
            if (!this.blacklistDimensions$set) {
                blacklistDimensions$value = OverrideSettings.$default$blacklistDimensions();
            }
            Optional dimensions$value = this.dimensions$value;
            if (!this.dimensions$set) {
                dimensions$value = OverrideSettings.$default$dimensions();
            }
            Optional height$value = this.height$value;
            if (!this.height$set) {
                height$value = OverrideSettings.$default$height();
            }
            Optional floor$value = this.floor$value;
            if (!this.floor$set) {
                floor$value = OverrideSettings.$default$floor();
            }
            Optional ceiling$value = this.ceiling$value;
            if (!this.ceiling$set) {
                ceiling$value = OverrideSettings.$default$ceiling();
            }
            Optional region$value = this.region$value;
            if (!this.region$set) {
                region$value = OverrideSettings.$default$region();
            }
            Optional noise$value = this.noise$value;
            if (!this.noise$set) {
                noise$value = OverrideSettings.$default$noise();
            }
            Optional replaceableBlocks$value = this.replaceableBlocks$value;
            if (!this.replaceableBlocks$set) {
                replaceableBlocks$value = OverrideSettings.$default$replaceableBlocks();
            }
            Optional replaceDecorators$value = this.replaceDecorators$value;
            if (!this.replaceDecorators$set) {
                replaceDecorators$value = OverrideSettings.$default$replaceDecorators();
            }
            Optional caveBlocks$value = this.caveBlocks$value;
            if (!this.caveBlocks$set) {
                caveBlocks$value = OverrideSettings.$default$caveBlocks();
            }
            Optional wallDecorators$value = this.wallDecorators$value;
            if (!this.wallDecorators$set) {
                wallDecorators$value = OverrideSettings.$default$wallDecorators();
            }
            Optional ponds$value = this.ponds$value;
            if (!this.ponds$set) {
                ponds$value = OverrideSettings.$default$ponds();
            }
            Optional shell$value = this.shell$value;
            if (!this.shell$set) {
                shell$value = OverrideSettings.$default$shell();
            }
            Optional branches$value = this.branches$value;
            if (!this.branches$set) {
                branches$value = OverrideSettings.$default$branches();
            }
            Optional rooms$value = this.rooms$value;
            if (!this.rooms$set) {
                rooms$value = OverrideSettings.$default$rooms();
            }
            List globalDecorators$value = this.globalDecorators$value;
            if (!this.globalDecorators$set) {
                globalDecorators$value = OverrideSettings.$default$globalDecorators();
            }
            return new OverrideSettings(blacklistBiomes$value, biomes$value, blacklistDimensions$value, dimensions$value, height$value, floor$value, ceiling$value, region$value, noise$value, replaceableBlocks$value, replaceDecorators$value, caveBlocks$value, wallDecorators$value, ponds$value, shell$value, branches$value, rooms$value, globalDecorators$value);
        }

        public String toString() {
            return "OverrideSettings.OverrideSettingsBuilder(blacklistBiomes$value=" + this.blacklistBiomes$value + ", biomes$value=" + this.biomes$value + ", blacklistDimensions$value=" + this.blacklistDimensions$value + ", dimensions$value=" + this.dimensions$value + ", height$value=" + this.height$value + ", floor$value=" + this.floor$value + ", ceiling$value=" + this.ceiling$value + ", region$value=" + this.region$value + ", noise$value=" + this.noise$value + ", replaceableBlocks$value=" + this.replaceableBlocks$value + ", replaceDecorators$value=" + this.replaceDecorators$value + ", caveBlocks$value=" + this.caveBlocks$value + ", wallDecorators$value=" + this.wallDecorators$value + ", ponds$value=" + this.ponds$value + ", shell$value=" + this.shell$value + ", branches$value=" + this.branches$value + ", rooms$value=" + this.rooms$value + ", globalDecorators$value=" + this.globalDecorators$value + ")";
        }
    }
}

