/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.data;

import com.personthecat.cavegenerator.data.ConditionSettings;
import com.personthecat.cavegenerator.data.NoiseMapSettings;
import com.personthecat.cavegenerator.data.OverrideSettings;
import com.personthecat.cavegenerator.model.Range;
import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.util.HjsonMapper;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import org.hjson.JsonObject;

public class LayerSettings {
    private static final String FEATURE_NAME = "layers";
    private static final NoiseMapSettings DEFAULT_NOISE = NoiseMapSettings.builder().frequency(0.015f).range(Range.of(-7, 7)).build();
    private static final ConditionSettings DEFAULT_CONDITIONS = ConditionSettings.builder().height(Range.of(0, 20)).ceiling(CommonMethods.full(DEFAULT_NOISE)).build();
    public final List<IBlockState> matchers;
    public final ConditionSettings conditions;
    public final IBlockState state;

    public static LayerSettings from(JsonObject json, OverrideSettings overrides) {
        ConditionSettings conditions = overrides.apply(DEFAULT_CONDITIONS.toBuilder()).build();
        return LayerSettings.copyInto(json, LayerSettings.builder().conditions(conditions));
    }

    public static LayerSettings from(JsonObject json) {
        return LayerSettings.copyInto(json, LayerSettings.builder());
    }

    private static LayerSettings copyInto(JsonObject json, LayerSettingsBuilder builder) {
        LayerSettings original = builder.build();
        return new HjsonMapper(json).mapRequiredState("state", FEATURE_NAME, builder::state).mapSelf(o -> builder.conditions(ConditionSettings.from(o, original.conditions))).mapStateList("matchers", builder::matchers).release(builder::build);
    }

    private static List<IBlockState> $default$matchers() {
        return Collections.singletonList(Blocks.field_150348_b.func_176223_P());
    }

    private static ConditionSettings $default$conditions() {
        return DEFAULT_CONDITIONS;
    }

    LayerSettings(List<IBlockState> matchers, ConditionSettings conditions, IBlockState state) {
        this.matchers = matchers;
        this.conditions = conditions;
        this.state = state;
    }

    public static LayerSettingsBuilder builder() {
        return new LayerSettingsBuilder();
    }

    public static final class Fields {
        public static final String matchers = "matchers";
        public static final String conditions = "conditions";
        public static final String state = "state";

        private Fields() {
        }
    }

    public static class LayerSettingsBuilder {
        private boolean matchers$set;
        private List<IBlockState> matchers$value;
        private boolean conditions$set;
        private ConditionSettings conditions$value;
        private IBlockState state;

        LayerSettingsBuilder() {
        }

        public LayerSettingsBuilder matchers(List<IBlockState> matchers) {
            this.matchers$value = matchers;
            this.matchers$set = true;
            return this;
        }

        public LayerSettingsBuilder conditions(ConditionSettings conditions) {
            this.conditions$value = conditions;
            this.conditions$set = true;
            return this;
        }

        public LayerSettingsBuilder state(IBlockState state) {
            this.state = state;
            return this;
        }

        public LayerSettings build() {
            List matchers$value = this.matchers$value;
            if (!this.matchers$set) {
                matchers$value = LayerSettings.$default$matchers();
            }
            ConditionSettings conditions$value = this.conditions$value;
            if (!this.conditions$set) {
                conditions$value = LayerSettings.$default$conditions();
            }
            return new LayerSettings(matchers$value, conditions$value, this.state);
        }

        public String toString() {
            return "LayerSettings.LayerSettingsBuilder(matchers$value=" + this.matchers$value + ", conditions$value=" + this.conditions$value + ", state=" + this.state + ")";
        }
    }
}

