/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.data;

import com.personthecat.cavegenerator.data.CaveBlockSettings;
import com.personthecat.cavegenerator.data.PondSettings;
import com.personthecat.cavegenerator.data.ShellSettings;
import com.personthecat.cavegenerator.data.WallDecoratorSettings;
import com.personthecat.cavegenerator.util.HjsonMapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import org.hjson.JsonObject;

public class DecoratorSettings {
    public static final DecoratorSettings DEFAULTS = DecoratorSettings.builder().build();
    public final List<IBlockState> replaceableBlocks;
    public final boolean replaceDecorators;
    public final boolean replaceSolidBlocks;
    public final List<CaveBlockSettings> caveBlocks;
    public final List<WallDecoratorSettings> wallDecorators;
    public final List<PondSettings> ponds;
    public final ShellSettings shell;
    public final List<IBlockState> globalDecorators;

    public static DecoratorSettings from(JsonObject json, DecoratorSettings defaults) {
        return DecoratorSettings.copyInto(json, defaults.toBuilder());
    }

    public static DecoratorSettings from(JsonObject json) {
        return DecoratorSettings.copyInto(json, DecoratorSettings.builder());
    }

    private static DecoratorSettings copyInto(JsonObject json, DecoratorSettingsBuilder builder) {
        return new HjsonMapper(json).mapStateList("replaceableBlocks", builder::replaceableBlocks).mapBool("replaceDecorators", builder::replaceDecorators).mapBool("replaceSolidBlocks", builder::replaceSolidBlocks).mapArray("caveBlocks", CaveBlockSettings::from, builder::caveBlocks).mapArray("wallDecorators", WallDecoratorSettings::from, builder::wallDecorators).mapArray("ponds", PondSettings::from, builder::ponds).mapObject("shell", o -> builder.shell(ShellSettings.from(o))).release(builder::build);
    }

    private static List<IBlockState> $default$replaceableBlocks() {
        return Arrays.asList(Blocks.field_150348_b.func_176223_P(), Blocks.field_150346_d.func_176223_P(), Blocks.field_150349_c.func_176223_P());
    }

    private static boolean $default$replaceDecorators() {
        return true;
    }

    private static boolean $default$replaceSolidBlocks() {
        return false;
    }

    private static List<CaveBlockSettings> $default$caveBlocks() {
        return Collections.emptyList();
    }

    private static List<WallDecoratorSettings> $default$wallDecorators() {
        return Collections.emptyList();
    }

    private static List<PondSettings> $default$ponds() {
        return Collections.emptyList();
    }

    private static ShellSettings $default$shell() {
        return ShellSettings.builder().build();
    }

    private static List<IBlockState> $default$globalDecorators() {
        return Collections.emptyList();
    }

    DecoratorSettings(List<IBlockState> replaceableBlocks, boolean replaceDecorators, boolean replaceSolidBlocks, List<CaveBlockSettings> caveBlocks, List<WallDecoratorSettings> wallDecorators, List<PondSettings> ponds, ShellSettings shell, List<IBlockState> globalDecorators) {
        this.replaceableBlocks = replaceableBlocks;
        this.replaceDecorators = replaceDecorators;
        this.replaceSolidBlocks = replaceSolidBlocks;
        this.caveBlocks = caveBlocks;
        this.wallDecorators = wallDecorators;
        this.ponds = ponds;
        this.shell = shell;
        this.globalDecorators = globalDecorators;
    }

    public static DecoratorSettingsBuilder builder() {
        return new DecoratorSettingsBuilder();
    }

    public DecoratorSettingsBuilder toBuilder() {
        return new DecoratorSettingsBuilder().replaceableBlocks(this.replaceableBlocks).replaceDecorators(this.replaceDecorators).replaceSolidBlocks(this.replaceSolidBlocks).caveBlocks(this.caveBlocks).wallDecorators(this.wallDecorators).ponds(this.ponds).shell(this.shell).globalDecorators(this.globalDecorators);
    }

    public static final class Fields {
        public static final String replaceableBlocks = "replaceableBlocks";
        public static final String replaceDecorators = "replaceDecorators";
        public static final String replaceSolidBlocks = "replaceSolidBlocks";
        public static final String caveBlocks = "caveBlocks";
        public static final String wallDecorators = "wallDecorators";
        public static final String ponds = "ponds";
        public static final String shell = "shell";
        public static final String globalDecorators = "globalDecorators";

        private Fields() {
        }
    }

    public static class DecoratorSettingsBuilder {
        private boolean replaceableBlocks$set;
        private List<IBlockState> replaceableBlocks$value;
        private boolean replaceDecorators$set;
        private boolean replaceDecorators$value;
        private boolean replaceSolidBlocks$set;
        private boolean replaceSolidBlocks$value;
        private boolean caveBlocks$set;
        private List<CaveBlockSettings> caveBlocks$value;
        private boolean wallDecorators$set;
        private List<WallDecoratorSettings> wallDecorators$value;
        private boolean ponds$set;
        private List<PondSettings> ponds$value;
        private boolean shell$set;
        private ShellSettings shell$value;
        private boolean globalDecorators$set;
        private List<IBlockState> globalDecorators$value;

        DecoratorSettingsBuilder() {
        }

        public DecoratorSettingsBuilder replaceableBlocks(List<IBlockState> replaceableBlocks) {
            this.replaceableBlocks$value = replaceableBlocks;
            this.replaceableBlocks$set = true;
            return this;
        }

        public DecoratorSettingsBuilder replaceDecorators(boolean replaceDecorators) {
            this.replaceDecorators$value = replaceDecorators;
            this.replaceDecorators$set = true;
            return this;
        }

        public DecoratorSettingsBuilder replaceSolidBlocks(boolean replaceSolidBlocks) {
            this.replaceSolidBlocks$value = replaceSolidBlocks;
            this.replaceSolidBlocks$set = true;
            return this;
        }

        public DecoratorSettingsBuilder caveBlocks(List<CaveBlockSettings> caveBlocks) {
            this.caveBlocks$value = caveBlocks;
            this.caveBlocks$set = true;
            return this;
        }

        public DecoratorSettingsBuilder wallDecorators(List<WallDecoratorSettings> wallDecorators) {
            this.wallDecorators$value = wallDecorators;
            this.wallDecorators$set = true;
            return this;
        }

        public DecoratorSettingsBuilder ponds(List<PondSettings> ponds) {
            this.ponds$value = ponds;
            this.ponds$set = true;
            return this;
        }

        public DecoratorSettingsBuilder shell(ShellSettings shell) {
            this.shell$value = shell;
            this.shell$set = true;
            return this;
        }

        public DecoratorSettingsBuilder globalDecorators(List<IBlockState> globalDecorators) {
            this.globalDecorators$value = globalDecorators;
            this.globalDecorators$set = true;
            return this;
        }

        public DecoratorSettings build() {
            List replaceableBlocks$value = this.replaceableBlocks$value;
            if (!this.replaceableBlocks$set) {
                replaceableBlocks$value = DecoratorSettings.$default$replaceableBlocks();
            }
            boolean replaceDecorators$value = this.replaceDecorators$value;
            if (!this.replaceDecorators$set) {
                replaceDecorators$value = DecoratorSettings.$default$replaceDecorators();
            }
            boolean replaceSolidBlocks$value = this.replaceSolidBlocks$value;
            if (!this.replaceSolidBlocks$set) {
                replaceSolidBlocks$value = DecoratorSettings.$default$replaceSolidBlocks();
            }
            List caveBlocks$value = this.caveBlocks$value;
            if (!this.caveBlocks$set) {
                caveBlocks$value = DecoratorSettings.$default$caveBlocks();
            }
            List wallDecorators$value = this.wallDecorators$value;
            if (!this.wallDecorators$set) {
                wallDecorators$value = DecoratorSettings.$default$wallDecorators();
            }
            List ponds$value = this.ponds$value;
            if (!this.ponds$set) {
                ponds$value = DecoratorSettings.$default$ponds();
            }
            ShellSettings shell$value = this.shell$value;
            if (!this.shell$set) {
                shell$value = DecoratorSettings.$default$shell();
            }
            List globalDecorators$value = this.globalDecorators$value;
            if (!this.globalDecorators$set) {
                globalDecorators$value = DecoratorSettings.$default$globalDecorators();
            }
            return new DecoratorSettings(replaceableBlocks$value, replaceDecorators$value, replaceSolidBlocks$value, caveBlocks$value, wallDecorators$value, ponds$value, shell$value, globalDecorators$value);
        }

        public String toString() {
            return "DecoratorSettings.DecoratorSettingsBuilder(replaceableBlocks$value=" + this.replaceableBlocks$value + ", replaceDecorators$value=" + this.replaceDecorators$value + ", replaceSolidBlocks$value=" + this.replaceSolidBlocks$value + ", caveBlocks$value=" + this.caveBlocks$value + ", wallDecorators$value=" + this.wallDecorators$value + ", ponds$value=" + this.ponds$value + ", shell$value=" + this.shell$value + ", globalDecorators$value=" + this.globalDecorators$value + ")";
        }
    }
}

