/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.commands;

import com.personthecat.cavegenerator.CaveInit;
import com.personthecat.cavegenerator.Main;
import com.personthecat.cavegenerator.config.CavePreset;
import com.personthecat.cavegenerator.config.ImportHelper;
import com.personthecat.cavegenerator.config.PresetCombiner;
import com.personthecat.cavegenerator.config.PresetCompressor;
import com.personthecat.cavegenerator.config.PresetExpander;
import com.personthecat.cavegenerator.config.PresetReader;
import com.personthecat.cavegenerator.config.ReferenceHelper;
import com.personthecat.cavegenerator.io.SafeFileIO;
import com.personthecat.cavegenerator.noise.CachedNoiseHelper;
import com.personthecat.cavegenerator.util.Calculator;
import com.personthecat.cavegenerator.util.CaveLinter;
import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.util.HjsonTools;
import com.personthecat.cavegenerator.world.feature.StructureSpawner;
import java.awt.Desktop;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.hjson.JsonObject;
import org.hjson.JsonValue;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CommandCave
extends CommandBase {
    private static final HoverEvent ENABLE_BUTTON_HOVER = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)CommandCave.tcs("Enable this preset."));
    private static final HoverEvent DISABLE_BUTTON_HOVER = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)CommandCave.tcs("Disable this preset."));
    private static final HoverEvent EXPLORE_BUTTON_HOVER = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)CommandCave.tcs("Explore this directory."));
    private static final HoverEvent VIEW_BUTTON_HOVER = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)CommandCave.tcs("Open preset directory."));
    private static final ClickEvent VIEW_BUTTON_CLICK = CommandCave.clickToOpen(Loader.instance().getConfigDir() + "/cavegenerator/presets");
    private static final Style ENABLE_BUTTON_STYLE = new Style().func_150238_a(TextFormatting.GREEN).func_150209_a(ENABLE_BUTTON_HOVER);
    private static final Style DISABLE_BUTTON_STYLE = new Style().func_150238_a(TextFormatting.RED).func_150209_a(DISABLE_BUTTON_HOVER);
    private static final Style ENABLED_INDICATOR_STYLE = new Style().func_150238_a(TextFormatting.GREEN);
    private static final Style DISABLED_INDICATOR_STYLE = new Style().func_150238_a(TextFormatting.RED);
    private static final Style EXPLORE_BUTTON_STYLE = new Style().func_150238_a(TextFormatting.GRAY).func_150209_a(EXPLORE_BUTTON_HOVER);
    private static final Style VIEW_BUTTON_STYLE = new Style().func_150238_a(TextFormatting.GRAY).func_150228_d(Boolean.valueOf(true)).func_150227_a(Boolean.valueOf(true)).func_150209_a(VIEW_BUTTON_HOVER).func_150241_a(VIEW_BUTTON_CLICK);
    private static final Style USAGE_HEADER_STYLE = new Style().func_150238_a(TextFormatting.GREEN).func_150227_a(Boolean.valueOf(true));
    private static final Style USAGE_STYLE = new Style().func_150238_a(TextFormatting.GRAY);
    private static final Style ERROR_STYLE = new Style().func_150238_a(TextFormatting.RED);
    private static final ITextComponent VIEW_BUTTON = CommandCave.tcs("\n --- [OPEN PRESET DIRECTORY] ---").func_150255_a(VIEW_BUTTON_STYLE);
    private static final String[][] USAGE_TEXT = new String[][]{{"reload", "Reloads the current presets from the the", "disk."}, {"list [<dir>]", "Displays a list of all presets, with buttons", "for enabling / disabling."}, {"test", "Applies night vision and gamemode 3 for easy", "cave viewing."}, {"untest", "Removes night vision and puts you in gamemode 1."}, {"jump [<k>]", "Teleports the player 1,000 * k blocks in each", "direction."}, {"display <name> [<dir>]", "Displays a linted preset in the chat."}, {"open [<name>] [<dir>]", "Opens a preset in your default text editor."}, {"ch [<scale|max>]", "Allows you to expand your chat height", "beyond the default limit of 1.0."}, {"cw [<scale|max>]", "Allows you to expand your chat width", "beyond the default limit of 1.0."}, {"combine <preset.path> <preset>", "Copies the first", "path into the second preset."}, {"enable <name> [<dir>]", "Enables the preset with name <name>."}, {"disable <name> [<dir>]", "Disables the preset with name <name>."}, {"new <name>", "Generates a new preset file with name", "<name>."}, {"copy <name> [<dir>]", "Recursively copies presets out of", "config/cavegenerator."}, {"move <name> <dir>", "Moves a preset out of the preset", "directory."}, {"delete <name> [<dir>]", "Moves a preset to the backup directory."}, {"clean [<dir>]", "Moves disabled presets to the backup directory."}, {"rename <name> <new>", "Renames a preset, ignoring its extension."}, {"expand <name> [<as>]", "Writes the expanded copy of this preset", "under /generated."}, {"compress <name> [<as>]", "Writes a compressed version of this", "preset under /generated."}, {"define <JSON>", "Defines a JSON member as a variable in memory."}, {"import <file>", "Imports variables from a file into memory."}, {"eval <exp>", "Evaluates a JSON, cave, or arithmetic expression."}, {"print [<key>] [<key2>] [...]", "Prints JSON values and comments to the chat."}, {"dir", "Displays all of the variables in memory."}, {"save <filename> [<dir>]", "Saves the in memory-definitions to a file."}, {"clear", "Clears the in-memory definitions."}, {"tojson <name>", "Backs up and converts the specified", "file from hjson to standard JSON."}, {"tohjson <name>", "Backs up and converts the specified", "file from standard JSON to hjson."}};
    private static final int USAGE_LENGTH = 7;
    private static final String USAGE_HEADER = " --- Cave Command Usage (X / Y) ---";
    private static final ITextComponent[] USAGE_MSG = CommandCave.createHelpMessage();
    private final JsonObject memory = new JsonObject();

    public String func_71517_b() {
        return "cave";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/cave <subcommand>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        block4: {
            if (args.length == 0) {
                CommandCave.displayHelp(sender, 1);
                return;
            }
            int splitIndex = ArrayUtils.lastIndexOf((Object[])args, (Object)"&&");
            if (splitIndex > 0 && args.length > splitIndex) {
                String[] runFirst = (String[])ArrayUtils.subarray((Object[])args, (int)0, (int)splitIndex);
                args = (String[])ArrayUtils.subarray((Object[])args, (int)(splitIndex + 1), (int)args.length);
                this.func_184881_a(server, sender, runFirst);
            }
            try {
                String[] slice = (String[])ArrayUtils.subarray((Object[])args, (int)1, (int)args.length);
                this.handle(server, sender, args[0], slice);
            }
            catch (RuntimeException e) {
                CommandCave.sendError(sender, e.getMessage());
                if (e.getCause() == null) break block4;
                CommandCave.sendError(sender, CommonMethods.f("Cause: {}", e.getCause().getMessage()));
            }
        }
    }

    private void handle(MinecraftServer server, ICommandSender sender, String command, String[] args) {
        switch (command) {
            case "reload": {
                CommandCave.reload(server, sender);
                break;
            }
            case "list": {
                CommandCave.list(sender, args);
                break;
            }
            case "listRaw": {
                CommandCave.listRaw(sender, args);
                break;
            }
            case "test": {
                CommandCave.test(sender);
                break;
            }
            case "untest": {
                CommandCave.untest(sender);
                break;
            }
            case "jump": {
                CommandCave.jump(server, sender, args);
                break;
            }
            case "display": {
                CommandCave.display(sender, args);
                break;
            }
            case "open": {
                CommandCave.open(sender, args);
                break;
            }
            case "ch": {
                CommandCave.chatHeight(server, sender, args);
                break;
            }
            case "cw": {
                CommandCave.chatWidth(server, sender, args);
                break;
            }
            case "combine": {
                CommandCave.combine(sender, args);
                break;
            }
            case "enable": {
                CommandCave.enbableOrDisable(sender, args, true);
                break;
            }
            case "disable": {
                CommandCave.enbableOrDisable(sender, args, false);
                break;
            }
            case "new": {
                CommandCave.newPreset(sender, args);
                break;
            }
            case "copy": {
                CommandCave.copyPreset(sender, args);
                break;
            }
            case "move": {
                CommandCave.movePreset(sender, args);
                break;
            }
            case "delete": {
                CommandCave.deletePreset(sender, args);
                break;
            }
            case "clean": {
                CommandCave.cleanPresets(sender, args);
                break;
            }
            case "rename": {
                CommandCave.renamePreset(sender, args);
                break;
            }
            case "expand": {
                CommandCave.writeExpanded(sender, args);
                break;
            }
            case "compress": {
                CommandCave.writeCompressed(sender, args);
                break;
            }
            case "set": 
            case "define": {
                this.define(sender, args);
                break;
            }
            case "import": {
                this.importPreset(sender, args);
                break;
            }
            case "eval": {
                this.evaluate(sender, args);
                break;
            }
            case "print": {
                this.print(sender, args);
                break;
            }
            case "dir": {
                this.displayMemory(sender);
                break;
            }
            case "save": {
                this.saveMemory(sender, args);
                break;
            }
            case "clear": {
                this.clearMemory(sender);
                break;
            }
            case "tojson": {
                CommandCave.convert(sender, args, true);
                break;
            }
            case "tohjson": {
                CommandCave.convert(sender, args, false);
                break;
            }
            case "page": 
            case "help": {
                CommandCave.helpCommand(sender, args);
                break;
            }
            default: {
                CommandCave.helpCommand(sender, command);
            }
        }
    }

    private static void displayHelp(ICommandSender sender, int page) {
        if (page > USAGE_MSG.length || page <= 0) {
            CommandCave.sendMessage(sender, "Invalid page #.");
            return;
        }
        sender.func_145747_a(USAGE_MSG[page - 1]);
    }

    private static void reload(MinecraftServer server, ICommandSender sender) {
        CaveInit.initPresets(Main.instance.presets);
        Main.instance.generators.clear();
        Main.instance.structures.clear();
        CachedNoiseHelper.removeAll();
        StructureSpawner.loadAllStructures(Main.instance.structures);
        if (sender.func_130014_f_().field_73011_w.getDimension() != 0) {
            Main.instance.loadGenerators((World)server.func_71218_a(0));
        }
        Main.instance.loadGenerators(sender.func_130014_f_());
        CommandCave.sendMessage(sender, "Successfully reloaded caves. View the log for diagnostics.");
    }

    private static void test(ICommandSender sender) {
        Entity entity = sender.func_174793_f();
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            player.func_71033_a(GameType.SPECTATOR);
            player.func_70690_d(CommandCave.getNightVision());
        }
    }

    private static void untest(ICommandSender sender) {
        Entity entity = sender.func_174793_f();
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            player.func_71033_a(GameType.CREATIVE);
            player.func_184596_c(CommandCave.getNightVision().func_188419_a());
        }
    }

    private static void jump(MinecraftServer server, ICommandSender sender, String[] args) {
        ICommandManager mgr = server.func_71187_D();
        int distance = 1000;
        if (args.length > 0) {
            distance = (int)((float)distance * Float.parseFloat(args[0]));
        }
        mgr.func_71556_a(sender, CommonMethods.f("/tp ~{} ~ ~{}", distance, distance));
    }

    private static void display(ICommandSender sender, String[] args) {
        CommandCave.requireArgs(args, 1);
        File located = CommandCave.locateFile(args);
        Optional<JsonObject> preset = PresetReader.getPresetJson(located);
        if (preset.isPresent()) {
            JsonValue.setEol("\n");
            sender.func_145747_a(CaveLinter.lint(preset.get().toString(HjsonTools.FORMATTER)));
            JsonValue.setEol(System.getProperty("line.separator"));
        } else {
            CommandCave.sendError(sender, "Error reading preset.");
        }
    }

    private static void open(ICommandSender sender, String[] args) {
        File located = args.length == 0 ? CaveInit.PRESET_DIR : CommandCave.locateFile(args);
        try {
            Desktop.getDesktop().open(located);
        }
        catch (IOException e) {
            CommandCave.sendError(sender, e.getMessage());
        }
    }

    private static void chatHeight(MinecraftServer server, ICommandSender sender, String[] args) {
        if (server.func_71264_H()) {
            float scale;
            Minecraft mc = Minecraft.func_71410_x();
            GameSettings cfg = mc.field_71474_y;
            if (args.length == 0) {
                CommandCave.sendMessage(sender, "Current chat height: " + cfg.field_96694_H);
                return;
            }
            float possible = ((float)mc.field_71440_d / (float)cfg.field_74335_Z - 20.0f) / 180.0f;
            cfg.field_96694_H = scale = "max".equals(args[0]) ? possible : CommandCave.parseChatHeight(mc, cfg, possible, args[0]);
            cfg.func_74303_b();
            CommandCave.sendMessage(sender, "Updated chat height: " + scale);
        }
    }

    private static float parseChatHeight(Minecraft mc, GameSettings cfg, float possible, String arg) {
        float scale;
        try {
            scale = Float.parseFloat(arg);
        }
        catch (NumberFormatException ignored) {
            throw CommonMethods.runEx("Not a number: " + arg);
        }
        if ((double)scale < 0.25 || (double)scale > 5.0) {
            throw CommonMethods.runEx("<scale> should be a range of 0.25 ~ 5.0");
        }
        float chatHeight = (scale * 180.0f + 20.0f) * (float)cfg.field_74335_Z;
        if (chatHeight > (float)mc.field_71440_d) {
            throw CommonMethods.runExF("Max size is {} with your window and gui scale.", Float.valueOf(possible));
        }
        return scale;
    }

    private static void chatWidth(MinecraftServer server, ICommandSender sender, String[] args) {
        if (server.func_71264_H()) {
            float scale;
            Minecraft mc = Minecraft.func_71410_x();
            GameSettings cfg = mc.field_71474_y;
            if (args.length == 0) {
                CommandCave.sendMessage(sender, "Current chat width: " + cfg.field_96692_F);
                return;
            }
            float possible = (float)mc.field_71443_c / (float)cfg.field_74335_Z / 320.0f;
            cfg.field_96692_F = scale = "max".equals(args[0]) ? possible : CommandCave.parseChatWidth(mc, cfg, possible, args[0]);
            cfg.func_74303_b();
            CommandCave.sendMessage(sender, "Updated chat width: " + scale);
        }
    }

    private static float parseChatWidth(Minecraft mc, GameSettings cfg, float possible, String arg) {
        float scale;
        try {
            scale = Float.parseFloat(arg);
        }
        catch (NumberFormatException ignored) {
            throw CommonMethods.runEx("Not a number: " + arg);
        }
        if ((double)scale < 0.25 || (double)scale > 3.0) {
            throw CommonMethods.runEx("<scale> should be a range of 0.25 ~ 3.0");
        }
        float chatWidth = scale * 320.0f * (float)cfg.field_74335_Z;
        if (chatWidth > (float)mc.field_71443_c) {
            throw CommonMethods.runExF("Max size is {} with your window and gui scale", Float.valueOf(possible));
        }
        return scale;
    }

    private static void combine(ICommandSender sender, String[] args) {
        CommandCave.requireArgs(args, 2);
        PresetCombiner.combine(args[0], args[1]);
        CommandCave.sendMessage(sender, "Finished combining presets. The original was moved to the backup directory.");
    }

    private static void enbableOrDisable(ICommandSender sender, String[] args, boolean enabled) {
        CommandCave.requireArgs(args, 1);
        File located = CommandCave.locateFile(args);
        File dir = located.getParentFile();
        String key = "enabled";
        PresetReader.getPresetJson(located).ifPresent(cave -> {
            if (cave.has("enabled")) {
                cave.set("enabled", enabled);
            } else {
                cave.add("enabled", enabled, "Whether the preset is enabled globally.");
            }
            File f = enabled && dir != CaveInit.PRESET_DIR ? new File(CaveInit.PRESET_DIR, located.getName()) : located;
            HjsonTools.writeJson(cave, f).expectF("Error writing to {}", f.getName());
        });
        CommandCave.sendMessage(sender, "Preset " + (enabled ? "enabled" : "disabled") + " successfully.");
    }

    private static void list(ICommandSender sender, String[] args) {
        File dir;
        File file = dir = args.length > 0 ? new File(CaveInit.CG_DIR, args[0]) : CaveInit.PRESET_DIR;
        if (dir.exists()) {
            CommandCave.listRaw(sender, dir.getPath());
        } else {
            CommandCave.displayDirectories(sender);
        }
    }

    private static void listRaw(ICommandSender sender, String ... args) {
        CommandCave.requireArgs(args, 1);
        File dir = new File(args[0]);
        ITextComponent msg = CommandCave.tcs("").func_150257_a(VIEW_BUTTON.func_150259_f()).func_150257_a((ITextComponent)CommandCave.tcs("\n"));
        ArrayList<File> directories = new ArrayList<File>();
        ArrayList<File> enabled = new ArrayList<File>();
        ArrayList disabled = new ArrayList();
        directories.add(dir.getParentFile());
        for (File file : SafeFileIO.listFiles(dir).orElseGet(() -> new File[0])) {
            if (CaveInit.validExtension(file)) {
                (CommandCave.isPresetEnabled(file) ? enabled : disabled).add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            directories.add(file);
        }
        directories.forEach(f -> msg.func_150257_a(CommandCave.getViewDirectoryText(f)));
        enabled.forEach(f -> msg.func_150257_a(CommandCave.getListElementText(f, true)));
        disabled.forEach(f -> msg.func_150257_a(CommandCave.getListElementText(f, false)));
        sender.func_145747_a(msg);
    }

    private static void newPreset(ICommandSender sender, String[] args) {
        CommandCave.requireArgs(args, 1);
        String presetName = CommonMethods.noExtension(args[0]) + ".cave";
        File presetFile = new File(CaveInit.PRESET_DIR, presetName);
        if (SafeFileIO.fileExists(presetFile, "Unable to read from the preset directory.")) {
            CommandCave.sendMessage(sender, "This preset already exists.");
            return;
        }
        JsonObject preset = new JsonObject().add("enabled", true);
        HjsonTools.writeJson(preset, presetFile);
        CommandCave.sendMessage(sender, "Finished writing a new preset file.");
    }

    private static void copyPreset(ICommandSender sender, String[] args) {
        Optional<File> located;
        CommandCave.requireArgs(args, 1);
        if (args.length > 1) {
            File dir = new File(CaveInit.CG_DIR, args[1]);
            located = CaveInit.locatePreset(dir, args[0]);
        } else {
            located = CommandCave.locateRecursively(CaveInit.CG_DIR, args[0]);
        }
        if (located.isPresent()) {
            File f = located.get();
            SafeFileIO.copy(f, CaveInit.PRESET_DIR).throwIfPresent();
            String relativePath = f.getPath().replace(CaveInit.CG_DIR.getPath(), "");
            CommandCave.sendMessage(sender, "Successfully copied " + relativePath);
        } else {
            CommandCave.sendError(sender, "File not found.");
        }
    }

    private static void movePreset(ICommandSender sender, String[] args) {
        CommandCave.requireArgs(args, 2);
        Optional<File> located = CaveInit.locatePreset(args[0]);
        if (located.isPresent()) {
            File f = located.get();
            File dir = new File(CaveInit.CG_DIR, args[1]);
            if (!dir.exists()) {
                SafeFileIO.ensureDirExists(dir).throwIfPresent();
                CommandCave.sendMessage(sender, CommonMethods.f("Created folder: {}", dir.getName()));
            }
            SafeFileIO.copy(f, dir).throwIfPresent();
            if (!f.delete()) {
                CommandCave.sendError(sender, "Original could not be deleted.");
            }
            CommandCave.sendMessage(sender, CommonMethods.f("The file was moved to {}/{}", dir.getName(), f.getName()));
        } else {
            CommandCave.sendError(sender, "File not found.");
        }
    }

    private static void deletePreset(ICommandSender sender, String[] args) {
        CommandCave.requireArgs(args, 1);
        File located = CommandCave.locateFile(args);
        SafeFileIO.backup(located, true);
        CommandCave.sendMessage(sender, located.getName() + " was moved to backups.");
    }

    private static void cleanPresets(ICommandSender sender, String[] args) {
        File dir;
        File file = dir = args.length > 0 ? new File(CaveInit.CG_DIR, args[0]) : CaveInit.PRESET_DIR;
        if (!dir.exists()) {
            CommandCave.displayDirectories(sender);
        } else if (dir.equals(CaveInit.BACKUP_DIR)) {
            CommandCave.deleteFiles(sender, args, dir);
        } else {
            CommandCave.backupFiles(sender, dir);
        }
    }

    private static void deleteFiles(ICommandSender sender, String[] args, File dir) {
        int numDeleted = 0;
        if (args.length > 1 && "force".equalsIgnoreCase(args[1])) {
            for (File f : SafeFileIO.listFiles(dir, CaveInit::validExtension).orElseGet(() -> new File[0])) {
                if (!f.delete()) {
                    throw CommonMethods.runExF("Error deleting {}", f.getName());
                }
                ++numDeleted;
            }
            if (numDeleted > 0) {
                CommandCave.sendMessage(sender, CommonMethods.f("{} preset(s) were permanently deleted.", numDeleted));
            } else {
                CommandCave.sendMessage(sender, CommonMethods.f("There were no files to delete.", new Object[0]));
            }
        } else {
            CommandCave.sendMessage(sender, "Rerun with \"force\" to delete backups.");
        }
    }

    private static void backupFiles(ICommandSender sender, File dir) {
        int numDisabled = 0;
        for (File f : SafeFileIO.listFiles(dir, CaveInit::validExtension).orElseGet(() -> new File[0])) {
            if (CommandCave.isPresetEnabled(f)) continue;
            SafeFileIO.backup(f, true);
            ++numDisabled;
        }
        if (numDisabled > 0) {
            CommandCave.sendMessage(sender, CommonMethods.f("{} preset(s) were moved to backups.", numDisabled));
        } else {
            CommandCave.sendMessage(sender, CommonMethods.f("There are no disabled presets in {}.", dir.getName()));
        }
    }

    private static void renamePreset(ICommandSender sender, String[] args) {
        CommandCave.requireArgs(args, 2);
        Optional<File> located = CaveInit.locatePreset(args[0]);
        if (located.isPresent()) {
            File file = located.get();
            String name = CommonMethods.noExtension(args[1]) + "." + CommonMethods.extension(file);
            SafeFileIO.rename(file, name);
            CommandCave.sendMessage(sender, CommonMethods.f("{} was renamed to {}", file.getName(), name));
        } else {
            CommandCave.sendError(sender, "File not found.");
        }
    }

    private static void writeExpanded(ICommandSender sender, String[] args) {
        CommandCave.requireArgs(args, 1);
        String presetName = CommonMethods.noExtension(args[0]);
        CavePreset settings = CommonMethods.nullable(Main.instance.presets.get(presetName)).orElseThrow(() -> CommonMethods.runExF("Unable to find preset: {}", args[0]));
        String newName = args.length > 1 ? CommonMethods.noExtension(args[1]) : presetName;
        SafeFileIO.ensureDirExists(CaveInit.GENERATED_DIR).expect("Error creating /generated directory.");
        File expanded = new File(CaveInit.GENERATED_DIR, newName + ".cave");
        HjsonTools.writeJson(settings.raw, expanded);
        CommandCave.sendMessage(sender, "Finished writing expanded preset file.");
    }

    private static void writeCompressed(ICommandSender sender, String[] args) {
        CommandCave.requireArgs(args, 1);
        String presetName = CommonMethods.noExtension(args[0]);
        File preset = CaveInit.locatePreset(presetName).orElseThrow(() -> CommonMethods.runExF("Unable to find preset: {}", args[0]));
        String newName = args.length > 1 ? CommonMethods.noExtension(args[1]) : presetName;
        JsonObject original = PresetReader.getPresetJson(preset).orElseThrow(() -> CommonMethods.runExF("Error reading {}", presetName));
        SafeFileIO.ensureDirExists(CaveInit.GENERATED_DIR).expect("Error creating /generated directory.");
        File compressed = new File(CaveInit.GENERATED_DIR, newName + ".json");
        try (FileWriter writer = new FileWriter(compressed);){
            PresetCompressor.compress(original);
            original.writeTo(writer);
            CommandCave.sendMessage(sender, "Finished writing expanded preset file.");
        }
        catch (IOException e) {
            CommandCave.sendError(sender, "Error writing new preset.");
        }
    }

    private void define(ICommandSender sender, String[] args) {
        CommandCave.requireArgs(args, 1);
        String exp = String.join((CharSequence)" ", args).replace("\\n", "\n").replace("\\\\", "\\");
        JsonValue value = JsonObject.readHjson(exp, HjsonTools.FORMATTER);
        if (!value.isObject()) {
            CommandCave.sendMessage(sender, "Missing key.");
            return;
        }
        JsonObject object = value.asObject();
        if (object.isEmpty()) {
            CommandCave.sendMessage(sender, "Nothing to load.");
        } else {
            CommandCave.sendMessage(sender, "Writing...");
            for (JsonObject.Member member : object) {
                this.memory.set(member.getName(), member.getValue());
                CommandCave.sendMessage(sender, " * " + member.getName());
            }
        }
    }

    private void importPreset(ICommandSender sender, String[] args) {
        CommandCave.requireArgs(args, 1);
        JsonObject data = new JsonObject();
        this.expandFauxPreset(data, String.join((CharSequence)" ", args));
        if (data.isEmpty()) {
            CommandCave.sendMessage(sender, "Nothing to import.");
        } else {
            CommandCave.sendMessage(sender, "Loading...");
            for (JsonObject.Member member : data) {
                this.memory.add(member.getName(), member.getValue());
                CommandCave.sendMessage(sender, " * " + member.getName());
            }
        }
    }

    private void expandFauxPreset(JsonObject data, String exp) {
        JsonObject fauxPreset = new JsonObject().add("imports", exp).add("variables", data);
        HashMap<File, JsonObject> presets = new HashMap<File, JsonObject>();
        presets.put(CaveInit.PRESET_DIR, fauxPreset);
        Map<File, JsonObject> definitions = ImportHelper.locateDefinitions(exp);
        definitions.putIfAbsent(new File(CaveInit.IMPORT_DIR, "defaults.cave"), new JsonObject());
        PresetExpander.expandAll(presets, definitions);
        data.remove("VANILLA");
    }

    private void evaluate(ICommandSender sender, String[] args) {
        CommandCave.requireArgs(args, 1);
        String exp = String.join((CharSequence)" ", args);
        if (Calculator.isExpression(exp)) {
            CommandCave.sendMessage(sender, String.valueOf(Calculator.evaluate(exp)));
            return;
        }
        JsonValue result = ReferenceHelper.trySubstitute(this.memory, exp).orElseGet(() -> JsonObject.readHjson(exp));
        this.sendCalculated(sender, result);
    }

    private void sendCalculated(ICommandSender sender, JsonValue value) {
        ITextComponent result;
        if (value.isArray()) {
            PresetExpander.calculateAll(value.asArray());
        } else if (value.isObject()) {
            PresetExpander.calculateAll(value.asObject());
        }
        if (value.isString() && Calculator.isExpression(value.asString())) {
            result = CommandCave.tcs(String.valueOf(Calculator.evaluate(value.asString())));
        } else {
            JsonValue.setEol("\n");
            result = CaveLinter.lint(value.toString(HjsonTools.FORMATTER));
            JsonValue.setEol(System.getProperty("line.separator"));
        }
        sender.func_145747_a(result);
    }

    private void print(ICommandSender sender, String[] args) {
        if (args.length == 0) {
            sender.func_145747_a(CaveLinter.lint(this.memory.toString(HjsonTools.FORMATTER)));
            return;
        }
        JsonObject output = new JsonObject();
        for (String arg : args) {
            Optional<Pair<String, JsonValue>> member = this.getMember(arg);
            if (!member.isPresent()) {
                if (arg.contains("$")) {
                    CommandCave.sendError(sender, "Not an evaluator. Use a key.");
                } else {
                    CommandCave.sendError(sender, "undefined");
                }
                return;
            }
            Pair<String, JsonValue> m = member.get();
            output.add((String)m.getKey(), (JsonValue)m.getValue());
        }
        sender.func_145747_a(CaveLinter.lint(output.toString(HjsonTools.FORMATTER)));
    }

    private Optional<Pair<String, JsonValue>> getMember(String arg) {
        JsonValue value = this.memory.get(arg);
        if (value == null && (value = this.memory.get(arg = arg + "()")) == null) {
            return CommonMethods.empty();
        }
        return CommonMethods.full(Pair.of((Object)arg, (Object)value));
    }

    private void displayMemory(ICommandSender sender) {
        if (this.memory.isEmpty()) {
            CommandCave.sendMessage(sender, "[]");
            return;
        }
        StringBuilder sb = new StringBuilder("[");
        for (JsonObject.Member member : this.memory) {
            sb.append(' ');
            sb.append(member.getName());
            sb.append(',');
        }
        CommandCave.sendMessage(sender, sb.append(" ]").toString());
    }

    private void saveMemory(ICommandSender sender, String[] args) {
        CommandCave.requireArgs(args, 1);
        File dir = args.length > 1 ? new File(CaveInit.CG_DIR, args[1]) : CaveInit.IMPORT_DIR;
        String filename = CommonMethods.extension(args[0]).isEmpty() ? args[0] + ".cave" : args[0];
        HjsonTools.writeJson(this.memory, new File(dir, filename));
        CommandCave.sendMessage(sender, "Recorded file to " + dir.getName());
    }

    private void clearMemory(ICommandSender sender) {
        this.memory.clear();
        CommandCave.sendMessage(sender, "JSON data were cleared from memory.");
    }

    private static void convert(ICommandSender sender, String[] args, boolean toJson) {
        CommandCave.requireArgs(args, 1);
        Optional<File> preset = CaveInit.locatePreset(args[0]);
        if (!preset.isPresent()) {
            CommandCave.sendError(sender, "No preset found named " + args[0]);
            return;
        }
        File presetFile = preset.get();
        if (toJson == CommonMethods.extension(presetFile).equals("json")) {
            CommandCave.sendError(sender, "Preset is already in the desired format.");
            return;
        }
        Optional<JsonObject> json = PresetReader.getPresetJson(presetFile);
        if (!json.isPresent()) {
            CommandCave.sendError(sender, "The file could not be parsed.");
            return;
        }
        String extension = toJson ? ".json" : ".cave";
        File newPreset = new File(CaveInit.PRESET_DIR, CommonMethods.noExtension(presetFile) + extension);
        HjsonTools.writeJson(json.get(), newPreset);
        SafeFileIO.backup(presetFile);
        if (!presetFile.delete()) {
            CommandCave.sendMessage(sender, "Converted successfully. The original could not be deleted.");
        } else {
            CommandCave.sendMessage(sender, "Converted successfully. The original was moved to the backup directory.");
        }
    }

    private static void helpCommand(ICommandSender sender, String ... args) {
        CommandCave.requireArgs(args, 1);
        String arg = args[0];
        int page = StringUtils.isNumeric((CharSequence)arg) ? Integer.parseInt(arg) : 1;
        CommandCave.displayHelp(sender, page);
    }

    private static ITextComponent getListElementText(File file, boolean enabled) {
        String dir = CommandCave.getRelativeDir(file.getParentFile());
        String filename = CommonMethods.noExtension(file);
        Style openButton = new Style().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)CommandCave.tcs("Open " + file.getName() + "."))).func_150241_a(CommandCave.clickToOpen(file.getPath()));
        if (enabled) {
            return CommandCave.tcs("\n").func_150257_a(CommandCave.tcs(" + ").func_150255_a(ENABLED_INDICATOR_STYLE)).func_150257_a(CommandCave.tcs(filename + " ").func_150255_a(openButton)).func_150257_a(CommandCave.disableButton(filename, dir));
        }
        return CommandCave.tcs("\n").func_150257_a(CommandCave.tcs(" - ").func_150255_a(DISABLED_INDICATOR_STYLE)).func_150257_a(CommandCave.tcs(filename + " ").func_150255_a(openButton)).func_150257_a(CommandCave.enableButton(filename, dir));
    }

    private static ITextComponent getViewDirectoryText(File file) {
        return CommandCave.tcs("\n / " + file.getName() + " ").func_150257_a(CommandCave.viewButton(file.getPath()));
    }

    private static String getRelativeDir(File file) {
        String path = file.getPath();
        String cgPath = CaveInit.CG_DIR.getPath();
        return path.substring(cgPath.length());
    }

    private static boolean isPresetEnabled(File file) {
        return PresetReader.getPresetJson(file).flatMap(preset -> HjsonTools.getBool(preset, "enabled")).orElse(true);
    }

    private static File locateFile(String[] args) {
        if (args.length > 1) {
            File dir = new File(CaveInit.CG_DIR, args[1]);
            Optional<File> located = CaveInit.locatePreset(dir, args[0]);
            return located.orElseThrow(() -> CommonMethods.runEx("File not found."));
        }
        Optional<File> located = CaveInit.locatePreset(CaveInit.PRESET_DIR, args[0]);
        return located.orElseGet(() -> CommandCave.locateRecursively(CaveInit.CG_DIR, args[0]).orElseThrow(() -> CommonMethods.runEx("File not found.")));
    }

    private static Optional<File> locateRecursively(File dir, String name) {
        for (File f : SafeFileIO.listFiles(dir).orElseGet(() -> new File[0])) {
            if (f.isDirectory()) {
                Optional<File> inDir = CommandCave.locateRecursively(f, name);
                if (!inDir.isPresent()) continue;
                return inDir;
            }
            if (!CaveInit.validExtension(f) || !CommonMethods.noExtension(f).equals(name)) continue;
            return CommonMethods.full(f);
        }
        return CommonMethods.empty();
    }

    private static ITextComponent[] createHelpMessage() {
        ArrayList<TextComponentString> msgs = new ArrayList<TextComponentString>();
        int numLines = CommandCave.getNumElements(USAGE_TEXT) - USAGE_TEXT.length;
        int numPages = numLines / 7 - 1;
        for (int i = 0; i < USAGE_TEXT.length; i += 7) {
            TextComponentString header = CommandCave.getUsageHeader(i / 7 + 1, numPages);
            for (int j = i; j < i + 7 && j < USAGE_TEXT.length; ++j) {
                String[] full = USAGE_TEXT[j];
                header.func_150258_a("\n");
                CommandCave.appendUsageText((ITextComponent)header, full[0], full[1]);
                for (int k = 2; k < full.length; ++k) {
                    header.func_150257_a(CommandCave.tcs("\n " + full[k]).func_150255_a(USAGE_STYLE));
                }
            }
            msgs.add(header);
        }
        return (ITextComponent[])CommonMethods.toArray(msgs, TextComponentString.class);
    }

    private static int getNumElements(String[][] matrix) {
        int numElements = 0;
        for (String[] array : matrix) {
            numElements += array.length;
        }
        return numElements;
    }

    private static TextComponentString getUsageHeader(int page, int max) {
        String header = USAGE_HEADER.replace("X", String.valueOf(page)).replace("Y", String.valueOf(max));
        TextComponentString full = CommandCave.tcs("");
        TextComponentString headerTCS = CommandCave.tcs(header);
        headerTCS.func_150255_a(USAGE_HEADER_STYLE);
        full.func_150257_a((ITextComponent)headerTCS);
        return full;
    }

    private static void appendUsageText(ITextComponent msg, String command, String usage) {
        msg.func_150257_a(CommandCave.usageText(command, usage));
    }

    private static ITextComponent usageText(String command, String usage) {
        TextComponentString msg = CommandCave.tcs("");
        msg.func_150257_a((ITextComponent)CommandCave.tcs(command));
        msg.func_150257_a(CommandCave.tcs(" :\n " + usage).func_150255_a(USAGE_STYLE));
        return msg;
    }

    private static ITextComponent enableButton(String fileName, String dir) {
        Style style = ENABLE_BUTTON_STYLE.func_150206_m().func_150241_a(CommandCave.clickToRun("/cave enable " + fileName + " " + dir + " && reload && list"));
        return CommandCave.tcs("[ENABLE]").func_150255_a(style);
    }

    private static ITextComponent disableButton(String fileName, String dir) {
        Style style = DISABLE_BUTTON_STYLE.func_150206_m().func_150241_a(CommandCave.clickToRun("/cave disable " + fileName + " " + dir + " && reload && list"));
        return CommandCave.tcs("[DISABLE]").func_150255_a(style);
    }

    private static ITextComponent viewButton(String dir) {
        Style style = EXPLORE_BUTTON_STYLE.func_150206_m().func_150241_a(CommandCave.clickToRun("/cave listRaw " + dir));
        return CommandCave.tcs("[VIEW]").func_150255_a(style);
    }

    private static ClickEvent clickToRun(String command) {
        return new ClickEvent(ClickEvent.Action.RUN_COMMAND, command);
    }

    private static ClickEvent clickToOpen(String path) {
        return new ClickEvent(ClickEvent.Action.OPEN_FILE, path);
    }

    private static void displayDirectories(ICommandSender user) {
        ArrayList<String> names = new ArrayList<String>();
        for (File f : SafeFileIO.listFiles(CaveInit.CG_DIR, File::isDirectory).orElseGet(() -> new File[0])) {
            names.add(f.getName());
        }
        String options = Arrays.toString(names.toArray(new String[0]));
        CommandCave.sendError(user, CommonMethods.f("Invalid directory. Options: {}", options));
    }

    private static void sendMessage(ICommandSender user, String msg) {
        user.func_145747_a((ITextComponent)CommandCave.tcs(msg));
    }

    private static void sendError(ICommandSender user, String msg) {
        user.func_145747_a(CommandCave.tcs(msg).func_150255_a(ERROR_STYLE));
    }

    private static TextComponentString tcs(String s) {
        return new TextComponentString(s);
    }

    private static PotionEffect getNightVision() {
        Potion potion = Potion.func_180142_b((String)"night_vision");
        Objects.requireNonNull(potion, "Build error: invalid potion ID.");
        return new PotionEffect(potion, Integer.MAX_VALUE, 0, true, false);
    }

    private static void requireArgs(String[] args, int num) {
        if (args.length < num) {
            throw CommonMethods.runEx("Insufficient arguments for this command.");
        }
    }
}

