/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator;

import com.personthecat.cavegenerator.CaveInit;
import com.personthecat.cavegenerator.commands.CommandCave;
import com.personthecat.cavegenerator.config.CavePreset;
import com.personthecat.cavegenerator.io.JarFiles;
import com.personthecat.cavegenerator.noise.CachedNoiseHelper;
import com.personthecat.cavegenerator.world.GeneratorController;
import com.personthecat.cavegenerator.world.event.DisablePopulateChunkEvent;
import com.personthecat.cavegenerator.world.event.DisableVanillaStoneGen;
import com.personthecat.cavegenerator.world.event.ReplaceVanillaCaveGen;
import com.personthecat.cavegenerator.world.feature.FeatureCaveHook;
import com.personthecat.cavegenerator.world.feature.StructureSpawner;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.command.ICommand;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="cavegenerator", name="Cave Generator", version="1.1", dependencies="after:worleycaves;", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.12.2]")
public class Main {
    private static final Logger log = LogManager.getLogger(Main.class);
    @Mod.Instance
    public static Main instance;
    public static final String MODID = "cavegenerator";
    public final Map<String, GeneratorController> generators = new TreeMap<String, GeneratorController>();
    public final Map<String, CavePreset> presets = new TreeMap<String, CavePreset>();
    public final Map<String, Template> structures = new HashMap<String, Template>();

    @Mod.EventHandler
    public static void init(FMLInitializationEvent event) {
        JarFiles.copyFiles();
        StructureSpawner.loadAllStructures(Main.instance.structures);
        CaveInit.initPresets(Main.instance.presets);
        MinecraftForge.EVENT_BUS.register(CaveInit.class);
        MinecraftForge.TERRAIN_GEN_BUS.register(ReplaceVanillaCaveGen.class);
        MinecraftForge.ORE_GEN_BUS.register(DisableVanillaStoneGen.class);
        MinecraftForge.TERRAIN_GEN_BUS.register(DisablePopulateChunkEvent.class);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new FeatureCaveHook(), (int)0);
        log.info("Cave Generator init phase complete.");
    }

    @Mod.EventHandler
    public static void onServerStartingEvent(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandCave());
        log.info("Cave Generator commands registered.");
    }

    @Mod.EventHandler
    public static void onServerStoppingEvent(FMLServerStoppingEvent event) {
        log.info("Unloading generators.");
        Main.instance.generators.clear();
        CachedNoiseHelper.removeAll();
    }

    public Map<String, GeneratorController> loadGenerators(World world) {
        if (this.presets.isEmpty()) {
            return this.generators;
        }
        if (this.generators.isEmpty()) {
            for (Map.Entry<String, CavePreset> entry : this.presets.entrySet()) {
                CavePreset preset = entry.getValue();
                if (!preset.enabled) continue;
                world.field_73012_v.setSeed(world.func_72905_C());
                this.generators.put(entry.getKey(), GeneratorController.from(preset, world));
            }
        }
        return this.generators;
    }
}

