/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tools;

import com.direwolf20.buildinggadgets.common.blocks.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.blocks.EffectBlock;
import com.direwolf20.buildinggadgets.common.config.SyncedConfig;
import com.direwolf20.buildinggadgets.common.integration.NetworkProvider;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetBuilding;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetExchanger;
import com.direwolf20.buildinggadgets.common.network.PacketRotateMirror;
import com.direwolf20.buildinggadgets.common.tools.BuildingModes;
import com.direwolf20.buildinggadgets.common.tools.ExchangingModes;
import com.direwolf20.buildinggadgets.common.tools.InventoryManipulation;
import com.direwolf20.buildinggadgets.common.tools.NBTTool;
import com.direwolf20.buildinggadgets.common.tools.NetworkIO;
import com.direwolf20.buildinggadgets.common.tools.UndoState;
import com.direwolf20.buildinggadgets.common.tools.UniqueItem;
import com.direwolf20.buildinggadgets.common.tools.VectorTools;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multiset;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class GadgetUtils {
    private static final ImmutableList<String> LINK_STARTS = ImmutableList.of((Object)"http", (Object)"www");
    private static Supplier<IItemHandler> remoteInventorySupplier;
    public static final Comparator<Vec3i> POSITION_COMPARATOR;

    public static boolean mightBeLink(String s) {
        return LINK_STARTS.stream().anyMatch(s::startsWith);
    }

    public static String getStackErrorSuffix(ItemStack stack) {
        return GadgetUtils.getStackErrorText(stack) + " with NBT tag: " + stack.func_77978_p();
    }

    private static String getStackErrorText(ItemStack stack) {
        return "the following stack: [" + stack + "]";
    }

    @Nullable
    public static ByteArrayOutputStream getPasteStream(@Nonnull NBTTagCompound compound, @Nullable String name) throws IOException {
        NBTTagCompound withText;
        NBTTagCompound nBTTagCompound = withText = name != null && !name.isEmpty() ? compound.func_74737_b() : compound;
        if (name != null && !name.isEmpty()) {
            withText.func_74778_a("name", name);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CompressedStreamTools.func_74799_a((NBTTagCompound)withText, (OutputStream)baos);
        return baos.size() < 32567 ? baos : null;
    }

    @Nonnull
    public static NBTTagCompound getStackTag(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            throw new IllegalArgumentException("An NBT tag could net be retrieved from " + GadgetUtils.getStackErrorText(stack));
        }
        return tag;
    }

    public static void pushUndoList(ItemStack stack, UndoState undoState) {
        NBTTagList undoStates;
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if ((undoStates = (NBTTagList)tagCompound.func_74781_a("undoStack")) == null) {
            undoStates = new NBTTagList();
        }
        if (undoStates.func_74745_c() >= 10) {
            undoStates.func_74744_a(0);
        }
        undoStates.func_74742_a((NBTBase)GadgetUtils.undoStateToNBT(undoState));
        tagCompound.func_74782_a("undoStack", (NBTBase)undoStates);
        stack.func_77982_d(tagCompound);
    }

    @Nullable
    public static UndoState popUndoList(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        NBTTagList undoStates = (NBTTagList)tagCompound.func_74781_a("undoStack");
        if (undoStates == null || undoStates.func_74745_c() == 0) {
            return null;
        }
        UndoState undoState = GadgetUtils.NBTToUndoState(undoStates.func_150305_b(undoStates.func_74745_c() - 1));
        undoStates.func_74744_a(undoStates.func_74745_c() - 1);
        tagCompound.func_74782_a("undoStack", (NBTBase)undoStates);
        return undoState;
    }

    private static NBTTagCompound undoStateToNBT(UndoState undoState) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("dim", undoState.dimension);
        BlockPos startBlock = undoState.coordinates.get(0);
        int[] array = new int[undoState.coordinates.size()];
        int idx = 0;
        for (BlockPos coord : undoState.coordinates) {
            int px = (coord.func_177958_n() - startBlock.func_177958_n() & 0xFF) << 16;
            int py = (coord.func_177956_o() - startBlock.func_177956_o() & 0xFF) << 8;
            int pz = coord.func_177952_p() - startBlock.func_177952_p() & 0xFF;
            int p = px + py + pz;
            array[idx++] = p;
        }
        compound.func_74782_a("startBlock", (NBTBase)NBTUtil.func_186859_a((BlockPos)startBlock));
        compound.func_74783_a("undoIntCoords", array);
        return compound;
    }

    private static UndoState NBTToUndoState(NBTTagCompound compound) {
        int dim = compound.func_74762_e("dim");
        ArrayList<BlockPos> coordinates = new ArrayList<BlockPos>();
        int[] array = compound.func_74759_k("undoIntCoords");
        BlockPos startBlock = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("startBlock"));
        for (int i = 0; i <= array.length - 1; ++i) {
            int p = array[i];
            int x = startBlock.func_177958_n() + (byte)((p & 0xFF0000) >> 16);
            int y = startBlock.func_177956_o() + (byte)((p & 0xFF00) >> 8);
            int z = startBlock.func_177952_p() + (byte)(p & 0xFF);
            coordinates.add(new BlockPos(x, y, z));
        }
        UndoState undoState = new UndoState(dim, coordinates);
        return undoState;
    }

    public static void setAnchor(ItemStack stack, List<BlockPos> coordinates) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        NBTTagList coords = new NBTTagList();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        for (BlockPos coord : coordinates) {
            coords.func_74742_a((NBTBase)NBTUtil.func_186859_a((BlockPos)coord));
        }
        tagCompound.func_74782_a("anchorcoords", (NBTBase)coords);
        stack.func_77982_d(tagCompound);
    }

    public static List<BlockPos> getAnchor(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        ArrayList<BlockPos> coordinates = new ArrayList<BlockPos>();
        if (tagCompound == null) {
            GadgetUtils.setAnchor(stack, coordinates);
            tagCompound = stack.func_77978_p();
            return coordinates;
        }
        NBTTagList coordList = (NBTTagList)tagCompound.func_74781_a("anchorcoords");
        if (coordList == null) {
            GadgetUtils.setAnchor(stack, coordinates);
            tagCompound = stack.func_77978_p();
            return coordinates;
        }
        if (coordList.func_74745_c() == 0) {
            return coordinates;
        }
        for (int i = 0; i < coordList.func_74745_c(); ++i) {
            coordinates.add(NBTUtil.func_186861_c((NBTTagCompound)coordList.func_150305_b(i)));
        }
        return coordinates;
    }

    public static void setToolRange(ItemStack stack, int range) {
        NBTTagCompound tagCompound = NBTTool.getOrNewTag(stack);
        tagCompound.func_74768_a("range", range);
    }

    public static int getToolRange(ItemStack stack) {
        NBTTagCompound tagCompound = NBTTool.getOrNewTag(stack);
        return MathHelper.func_76125_a((int)tagCompound.func_74762_e("range"), (int)1, (int)SyncedConfig.maxRange);
    }

    public static IBlockState rotateOrMirrorBlock(EntityPlayer player, PacketRotateMirror.Operation operation, IBlockState state) {
        if (operation == PacketRotateMirror.Operation.MIRROR) {
            return state.func_185902_a(player.func_174811_aO().func_176740_k() == EnumFacing.Axis.X ? Mirror.LEFT_RIGHT : Mirror.FRONT_BACK);
        }
        return state.func_185907_a(Rotation.CLOCKWISE_90);
    }

    public static void rotateOrMirrorToolBlock(ItemStack stack, EntityPlayer player, PacketRotateMirror.Operation operation) {
        GadgetUtils.setToolBlock(stack, GadgetUtils.rotateOrMirrorBlock(player, operation, GadgetUtils.getToolBlock(stack)));
        GadgetUtils.setToolActualBlock(stack, GadgetUtils.rotateOrMirrorBlock(player, operation, GadgetUtils.getToolActualBlock(stack)));
    }

    private static void setToolBlock(ItemStack stack, @Nullable IBlockState state) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (state == null) {
            state = Blocks.field_150350_a.func_176223_P();
        }
        NBTTagCompound stateTag = new NBTTagCompound();
        NBTUtil.func_190009_a((NBTTagCompound)stateTag, (IBlockState)state);
        tagCompound.func_74782_a("blockstate", (NBTBase)stateTag);
        stack.func_77982_d(tagCompound);
    }

    private static void setToolActualBlock(ItemStack stack, @Nullable IBlockState state) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (state == null) {
            state = Blocks.field_150350_a.func_176223_P();
        }
        NBTTagCompound stateTag = new NBTTagCompound();
        NBTUtil.func_190009_a((NBTTagCompound)stateTag, (IBlockState)state);
        tagCompound.func_74782_a("actualblockstate", (NBTBase)stateTag);
        stack.func_77982_d(tagCompound);
    }

    public static IBlockState getToolBlock(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            GadgetUtils.setToolBlock(stack, Blocks.field_150350_a.func_176223_P());
            return Blocks.field_150350_a.func_176223_P();
        }
        return NBTUtil.func_190008_d((NBTTagCompound)tagCompound.func_74775_l("blockstate"));
    }

    public static IBlockState getToolActualBlock(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            GadgetUtils.setToolBlock(stack, Blocks.field_150350_a.func_176223_P());
            tagCompound = stack.func_77978_p();
            return Blocks.field_150350_a.func_176223_P();
        }
        return NBTUtil.func_190008_d((NBTTagCompound)tagCompound.func_74775_l("actualblockstate"));
    }

    public static void selectBlock(ItemStack stack, EntityPlayer player) {
        World world = player.field_70170_p;
        RayTraceResult lookingAt = VectorTools.getLookingAt(player, false);
        if (lookingAt == null) {
            return;
        }
        BlockPos pos = lookingAt.func_178782_a();
        EnumActionResult result = GadgetUtils.setRemoteInventory(stack, player, world, pos, true);
        if (result == EnumActionResult.SUCCESS) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        if (result == EnumActionResult.FAIL || SyncedConfig.blockBlacklist.contains((IForgeRegistryEntry<?>)state.func_177230_c()) || state.func_177230_c() instanceof EffectBlock) {
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + new TextComponentTranslation("message.gadget.invalidblock", new Object[0]).func_150261_e()), true);
            return;
        }
        IBlockState placeState = InventoryManipulation.getSpecificStates(state, world, player, pos, stack);
        IBlockState actualState = placeState.func_185899_b((IBlockAccess)world, pos);
        GadgetUtils.setToolBlock(stack, placeState);
        GadgetUtils.setToolActualBlock(stack, actualState);
    }

    public static EnumActionResult setRemoteInventory(ItemStack stack, EntityPlayer player, World world, BlockPos pos, boolean setTool) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return EnumActionResult.PASS;
        }
        if (setTool && te instanceof ConstructionBlockTileEntity && ((ConstructionBlockTileEntity)te).getBlockState() != null) {
            GadgetUtils.setToolBlock(stack, ((ConstructionBlockTileEntity)te).getActualBlockState());
            GadgetUtils.setToolActualBlock(stack, ((ConstructionBlockTileEntity)te).getActualBlockState());
            return EnumActionResult.SUCCESS;
        }
        if (GadgetUtils.setRemoteInventory(player, stack, pos, world.field_73011_w.getDimension(), world)) {
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public static boolean anchorBlocks(EntityPlayer player, ItemStack stack) {
        World world = player.field_70170_p;
        List<BlockPos> currentCoords = GadgetUtils.getAnchor(stack);
        if (currentCoords.size() == 0) {
            RayTraceResult lookingAt = VectorTools.getLookingAt(player, stack);
            if (lookingAt == null) {
                return false;
            }
            BlockPos startBlock = lookingAt.func_178782_a();
            EnumFacing sideHit = lookingAt.field_178784_b;
            if (startBlock == null || world.func_180495_p(startBlock) == Blocks.field_150350_a.func_176223_P()) {
                return false;
            }
            List<BlockPos> coords = new ArrayList<BlockPos>();
            if (stack.func_77973_b() instanceof GadgetBuilding) {
                coords = BuildingModes.collectPlacementPos(world, player, startBlock, sideHit, stack, startBlock);
            } else if (stack.func_77973_b() instanceof GadgetExchanger) {
                coords = ExchangingModes.collectPlacementPos(world, player, startBlock, sideHit, stack, startBlock);
            }
            GadgetUtils.setAnchor(stack, coords);
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation("message.gadget.anchorrender", new Object[0]).func_150261_e()), true);
        } else {
            GadgetUtils.setAnchor(stack, new ArrayList<BlockPos>());
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation("message.gadget.anchorremove", new Object[0]).func_150261_e()), true);
        }
        return true;
    }

    public static boolean setRemoteInventory(EntityPlayer player, ItemStack tool, BlockPos pos, int dim, World world) {
        if (GadgetUtils.getRemoteInventory(pos, dim, world, player) != null) {
            boolean same = pos.equals((Object)GadgetUtils.getPOSFromNBT(tool, "boundTE"));
            GadgetUtils.writePOSToNBT(tool, same ? null : pos, "boundTE", (Integer)dim);
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation("message.gadget." + (same ? "unboundTE" : "boundTE"), new Object[0]).func_150261_e()), true);
            return true;
        }
        return false;
    }

    public static void clearCachedRemoteInventory() {
        remoteInventorySupplier = null;
    }

    @Nullable
    public static IItemHandler getRemoteInventory(ItemStack tool, World world, EntityPlayer player) {
        return GadgetUtils.getRemoteInventory(tool, world, player, NetworkIO.Operation.EXTRACT);
    }

    @Nullable
    public static IItemHandler getRemoteInventory(ItemStack tool, World world, EntityPlayer player, NetworkIO.Operation operation) {
        if (remoteInventorySupplier == null) {
            remoteInventorySupplier = Suppliers.memoizeWithExpiration(() -> {
                Integer dim = GadgetUtils.getDIMFromNBT(tool, "boundTE");
                if (dim == null) {
                    return null;
                }
                if (DimensionManager.getWorld((int)dim) == null) {
                    return null;
                }
                BlockPos pos = GadgetUtils.getPOSFromNBT(tool, "boundTE");
                return pos == null ? null : GadgetUtils.getRemoteInventory(pos, dim, world, player, operation);
            }, (long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        return (IItemHandler)remoteInventorySupplier.get();
    }

    @Nullable
    public static IItemHandler getRemoteInventory(BlockPos pos, int dim, World world, EntityPlayer player) {
        return GadgetUtils.getRemoteInventory(pos, dim, world, player, NetworkIO.Operation.EXTRACT);
    }

    @Nullable
    public static IItemHandler getRemoteInventory(BlockPos pos, int dim, World world, EntityPlayer player, NetworkIO.Operation operation) {
        MinecraftServer server = world.func_73046_m();
        if (server == null) {
            return null;
        }
        WorldServer worldServer = server.func_71218_a(dim);
        if (worldServer == null) {
            return null;
        }
        return GadgetUtils.getRemoteInventory(pos, (World)worldServer, player, operation);
    }

    @Nullable
    public static IItemHandler getRemoteInventory(BlockPos pos, World world, EntityPlayer player, NetworkIO.Operation operation) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return null;
        }
        IItemHandler network = NetworkProvider.getWrappedNetwork(te, player, operation);
        if (network != null) {
            return network;
        }
        IItemHandler cap = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        return cap != null ? cap : null;
    }

    public static String withSuffix(int count) {
        if (count < 1000) {
            return "" + count;
        }
        int exp = (int)(Math.log(count) / Math.log(1000.0));
        return String.format("%.1f%c", (double)count / Math.pow(1000.0, exp), Character.valueOf("kMGTPE".charAt(exp - 1)));
    }

    public static void writePOSToNBT(ItemStack stack, @Nullable BlockPos pos, String tagName) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (pos == null) {
            if (tagCompound.func_74781_a(tagName) != null) {
                tagCompound.func_82580_o(tagName);
                stack.func_77982_d(tagCompound);
            }
            return;
        }
        tagCompound.func_74782_a(tagName, (NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
        stack.func_77982_d(tagCompound);
    }

    public static void writePOSToNBT(ItemStack stack, @Nullable BlockPos pos, String tagName, Integer dim) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (pos == null) {
            if (tagCompound.func_74781_a(tagName) != null) {
                tagCompound.func_82580_o(tagName);
                stack.func_77982_d(tagCompound);
            }
            return;
        }
        NBTTagCompound posTag = NBTUtil.func_186859_a((BlockPos)pos);
        posTag.func_74768_a("dim", dim.intValue());
        tagCompound.func_74782_a(tagName, (NBTBase)posTag);
        stack.func_77982_d(tagCompound);
    }

    public static void writePOSToNBT(NBTTagCompound tagCompound, @Nullable BlockPos pos, String tagName, Integer dim) {
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (pos == null) {
            if (tagCompound.func_74781_a(tagName) != null) {
                tagCompound.func_82580_o(tagName);
            }
            return;
        }
        tagCompound.func_74782_a(tagName, (NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
        tagCompound.func_74768_a("dim", dim.intValue());
    }

    @Nullable
    public static BlockPos getPOSFromNBT(ItemStack stack, String tagName) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        NBTTagCompound posTag = tagCompound.func_74775_l(tagName);
        if (posTag.equals((Object)new NBTTagCompound())) {
            return null;
        }
        return NBTUtil.func_186861_c((NBTTagCompound)posTag);
    }

    public static void writeIntToNBT(ItemStack stack, int tagInt, String tagName) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        tagCompound.func_74768_a(tagName, tagInt);
        stack.func_77982_d(tagCompound);
    }

    public static int getIntFromNBT(ItemStack stack, String tagName) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        return tagCompound == null ? 0 : tagCompound.func_74762_e(tagName);
    }

    public static void writeStringToNBT(ItemStack stack, String string, String tagName) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (string.equals(null)) {
            if (tagCompound.func_74781_a(tagName) != null) {
                tagCompound.func_82580_o(tagName);
            }
            return;
        }
        tagCompound.func_74778_a(tagName, string);
    }

    public static void writeStringToNBT(NBTTagCompound tagCompound, String string, String tagName) {
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (string.equals(null)) {
            if (tagCompound.func_74781_a(tagName) != null) {
                tagCompound.func_82580_o(tagName);
            }
            return;
        }
        tagCompound.func_74778_a(tagName, string);
    }

    @Nullable
    public static String getStringFromNBT(ItemStack stack, String tagName) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        return tagCompound.func_74779_i(tagName);
    }

    @Nullable
    public static BlockPos getPOSFromNBT(NBTTagCompound tagCompound, String tagName) {
        if (tagCompound == null) {
            return null;
        }
        NBTTagCompound posTag = tagCompound.func_74775_l(tagName);
        if (posTag.equals((Object)new NBTTagCompound())) {
            return null;
        }
        return NBTUtil.func_186861_c((NBTTagCompound)posTag);
    }

    @Nullable
    public static Integer getDIMFromNBT(ItemStack stack, String tagName) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        NBTTagCompound posTag = tagCompound.func_74775_l(tagName);
        if (posTag.equals((Object)new NBTTagCompound())) {
            return null;
        }
        return posTag.func_74762_e("dim");
    }

    public static NBTTagCompound stateToCompound(IBlockState state) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        NBTUtil.func_190009_a((NBTTagCompound)tagCompound, (IBlockState)state);
        return tagCompound;
    }

    @Nullable
    public static IBlockState compoundToState(@Nullable NBTTagCompound tagCompound) {
        if (tagCompound == null) {
            return null;
        }
        return NBTUtil.func_190008_d((NBTTagCompound)tagCompound);
    }

    public static int relPosToInt(BlockPos startPos, BlockPos relPos) {
        int px = (relPos.func_177958_n() - startPos.func_177958_n() & 0xFF) << 16;
        int py = (relPos.func_177956_o() - startPos.func_177956_o() & 0xFF) << 8;
        int pz = relPos.func_177952_p() - startPos.func_177952_p() & 0xFF;
        int p = px + py + pz;
        return p;
    }

    public static BlockPos relIntToPos(BlockPos startPos, int relInt) {
        int p = relInt;
        int x = startPos.func_177958_n() + (byte)((p & 0xFF0000) >> 16);
        int y = startPos.func_177956_o() + (byte)((p & 0xFF00) >> 8);
        int z = startPos.func_177952_p() + (byte)(p & 0xFF);
        return new BlockPos(x, y, z);
    }

    public static NBTTagList itemCountToNBT(Multiset<UniqueItem> itemCountMap) {
        NBTTagList tagList = new NBTTagList();
        for (Multiset.Entry entry : itemCountMap.entrySet()) {
            int item = Item.func_150891_b((Item)((UniqueItem)entry.getElement()).item);
            int meta = ((UniqueItem)entry.getElement()).meta;
            int count = entry.getCount();
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74768_a("item", item);
            tagCompound.func_74768_a("meta", meta);
            tagCompound.func_74768_a("count", count);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        return tagList;
    }

    public static Multiset<UniqueItem> nbtToItemCount(@Nullable NBTTagList tagList) {
        if (tagList == null) {
            return HashMultiset.create();
        }
        HashMultiset itemCountMap = HashMultiset.create((int)tagList.func_74745_c());
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            UniqueItem uniqueItem = new UniqueItem(Item.func_150899_d((int)tagCompound.func_74762_e("item")), tagCompound.func_74762_e("meta"));
            int count = tagCompound.func_74762_e("count");
            itemCountMap.setCount((Object)uniqueItem, count);
        }
        return itemCountMap;
    }

    static {
        POSITION_COMPARATOR = Comparator.comparingInt(Vec3i::func_177958_n).thenComparingInt(Vec3i::func_177956_o).thenComparingInt(Vec3i::func_177952_p);
    }
}

