/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.network;

import com.direwolf20.buildinggadgets.client.events.EventTooltip;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.tools.GadgetUtils;
import com.direwolf20.buildinggadgets.common.tools.InventoryManipulation;
import com.direwolf20.buildinggadgets.common.tools.ToolRenders;
import com.direwolf20.buildinggadgets.common.tools.UniqueItem;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class PacketSetRemoteInventoryCache
implements IMessage {
    private boolean isCopyPaste;
    private Multiset<UniqueItem> cache;
    private Pair<Integer, BlockPos> loc;

    public PacketSetRemoteInventoryCache() {
    }

    public PacketSetRemoteInventoryCache(Multiset<UniqueItem> cache, boolean isCopyPaste) {
        this.cache = cache;
        this.isCopyPaste = isCopyPaste;
    }

    public PacketSetRemoteInventoryCache(Pair<Integer, BlockPos> loc, boolean isCopyPaste) {
        this.loc = loc;
        this.isCopyPaste = isCopyPaste;
    }

    public void fromBytes(ByteBuf buf) {
        this.isCopyPaste = buf.readBoolean();
        if (buf.readBoolean()) {
            this.loc = new ImmutablePair((Object)buf.readInt(), (Object)BlockPos.func_177969_a((long)buf.readLong()));
            return;
        }
        int len = buf.readInt();
        ImmutableMultiset.Builder builder = ImmutableMultiset.builder();
        for (int i = 0; i < len; ++i) {
            builder.addCopies((Object)new UniqueItem(Item.func_150899_d((int)buf.readInt()), buf.readInt()), buf.readInt());
        }
        this.cache = builder.build();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.isCopyPaste);
        boolean isRequest = this.cache == null;
        buf.writeBoolean(isRequest);
        if (isRequest) {
            buf.writeInt(((Integer)this.loc.getLeft()).intValue());
            buf.writeLong(((BlockPos)this.loc.getRight()).func_177986_g());
            return;
        }
        Set items = this.cache.entrySet();
        buf.writeInt(items.size());
        for (Multiset.Entry entry : items) {
            UniqueItem uniqueItem = (UniqueItem)entry.getElement();
            buf.writeInt(Item.func_150891_b((Item)uniqueItem.item));
            buf.writeInt(uniqueItem.meta);
            buf.writeInt(entry.getCount());
        }
    }

    public static class Handler
    implements IMessageHandler<PacketSetRemoteInventoryCache, IMessage> {
        public IMessage onMessage(PacketSetRemoteInventoryCache message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                if (ctx.side == Side.SERVER) {
                    EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                    HashSet<UniqueItem> itemTypes = new HashSet<UniqueItem>();
                    ImmutableMultiset.Builder builder = ImmutableMultiset.builder();
                    IItemHandler remoteInventory = GadgetUtils.getRemoteInventory((BlockPos)message.loc.getRight(), (Integer)message.loc.getLeft(), player.field_70170_p, (EntityPlayer)player);
                    if (remoteInventory != null) {
                        for (int i = 0; i < remoteInventory.getSlots(); ++i) {
                            int meta;
                            Item item;
                            UniqueItem uniqueItem;
                            ItemStack stack = remoteInventory.getStackInSlot(i);
                            if (stack.func_190926_b() || itemTypes.contains(uniqueItem = new UniqueItem(item = stack.func_77973_b(), meta = stack.func_77952_i()))) continue;
                            itemTypes.add(uniqueItem);
                            builder.addCopies((Object)uniqueItem, InventoryManipulation.countInContainer(remoteInventory, item, meta));
                        }
                    }
                    PacketHandler.INSTANCE.sendTo((IMessage)new PacketSetRemoteInventoryCache((Multiset<UniqueItem>)builder.build(), message.isCopyPaste), player);
                    return;
                }
                if (message.isCopyPaste) {
                    EventTooltip.setCache((Multiset<UniqueItem>)message.cache);
                } else {
                    ToolRenders.setInventoryCache((Multiset<UniqueItem>)message.cache);
                }
            });
            return null;
        }
    }
}

