/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.gadgets;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.blocks.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.blocks.ModBlocks;
import com.direwolf20.buildinggadgets.common.building.Region;
import com.direwolf20.buildinggadgets.common.building.placement.ConnectedSurface;
import com.direwolf20.buildinggadgets.common.config.SyncedConfig;
import com.direwolf20.buildinggadgets.common.entities.BlockBuildEntity;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetGeneric;
import com.direwolf20.buildinggadgets.common.tools.BlockPosState;
import com.direwolf20.buildinggadgets.common.tools.GadgetUtils;
import com.direwolf20.buildinggadgets.common.tools.VectorTools;
import com.direwolf20.buildinggadgets.common.tools.WorldSave;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;

public class GadgetDestruction
extends GadgetGeneric {
    public GadgetDestruction() {
        super("destructiontool");
        this.func_77656_e(SyncedConfig.durabilityDestruction);
    }

    public int getMaxDamage(ItemStack stack) {
        return SyncedConfig.poweredByFE ? 0 : SyncedConfig.durabilityDestruction;
    }

    @Override
    public int getEnergyMax() {
        return SyncedConfig.energyMaxDestruction;
    }

    @Override
    public int getEnergyCost(ItemStack tool) {
        return SyncedConfig.energyCostDestruction * this.getCostMultiplier(tool);
    }

    @Override
    public int getDamageCost(ItemStack tool) {
        return SyncedConfig.damageCostDestruction * this.getCostMultiplier(tool);
    }

    private int getCostMultiplier(ItemStack tool) {
        return (int)(SyncedConfig.nonFuzzyEnabledDestruction && !GadgetDestruction.getFuzzy(tool) ? SyncedConfig.nonFuzzyMultiplierDestruction : 1.0);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag b) {
        super.func_77624_a(stack, world, list, b);
        list.add(TextFormatting.RED + I18n.func_135052_a((String)"tooltip.gadget.destroywarning", (Object[])new Object[0]));
        list.add(TextFormatting.AQUA + I18n.func_135052_a((String)"tooltip.gadget.destroyshowoverlay", (Object[])new Object[0]) + ": " + GadgetDestruction.getOverlay(stack));
        list.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"tooltip.gadget.connected_area", (Object[])new Object[0]) + ": " + GadgetDestruction.getConnectedArea(stack));
        if (SyncedConfig.nonFuzzyEnabledDestruction) {
            list.add(TextFormatting.GOLD + I18n.func_135052_a((String)"tooltip.gadget.fuzzy", (Object[])new Object[0]) + ": " + GadgetDestruction.getFuzzy(stack));
        }
        GadgetDestruction.addInformationRayTraceFluid(list, stack);
        this.addEnergyInformation(list, stack);
    }

    @Nullable
    public static String getUUID(ItemStack stack) {
        String uuid;
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if ((uuid = tagCompound.func_74779_i("UUID")).isEmpty()) {
            UUID uid = UUID.randomUUID();
            tagCompound.func_74778_a("UUID", uid.toString());
            stack.func_77982_d(tagCompound);
            uuid = uid.toString();
        }
        return uuid;
    }

    public static void setAnchor(ItemStack stack, BlockPos pos) {
        GadgetUtils.writePOSToNBT(stack, pos, "anchor");
    }

    public static BlockPos getAnchor(ItemStack stack) {
        return GadgetUtils.getPOSFromNBT(stack, "anchor");
    }

    public static void setAnchorSide(ItemStack stack, EnumFacing side) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (side == null) {
            if (tagCompound.func_74781_a("anchorSide") != null) {
                tagCompound.func_82580_o("anchorSide");
                stack.func_77982_d(tagCompound);
            }
            return;
        }
        tagCompound.func_74778_a("anchorSide", side.func_176610_l());
        stack.func_77982_d(tagCompound);
    }

    public static EnumFacing getAnchorSide(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        String facing = tagCompound.func_74779_i("anchorSide");
        if (facing.isEmpty()) {
            return null;
        }
        return EnumFacing.func_176739_a((String)facing);
    }

    public static void setToolValue(ItemStack stack, int value, String valueName) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        tagCompound.func_74768_a(valueName, value);
        stack.func_77982_d(tagCompound);
    }

    public static int getToolValue(ItemStack stack, String valueName) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        return tagCompound.func_74762_e(valueName);
    }

    public static boolean getOverlay(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            tagCompound.func_74757_a("overlay", true);
            tagCompound.func_74757_a("fuzzy", true);
            stack.func_77982_d(tagCompound);
            return true;
        }
        if (tagCompound.func_74764_b("overlay")) {
            return tagCompound.func_74767_n("overlay");
        }
        tagCompound.func_74757_a("overlay", true);
        stack.func_77982_d(tagCompound);
        return true;
    }

    private static void setOverlay(ItemStack stack, boolean showOverlay) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        tagCompound.func_74757_a("overlay", showOverlay);
        stack.func_77982_d(tagCompound);
    }

    public void switchOverlay(EntityPlayer player, ItemStack stack) {
        boolean overlay = !GadgetDestruction.getOverlay(stack);
        GadgetDestruction.setOverlay(stack, overlay);
        player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation("tooltip.gadget.destroyshowoverlay", new Object[0]).func_150261_e() + ": " + overlay), true);
    }

    private static List<EnumFacing> assignDirections(EnumFacing side, EntityPlayer player) {
        ArrayList<EnumFacing> dirs = new ArrayList<EnumFacing>();
        EnumFacing depth = side.func_176734_d();
        boolean vertical = side.func_176740_k() == EnumFacing.Axis.Y;
        EnumFacing up = vertical ? player.func_174811_aO() : EnumFacing.UP;
        EnumFacing left = vertical ? up.func_176746_e() : side.func_176735_f();
        EnumFacing right = left.func_176734_d();
        if (side == EnumFacing.DOWN) {
            up = up.func_176734_d();
        }
        EnumFacing down = up.func_176734_d();
        dirs.add(left);
        dirs.add(right);
        dirs.add(up);
        dirs.add(down);
        dirs.add(depth);
        return dirs;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        if (!world.field_72995_K) {
            if (!player.func_70093_af()) {
                RayTraceResult lookingAt = VectorTools.getLookingAt(player, stack);
                if (lookingAt == null && GadgetDestruction.getAnchor(stack) == null) {
                    return new ActionResult(EnumActionResult.FAIL, (Object)stack);
                }
                BlockPos startBlock = GadgetDestruction.getAnchor(stack) == null ? lookingAt.func_178782_a() : GadgetDestruction.getAnchor(stack);
                EnumFacing sideHit = GadgetDestruction.getAnchorSide(stack) == null ? lookingAt.field_178784_b : GadgetDestruction.getAnchorSide(stack);
                this.clearArea(world, startBlock, sideHit, player, stack);
                if (GadgetDestruction.getAnchor(stack) != null) {
                    GadgetDestruction.setAnchor(stack, null);
                    GadgetDestruction.setAnchorSide(stack, null);
                    player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation("message.gadget.anchorremove", new Object[0]).func_150261_e()), true);
                }
            }
        } else if (player.func_70093_af()) {
            player.openGui((Object)BuildingGadgets.instance, 1, world, hand.ordinal(), 0, 0);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public static void anchorBlocks(EntityPlayer player, ItemStack stack) {
        BlockPos currentAnchor = GadgetDestruction.getAnchor(stack);
        if (currentAnchor == null) {
            RayTraceResult lookingAt = VectorTools.getLookingAt(player, stack);
            if (lookingAt == null) {
                return;
            }
            currentAnchor = lookingAt.func_178782_a();
            GadgetDestruction.setAnchor(stack, currentAnchor);
            GadgetDestruction.setAnchorSide(stack, lookingAt.field_178784_b);
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation("message.gadget.anchorrender", new Object[0]).func_150261_e()), true);
        } else {
            GadgetDestruction.setAnchor(stack, null);
            GadgetDestruction.setAnchorSide(stack, null);
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation("message.gadget.anchorremove", new Object[0]).func_150261_e()), true);
        }
    }

    public static Set<BlockPos> getArea(World world, BlockPos pos, EnumFacing incomingSide, EntityPlayer player, ItemStack stack) {
        IBlockState stateTarget;
        int depth = GadgetDestruction.getToolValue(stack, "depth");
        if (depth == 0) {
            return Collections.emptySet();
        }
        BlockPos startPos = GadgetDestruction.getAnchor(stack) == null ? pos : GadgetDestruction.getAnchor(stack);
        EnumFacing side = GadgetDestruction.getAnchorSide(stack) == null ? incomingSide : GadgetDestruction.getAnchorSide(stack);
        List<EnumFacing> directions = GadgetDestruction.assignDirections(side, player);
        String[] directionNames = new String[]{"right", "left", "up", "down", "depth"};
        Region selectionRegion = new Region((Vec3i)startPos);
        for (int i = 0; i < directionNames.length; ++i) {
            selectionRegion = selectionRegion.union(new Region((Vec3i)startPos.func_177967_a(directions.get(i), GadgetDestruction.getToolValue(stack, directionNames[i]) - (i == 4 ? 1 : 0))));
        }
        boolean fuzzy = !SyncedConfig.nonFuzzyEnabledDestruction || GadgetGeneric.getFuzzy(stack);
        IBlockState iBlockState = stateTarget = fuzzy ? null : world.func_180495_p(pos);
        if (GadgetGeneric.getConnectedArea(stack)) {
            return ConnectedSurface.create((IBlockAccess)world, selectionRegion, searchPos -> searchPos, startPos, null, (s, p) -> GadgetDestruction.validBlock(world, p, player, s, fuzzy)).stream().collect(Collectors.toSet());
        }
        return selectionRegion.stream().filter(e -> GadgetDestruction.validBlock(world, e, player, stateTarget, fuzzy)).collect(Collectors.toSet());
    }

    private static boolean validBlock(World world, BlockPos voidPos, EntityPlayer player, @Nullable IBlockState stateTarget, boolean fuzzy) {
        IBlockState currentBlock = world.func_180495_p(voidPos);
        if (!fuzzy && currentBlock != stateTarget) {
            return false;
        }
        TileEntity te = world.func_175625_s(voidPos);
        if (currentBlock.func_177230_c().isAir(currentBlock, (IBlockAccess)world, voidPos)) {
            return false;
        }
        if (currentBlock.equals(ModBlocks.effectBlock.func_176223_P())) {
            return false;
        }
        if (te != null && !(te instanceof ConstructionBlockTileEntity)) {
            return false;
        }
        if (currentBlock.func_185887_b(world, voidPos) < 0.0f) {
            return false;
        }
        ItemStack tool = GadgetDestruction.getGadget(player);
        if (tool.func_190926_b()) {
            return false;
        }
        if (!player.func_175142_cm()) {
            return false;
        }
        return world.func_175660_a(player, voidPos);
    }

    private void clearArea(World world, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        Set<BlockPos> voidPosArray = GadgetDestruction.getArea(world, pos, side, player, stack);
        ArrayList<BlockPosState> blockList = new ArrayList<BlockPosState>();
        for (BlockPos voidPos : voidPosArray) {
            boolean isPaste;
            TileEntity te;
            IBlockState blockState = world.func_180495_p(voidPos);
            IBlockState pasteState = Blocks.field_150350_a.func_176223_P();
            if (blockState == Blocks.field_150350_a.func_176223_P()) continue;
            if (blockState.func_177230_c() == ModBlocks.constructionBlock && (te = world.func_175625_s(voidPos)) instanceof ConstructionBlockTileEntity) {
                pasteState = ((ConstructionBlockTileEntity)te).getActualBlockState();
            }
            boolean bl = isPaste = pasteState != Blocks.field_150350_a.func_176223_P() && pasteState != null;
            if (!this.destroyBlock(world, voidPos, player)) continue;
            blockList.add(new BlockPosState(voidPos, isPaste ? pasteState : blockState, isPaste));
        }
        if (blockList.size() > 0) {
            GadgetDestruction.storeUndo(world, blockList, stack, player);
        }
    }

    private static void storeUndo(World world, List<BlockPosState> blockList, ItemStack stack, EntityPlayer player) {
        WorldSave worldSave = WorldSave.getWorldSaveDestruction(world);
        NBTTagCompound tagCompound = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        blockList.forEach(e -> list.func_74742_a((NBTBase)e.toCompound()));
        tagCompound.func_74782_a("mapping", (NBTBase)list);
        tagCompound.func_74768_a("dimension", player.field_71093_bK);
        worldSave.addToMap(GadgetDestruction.getUUID(stack), tagCompound);
        worldSave.markForSaving();
    }

    public void undo(EntityPlayer player, ItemStack stack) {
        World world = player.field_70170_p;
        WorldSave worldSave = WorldSave.getWorldSaveDestruction(world);
        NBTTagCompound saveCompound = worldSave.getCompoundFromUUID(GadgetDestruction.getUUID(stack));
        if (saveCompound == null) {
            return;
        }
        int dimension = saveCompound.func_74762_e("dimension");
        if (dimension != player.field_71093_bK) {
            return;
        }
        NBTTagList list = saveCompound.func_150295_c("mapping", 10);
        if (list.func_74745_c() == 0) {
            return;
        }
        boolean success = false;
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            BlockPosState posState = BlockPosState.fromCompound(compound);
            if (posState == null) {
                return;
            }
            IBlockState state = world.func_180495_p(posState.getPos());
            if (!state.func_177230_c().isAir(state, (IBlockAccess)world, posState.getPos()) && !state.func_185904_a().func_76224_d()) {
                return;
            }
            BlockSnapshot blockSnapshot = BlockSnapshot.getBlockSnapshot((World)world, (BlockPos)posState.getPos());
            if (!GadgetGeneric.EmitEvent.placeBlock(player, blockSnapshot, EnumFacing.UP, EnumHand.MAIN_HAND)) continue;
            world.func_72838_d((Entity)new BlockBuildEntity(world, posState.getPos(), (EntityLivingBase)player, posState.getState(), 1, posState.getState(), posState.isPaste()));
            success = true;
        }
        if (success) {
            NBTTagCompound newTag = new NBTTagCompound();
            worldSave.addToMap(GadgetDestruction.getUUID(stack), newTag);
            worldSave.markForSaving();
        }
    }

    private boolean destroyBlock(World world, BlockPos voidPos, EntityPlayer player) {
        ItemStack tool = GadgetDestruction.getGadget(player);
        if (tool.func_190926_b()) {
            return false;
        }
        if (!this.canUse(tool, player)) {
            return false;
        }
        if (!GadgetGeneric.EmitEvent.breakBlock(world, voidPos, world.func_180495_p(voidPos), player)) {
            return false;
        }
        this.applyDamage(tool, player);
        world.func_72838_d((Entity)new BlockBuildEntity(world, voidPos, (EntityLivingBase)player, world.func_180495_p(voidPos), 2, Blocks.field_150350_a.func_176223_P(), false));
        return true;
    }

    public static ItemStack getGadget(EntityPlayer player) {
        ItemStack stack = GadgetGeneric.getGadget(player);
        if (!(stack.func_77973_b() instanceof GadgetDestruction)) {
            return ItemStack.field_190927_a;
        }
        return stack;
    }
}

