/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.integration.mods;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.features.IGrinderRecipe;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AEPartLocation;
import com.direwolf20.buildinggadgets.common.integration.IPasteRecipeRegistry;
import com.direwolf20.buildinggadgets.common.integration.IntegrationHandler;
import com.direwolf20.buildinggadgets.common.integration.NetworkProvider;
import com.direwolf20.buildinggadgets.common.tools.NetworkIO;
import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.IItemHandler;

@IntegrationHandler.IntegratedMod(value="appliedenergistics2")
public class AppliedEnergistics2
extends NetworkProvider
implements IPasteRecipeRegistry {
    @Override
    public void registerDeconstructRecipe(IPasteRecipeRegistry.RecipieType type, ItemStack input, ItemStack output) {
        AEApi.instance().registries().grinder().addRecipe((IGrinderRecipe)new GrinderRecipe(type == IPasteRecipeRegistry.RecipieType.BLOCK_TO_CHUNKS ? 4 : 1, input, output));
    }

    @Override
    public void initialize(IntegrationHandler.Phase phase) {
        super.initialize(phase);
        IPasteRecipeRegistry.super.initialize(phase);
    }

    @Override
    @Nullable
    protected IItemHandler getWrappedNetworkInternal(TileEntity te, EntityPlayer player, NetworkIO.Operation operation) {
        ISecurityGrid security;
        IGridNode node;
        if (te instanceof IGridHost && (node = ((IGridHost)te).getGridNode(AEPartLocation.INTERNAL)) != null && (security = (ISecurityGrid)node.getGrid().getCache(ISecurityGrid.class)).hasPermission(player, operation == NetworkIO.Operation.EXTRACT ? SecurityPermissions.EXTRACT : SecurityPermissions.INJECT)) {
            IStorageGrid grid = (IStorageGrid)node.getGrid().getCache(IStorageGrid.class);
            IMEMonitor network = grid.getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
            return new NetworkAppliedEnergistics2IO(player, (IMEMonitor<IAEItemStack>)network, operation);
        }
        return null;
    }

    private static class GrinderRecipe
    implements IGrinderRecipe {
        private final ItemStack input;
        private final ItemStack output;
        private final int turns;

        public GrinderRecipe(int turns, ItemStack input, ItemStack output) {
            this.input = input;
            this.output = output;
            this.turns = turns;
        }

        @Nonnull
        public ItemStack getInput() {
            return this.input;
        }

        @Nonnull
        public ItemStack getOutput() {
            return this.output;
        }

        @Nonnull
        public Optional<ItemStack> getOptionalOutput() {
            return Optional.empty();
        }

        public Optional<ItemStack> getSecondOptionalOutput() {
            return Optional.empty();
        }

        @Nonnull
        public float getOptionalChance() {
            return 0.0f;
        }

        public float getSecondOptionalChance() {
            return 0.0f;
        }

        public int getRequiredTurns() {
            return this.turns;
        }
    }

    private static class PlayerSource
    implements IActionSource {
        private final EntityPlayer player;

        public PlayerSource(EntityPlayer player) {
            Preconditions.checkNotNull((Object)player);
            this.player = player;
        }

        public Optional<EntityPlayer> player() {
            return Optional.of(this.player);
        }

        public Optional<IActionHost> machine() {
            return Optional.empty();
        }

        public <T> Optional<T> context(Class<T> key) {
            return Optional.empty();
        }
    }

    private static class NetworkAppliedEnergistics2IO
    extends NetworkIO<StackProviderAE2> {
        private IMEMonitor<IAEItemStack> network;
        private IItemStorageChannel storageChannel;

        public NetworkAppliedEnergistics2IO(EntityPlayer player, IMEMonitor<IAEItemStack> network, NetworkIO.Operation operation) {
            super(player, operation == NetworkIO.Operation.INSERT ? null : (Collection)Streams.stream((Iterable)network.getStorageList()).map(aeStack -> new StackProviderAE2(aeStack.copy())).collect(Collectors.toList()));
            this.network = network;
            this.storageChannel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
        }

        @Override
        @Nullable
        public ItemStack insertItemInternal(ItemStack stack, boolean simulate) {
            IAEItemStack aeStack = (IAEItemStack)this.storageChannel.createStack((Object)stack);
            if (aeStack == null) {
                return ItemStack.field_190927_a;
            }
            IAEItemStack remainder = (IAEItemStack)this.network.injectItems((IAEStack)aeStack, this.getAction(simulate), (IActionSource)new PlayerSource(this.player));
            return remainder == null ? null : remainder.createItemStack();
        }

        @Override
        @Nonnull
        protected NetworkIO.IStackProvider extractItemInternal(StackProviderAE2 stackProvider, int amount, boolean simulate) {
            return new StackProviderAE2((IAEItemStack)this.network.extractItems((IAEStack)stackProvider.withSize(amount), this.getAction(simulate), (IActionSource)new PlayerSource(this.player)));
        }

        private Actionable getAction(boolean simulate) {
            return simulate ? Actionable.SIMULATE : Actionable.MODULATE;
        }
    }

    public static class StackProviderAE2
    implements NetworkIO.IStackProvider {
        @Nonnull
        private IAEItemStack aeStack;

        public StackProviderAE2(@Nonnull IAEItemStack aeStack) {
            this.aeStack = aeStack;
        }

        @Override
        @Nonnull
        public ItemStack getStack() {
            return this.aeStack.createItemStack();
        }

        @Override
        public void shrinkStack(int amount) {
            this.aeStack.setStackSize(this.aeStack.getStackSize() - (long)amount);
        }

        public IAEItemStack withSize(int amount) {
            return (IAEItemStack)this.aeStack.copy().setStackSize((long)amount);
        }
    }
}

