/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.building.placement;

import com.direwolf20.buildinggadgets.common.building.IPlacementSequence;
import com.direwolf20.buildinggadgets.common.building.Region;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.Spliterator;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public final class Wall
implements IPlacementSequence {
    private Region region;

    public static Wall clickedSide(BlockPos center, EnumFacing side, int radius) {
        return new Wall(center, side, radius, null, 0);
    }

    public static Wall extendingFrom(BlockPos posHit, EnumFacing extension, EnumFacing flatSide, int radius, int extra) {
        Preconditions.checkArgument((extension != flatSide ? 1 : 0) != 0, (Object)("Cannot have a wall extending to " + extension + " and flat at " + flatSide));
        return new Wall(posHit.func_177967_a(extension, radius + 1), flatSide, radius, extension, extra);
    }

    @VisibleForTesting
    private Wall(BlockPos posHit, EnumFacing side, int radius, EnumFacing extendingSide, int extendingSize) {
        this.region = new Region((Vec3i)posHit).expand(radius * (1 - Math.abs(side.func_82601_c())), radius * (1 - Math.abs(side.func_96559_d())), radius * (1 - Math.abs(side.func_82599_e())));
        if (extendingSize != 0) {
            this.region = extendingSide.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? new Region((Vec3i)this.region.getMin(), (Vec3i)this.region.getMax().func_177967_a(extendingSide, extendingSize)) : new Region((Vec3i)this.region.getMin().func_177967_a(extendingSide, extendingSize), (Vec3i)this.region.getMax());
        }
    }

    @VisibleForTesting
    private Wall(Region region) {
        this.region = region;
    }

    @Override
    public Region getBoundingBox() {
        return this.region;
    }

    @Override
    public boolean mayContain(int x, int y, int z) {
        return this.region.mayContain(x, y, z);
    }

    @Override
    public IPlacementSequence copy() {
        return new Wall(this.region);
    }

    @Override
    @Nonnull
    public Iterator<BlockPos> iterator() {
        return this.region.iterator();
    }

    @Override
    public Spliterator<BlockPos> spliterator() {
        return this.region.spliterator();
    }
}

