/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.building.placement;

import com.direwolf20.buildinggadgets.common.building.IPlacementSequence;
import com.direwolf20.buildinggadgets.common.building.Region;
import com.direwolf20.buildinggadgets.common.building.placement.Wall;
import com.direwolf20.buildinggadgets.common.tools.MathTool;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public final class Grid
implements IPlacementSequence {
    private final int periodSize;
    private final Region region;
    private final BlockPos center;
    private final int range;

    public static Grid create(BlockPos base, int range, int periodSize) {
        return new Grid(base, range, periodSize);
    }

    @VisibleForTesting
    private Grid(BlockPos center, int range, int periodSize) {
        this.region = Wall.clickedSide(center, EnumFacing.UP, range).getBoundingBox();
        this.range = range;
        this.center = center;
        this.periodSize = periodSize;
    }

    @VisibleForTesting
    private Grid(Region region, BlockPos center, int range, int periodSize) {
        this.region = region;
        this.center = center;
        this.range = range;
        this.periodSize = periodSize;
    }

    @Override
    public Region getBoundingBox() {
        return this.region;
    }

    @Override
    public boolean mayContain(int x, int y, int z) {
        return this.region.contains(x, y, z);
    }

    @Override
    public IPlacementSequence copy() {
        return new Grid(this.region, this.center, this.range, this.periodSize);
    }

    @Override
    @Nonnull
    public Iterator<BlockPos> iterator() {
        final int period = (this.range - 1) % this.periodSize + 2;
        final int end = (this.range + 1) * 7 / 5;
        final int start = MathTool.floorMultiple(-end, period);
        return new AbstractIterator<BlockPos>(){
            private int x;
            private int z;
            {
                this.x = start;
                this.z = start;
            }

            protected BlockPos computeNext() {
                if (this.z > end) {
                    return (BlockPos)this.endOfData();
                }
                BlockPos pos = new BlockPos(Grid.this.center.func_177958_n() + this.x, Grid.this.center.func_177956_o(), Grid.this.center.func_177952_p() + this.z);
                this.x += period;
                if (this.x > end) {
                    this.x = start;
                    this.z += period;
                }
                return pos;
            }
        };
    }
}

