/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.gui;

import com.direwolf20.buildinggadgets.client.gui.ActionPressed;
import com.direwolf20.buildinggadgets.client.gui.GuiButtonColor;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class GuiButtonIcon
extends GuiButtonColor {
    private Icon iconSelected;
    private Icon iconDeselected;
    private ActionPressed action;
    private float alpha = 1.0f;

    public GuiButtonIcon(int x, int y, int width, int height, String helpTextKey, Color colorSelected, Color colorDeselected, @Nullable Color colorHovered, ResourceLocation textureSelected, @Nullable Runnable action) {
        super(0, x, y, width, height, "", helpTextKey, colorSelected, colorDeselected, colorHovered);
        this.iconDeselected = new Icon(textureSelected);
        this.action = new ActionPressed(action);
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        return this.action.pressed(super.func_146116_c(mc, mouseX, mouseY));
    }

    protected void setFaded(boolean faded, int alphaFaded) {
        this.alpha = faded ? (float)alphaFaded / 255.0f : 1.0f;
    }

    @Override
    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        Icon icon;
        if (!this.field_146125_m) {
            return;
        }
        super.func_191745_a(mc, mouseX, mouseY, partialTicks);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        if (this.iconSelected == null) {
            ResourceLocation texture = this.iconDeselected.getModifiedTexture("selected");
            this.iconSelected = this.iconDeselected.isTextureMissing(textureManager, texture) ? this.iconDeselected : new Icon(texture);
        }
        Icon icon2 = icon = this.selected ? this.iconSelected : this.iconDeselected;
        if (this.selected) {
            GlStateManager.func_179131_c((float)((float)this.colorSelected.getRed() / 255.0f), (float)((float)this.colorSelected.getGreen() / 255.0f), (float)((float)this.colorSelected.getBlue() / 255.0f), (float)this.alpha);
        } else {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        }
        icon.bindTextureColored(textureManager);
        this.drawTexturedModalRect(this.field_146128_h, this.field_146129_i, this.field_146120_f, this.field_146121_g);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        if (icon.bindTexture(textureManager)) {
            this.drawTexturedModalRect(this.field_146128_h, this.field_146129_i, this.field_146120_f, this.field_146121_g);
        }
    }

    private void drawTexturedModalRect(int x, int y, int width, int height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)(x + 0), (double)(y + height), (double)this.field_73735_i).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + 0), (double)this.field_73735_i).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)(x + 0), (double)(y + 0), (double)this.field_73735_i).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    private static class Icon {
        private ResourceLocation texture;
        private ResourceLocation textureColored;

        public Icon(ResourceLocation texture) {
            this.texture = texture;
        }

        public ResourceLocation getModifiedTexture(String suffix) {
            return new ResourceLocation(this.texture.toString().replace(".png", String.format("_%s.png", suffix)));
        }

        public boolean isTextureMissing(TextureManager textureManager, ResourceLocation texture) {
            textureManager.func_110577_a(texture);
            return textureManager.func_110581_b(texture) == TextureUtil.field_111001_a;
        }

        public void bindTextureColored(TextureManager textureManager) {
            if (this.textureColored == null) {
                this.textureColored = this.getModifiedTexture("colored");
                if (this.isTextureMissing(textureManager, this.textureColored)) {
                    this.textureColored = this.texture;
                    this.texture = null;
                }
            }
            textureManager.func_110577_a(this.textureColored);
        }

        public boolean bindTexture(TextureManager textureManager) {
            if (this.texture == null) {
                return false;
            }
            textureManager.func_110577_a(this.texture);
            return true;
        }
    }
}

