/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widget.scroll;

import com.cleanroommc.modularui.api.GuiAxis;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.widget.scroll.HorizontalScrollData;
import com.cleanroommc.modularui.widget.scroll.ScrollData;
import com.cleanroommc.modularui.widget.scroll.VerticalScrollData;
import com.cleanroommc.modularui.widget.sizer.Area;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ScrollArea
extends Area {
    private HorizontalScrollData scrollX;
    private VerticalScrollData scrollY;
    private int scrollBarBackgroundColor;

    public ScrollArea(int x, int y, int w, int h) {
        super(x, y, w, h);
        this.scrollBarBackgroundColor = Color.withAlpha(Color.BLACK.main, 0.25f);
    }

    public ScrollArea() {
        this.scrollBarBackgroundColor = Color.withAlpha(Color.BLACK.main, 0.25f);
    }

    public void setScrollData(ScrollData data) {
        if (data instanceof HorizontalScrollData) {
            HorizontalScrollData scrollData;
            this.scrollX = scrollData = (HorizontalScrollData)data;
        } else if (data instanceof VerticalScrollData) {
            VerticalScrollData scrollData;
            this.scrollY = scrollData = (VerticalScrollData)data;
        }
    }

    public void removeScrollData() {
        this.scrollX = null;
        this.scrollY = null;
    }

    public void setScrollDataX(HorizontalScrollData scrollX) {
        this.scrollX = scrollX;
    }

    public void setScrollDataY(VerticalScrollData data) {
        this.scrollY = data;
    }

    public HorizontalScrollData getScrollX() {
        return this.scrollX;
    }

    public VerticalScrollData getScrollY() {
        return this.scrollY;
    }

    public ScrollData getScrollData(GuiAxis axis) {
        return axis.isVertical() ? this.scrollY : this.scrollX;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseClicked(GuiContext context) {
        return this.mouseClicked(context.getAbsMouseX(), context.getAbsMouseY());
    }

    public boolean mouseClicked(int x, int y) {
        ScrollData data;
        if (this.scrollX != null && this.scrollX.isInsideScrollbarArea(this, x, y)) {
            data = this.scrollX;
        } else if (this.scrollY != null && this.scrollY.isInsideScrollbarArea(this, x, y)) {
            data = this.scrollY;
        } else {
            return false;
        }
        return ((ScrollData)data).onMouseClicked(this, x, y, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseScroll(GuiContext context) {
        return this.mouseScroll(context.getAbsMouseX(), context.getAbsMouseY(), context.getMouseWheel(), GuiScreen.func_146272_n());
    }

    public boolean mouseScroll(int x, int y, int scroll, boolean shift) {
        ScrollData data;
        if (!this.isInside(x, y)) {
            return false;
        }
        if (this.scrollX != null) {
            data = this.scrollY == null || shift ? this.scrollX : this.scrollY;
        } else if (this.scrollY != null) {
            data = this.scrollY;
        } else {
            return false;
        }
        int scrollAmount = (int)Math.copySign(data.getScrollSpeed(), scroll);
        int scrollTo = data.isAnimating() ? data.getAnimatingTo() - scrollAmount : data.getScroll() - scrollAmount;
        int oldScroll = data.getScroll();
        data.scrollTo(this, scrollTo);
        boolean changed = data.getScroll() != oldScroll;
        data.scrollTo(this, oldScroll);
        if (changed) {
            data.animateTo(this, scrollTo);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void mouseReleased(GuiContext context) {
        this.mouseReleased(context.getAbsMouseX(), context.getAbsMouseY());
    }

    public void mouseReleased(int x, int y) {
        if (this.scrollX != null) {
            this.scrollX.dragging = false;
        }
        if (this.scrollY != null) {
            this.scrollY.dragging = false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drag(GuiContext context) {
        this.drag(context.getMouseX(), context.getMouseY());
    }

    public void drag(int x, int y) {
        ScrollData data;
        if (this.scrollX != null && this.scrollX.dragging) {
            data = this.scrollX;
        } else if (this.scrollY != null && this.scrollY.dragging) {
            data = this.scrollY;
        } else {
            return;
        }
        float progress = data.getProgress(this, x, y);
        data.animateTo(this, (int)(progress * (float)(data.getScrollSize() - data.getVisibleSize(this) + data.getThickness())));
    }

    public boolean isInsideScrollbarArea(int x, int y) {
        if (!this.isInside(x, y)) {
            return false;
        }
        if (this.scrollX != null && this.scrollX.isInsideScrollbarArea(this, x, y)) {
            return true;
        }
        return this.scrollY != null && this.scrollY.isInsideScrollbarArea(this, x, y);
    }

    public boolean isScrollBarXActive() {
        return this.scrollX != null && this.scrollX.isScrollBarActive(this);
    }

    public boolean isScrollBarYActive() {
        return this.scrollY != null && this.scrollY.isScrollBarActive(this);
    }

    public int getScrollBarBackgroundColor() {
        return this.scrollBarBackgroundColor;
    }

    public void setScrollBarBackgroundColor(int scrollBarBackgroundColor) {
        this.scrollBarBackgroundColor = scrollBarBackgroundColor;
    }

    @SideOnly(value=Side.CLIENT)
    public void drawScrollbar() {
        boolean b = false;
        if (this.scrollX != null && this.scrollX.isScrollBarActive(this, false)) {
            b = true;
            this.scrollX.drawScrollbar(this);
        }
        if (this.scrollY != null && this.scrollY.isScrollBarActive(this, b)) {
            this.scrollY.drawScrollbar(this);
        }
    }
}

