/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen;

import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.layout.IViewport;
import com.cleanroommc.modularui.api.layout.IViewportStack;
import com.cleanroommc.modularui.api.widget.IFocusedWidget;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.screen.viewport.GuiViewportStack;
import com.cleanroommc.modularui.screen.viewport.LocatedWidget;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.Animator;
import com.cleanroommc.modularui.utils.HoveredWidgetList;
import com.cleanroommc.modularui.utils.Interpolation;
import com.cleanroommc.modularui.utils.ObjectList;
import com.cleanroommc.modularui.widget.ParentWidget;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.cleanroommc.modularui.widget.sizer.Flex;
import com.cleanroommc.modularui.widgets.SlotGroupWidget;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModularPanel
extends ParentWidget<ModularPanel>
implements IViewport {
    private static final int tapTime = 200;
    @NotNull
    private final String name;
    private ModularScreen screen;
    private State state = State.IDLE;
    private boolean cantDisposeNow = false;
    private final ObjectList<LocatedWidget> hovering = ObjectList.create();
    private final ObjectList<Interactable> acceptedInteractions = ObjectList.create();
    private boolean isMouseButtonHeld = false;
    private boolean isKeyHeld = false;
    @Nullable
    private LocatedWidget lastPressed;
    private long timePressed;
    private int lastMouseButton;
    private Animator animator;
    private float scale = 1.0f;
    private float alpha = 1.0f;

    public static ModularPanel defaultPanel(@NotNull String name) {
        return ModularPanel.defaultPanel(name, 176, 166);
    }

    public static ModularPanel defaultPanel(@NotNull String name, int width, int height) {
        ModularPanel panel = new ModularPanel(name);
        panel.flex().startDefaultMode();
        ((Flex)panel.flex().size(width, height)).align(Alignment.Center);
        panel.flex().endDefaultMode();
        return panel;
    }

    public ModularPanel(@NotNull String name) {
        this.name = Objects.requireNonNull(name, "A panels name must not be null and should be unique!");
    }

    @Override
    @NotNull
    public ModularPanel getPanel() {
        return this;
    }

    @Override
    public Area getParentArea() {
        return this.getScreen().getScreenArea();
    }

    @Override
    public void onInit() {
        this.getScreen().registerFrameUpdateListener(this, this::findHoveredWidgets, false);
    }

    public boolean isOpen() {
        return this.state == State.OPEN;
    }

    public void openIn(ModularScreen screen) {
        if (this.isOpen()) {
            throw new IllegalStateException("Panel is already open!");
        }
        screen.getPanelManager().openPanel(this);
    }

    public void closeIfOpen(boolean animate) {
        if (!animate || !this.shouldAnimate()) {
            this.screen.closePanel(this);
            return;
        }
        if (this.isOpen() && !this.isOpening() && !this.isClosing()) {
            if (this.isMainPanel()) {
                for (ModularPanel panel : this.getScreen().getPanelManager().getOpenPanels()) {
                    if (panel.isMainPanel()) continue;
                    panel.closeIfOpen(true);
                }
            }
            this.getAnimator().setEndCallback(val -> this.screen.closePanel(this)).backward();
        }
    }

    public void closeIfOpen() {
        this.closeIfOpen(false);
    }

    public void animateClose() {
        this.closeIfOpen(true);
    }

    @Override
    public boolean hasParent() {
        return false;
    }

    @Override
    public WidgetTheme getWidgetTheme(ITheme theme) {
        return theme.getPanelTheme();
    }

    @Override
    public void transform(IViewportStack stack) {
        super.transform(stack);
        if (this.getScale() != 1.0f) {
            float x = (float)this.getArea().w() / 2.0f;
            float y = (float)this.getArea().h() / 2.0f;
            stack.translate(x, y);
            stack.scale(this.getScale(), this.getScale());
            stack.translate(-x, -y);
        }
    }

    @Override
    public void getWidgetsAt(IViewportStack stack, HoveredWidgetList widgets, int x, int y) {
        if (this.hasChildren()) {
            IViewport.getChildrenAt(this, stack, widgets, x, y);
        }
    }

    @Override
    public void getSelfAt(IViewportStack stack, HoveredWidgetList widgets, int x, int y) {
        if (this.isInside(stack, x, y)) {
            widgets.add(this, stack.peek());
        }
    }

    private void findHoveredWidgets() {
        this.hovering.clear();
        this.hovering.trim();
        if (!this.isEnabled()) {
            return;
        }
        HoveredWidgetList widgetList = new HoveredWidgetList(this.hovering);
        this.getContext().reset();
        GuiViewportStack stack = new GuiViewportStack();
        stack.pushViewport(null, this.getScreen().getScreenArea());
        stack.pushViewport(this, this.getArea());
        this.transform(stack);
        this.getSelfAt(stack, widgetList, this.getContext().getAbsMouseX(), this.getContext().getAbsMouseY());
        this.transformChildren(stack);
        this.getWidgetsAt(stack, widgetList, this.getContext().getAbsMouseX(), this.getContext().getAbsMouseY());
        stack.popViewport(this);
        stack.popViewport(null);
    }

    @MustBeInvokedByOverriders
    public void onOpen(ModularScreen screen) {
        this.screen = screen;
        this.getArea().z(1);
        this.scale = 1.0f;
        this.alpha = 1.0f;
        this.initialise(this);
        if (this.shouldAnimate()) {
            this.scale = 0.75f;
            this.alpha = 0.0f;
            this.getAnimator().setEndCallback(value -> {
                this.scale = 1.0f;
                this.alpha = 1.0f;
            }).forward();
        }
        this.state = State.OPEN;
    }

    void reopen() {
        if (this.state != State.CLOSED) {
            throw new IllegalStateException();
        }
        this.state = State.OPEN;
    }

    @MustBeInvokedByOverriders
    public void onClose() {
        this.state = State.CLOSED;
    }

    @Override
    @MustBeInvokedByOverriders
    public void dispose() {
        if (this.state == State.DISPOSED) {
            return;
        }
        if (this.state != State.CLOSED && this.state != State.WAIT_DISPOSING) {
            throw new IllegalStateException("Panel must be closed before disposing!");
        }
        if (this.cantDisposeNow) {
            this.state = State.WAIT_DISPOSING;
            return;
        }
        this.getContext().getJeiSettings().removeJeiExclusionArea(this);
        super.dispose();
        this.screen = null;
        this.state = State.DISPOSED;
    }

    public final <T> T doSafe(Supplier<T> runnable) {
        if (this.state == State.DISPOSED) {
            return null;
        }
        return (T)this.getScreen().getPanelManager().doSafe(() -> {
            this.cantDisposeNow = true;
            Object t = runnable.get();
            this.cantDisposeNow = false;
            if (this.state == State.WAIT_DISPOSING) {
                this.state = State.CLOSED;
                this.dispose();
            }
            return t;
        });
    }

    public final boolean doSafeBool(BooleanSupplier runnable) {
        return Objects.requireNonNull(this.doSafe(runnable::getAsBoolean));
    }

    public final int doSafeInt(IntSupplier runnable) {
        return Objects.requireNonNull(this.doSafe(runnable::getAsInt));
    }

    @ApiStatus.OverrideOnly
    public boolean onMousePressed(int mouseButton) {
        return this.doSafeBool(() -> {
            LocatedWidget pressed = LocatedWidget.EMPTY;
            boolean result = false;
            if (this.hovering.isEmpty()) {
                if (this.closeOnOutOfBoundsClick()) {
                    this.animateClose();
                    result = true;
                }
            } else {
                ObjectListIterator objectListIterator = this.hovering.iterator();
                block6: while (objectListIterator.hasNext()) {
                    LocatedWidget widget = (LocatedWidget)objectListIterator.next();
                    widget.applyMatrix(this.getContext());
                    Object patt9452$temp = widget.getElement();
                    if (patt9452$temp instanceof Interactable) {
                        Interactable interactable = (Interactable)patt9452$temp;
                        switch (interactable.onMousePressed(mouseButton)) {
                            case IGNORE: {
                                break;
                            }
                            case ACCEPT: {
                                if (!this.isKeyHeld && !this.isMouseButtonHeld) {
                                    this.acceptedInteractions.add(interactable);
                                }
                                pressed = widget;
                                break;
                            }
                            case STOP: {
                                pressed = LocatedWidget.EMPTY;
                                result = true;
                                widget.unapplyMatrix(this.getContext());
                                break block6;
                            }
                            case SUCCESS: {
                                if (!this.isKeyHeld && !this.isMouseButtonHeld) {
                                    this.acceptedInteractions.add(interactable);
                                }
                                pressed = widget;
                                result = true;
                                widget.unapplyMatrix(this.getContext());
                                break block6;
                            }
                        }
                    }
                    if (this.getContext().onHoveredClick(mouseButton, widget)) {
                        pressed = LocatedWidget.EMPTY;
                        result = true;
                        widget.unapplyMatrix(this.getContext());
                        break;
                    }
                    widget.unapplyMatrix(this.getContext());
                }
            }
            if (result && pressed.getElement() instanceof IFocusedWidget) {
                this.getContext().focus(pressed);
            } else {
                this.getContext().removeFocus();
            }
            if (!this.isKeyHeld && !this.isMouseButtonHeld) {
                this.lastPressed = pressed;
                if (this.lastPressed.getElement() != null) {
                    this.timePressed = Minecraft.func_71386_F();
                }
                this.lastMouseButton = mouseButton;
                this.isMouseButtonHeld = true;
            }
            return result;
        });
    }

    @ApiStatus.OverrideOnly
    public boolean onMouseRelease(int mouseButton) {
        return this.isEnabled() && this.doSafeBool(() -> {
            if (this.interactFocused(widget -> ((Interactable)((Object)widget)).onMouseRelease(mouseButton), false).booleanValue()) {
                return true;
            }
            boolean result = false;
            boolean tryTap = mouseButton == this.lastMouseButton && Minecraft.func_71386_F() - this.timePressed < 200L;
            ObjectListIterator objectListIterator = this.hovering.iterator();
            while (objectListIterator.hasNext()) {
                LocatedWidget widget2 = (LocatedWidget)objectListIterator.next();
                Object patt12379$temp = widget2.getElement();
                if (!(patt12379$temp instanceof Interactable)) continue;
                Interactable interactable = (Interactable)patt12379$temp;
                widget2.applyMatrix(this.getContext());
                if (interactable.onMouseRelease(mouseButton)) {
                    result = true;
                    widget2.applyMatrix(this.getContext());
                    break;
                }
                if (tryTap && this.acceptedInteractions.remove(interactable)) {
                    boolean bl;
                    Interactable.Result tabResult = interactable.onMouseTapped(mouseButton);
                    switch (tabResult) {
                        case SUCCESS: 
                        case STOP: {
                            bl = false;
                            break;
                        }
                        default: {
                            bl = true;
                        }
                    }
                    tryTap = bl;
                }
                widget2.unapplyMatrix(this.getContext());
            }
            this.acceptedInteractions.clear();
            this.lastMouseButton = -1;
            this.timePressed = 0L;
            this.isMouseButtonHeld = false;
            return result;
        });
    }

    @ApiStatus.OverrideOnly
    public boolean onKeyPressed(char typedChar, int keyCode) {
        return this.doSafeBool(() -> {
            switch (this.interactFocused(widget -> ((Interactable)((Object)widget)).onKeyPressed(typedChar, keyCode), Interactable.Result.IGNORE)) {
                case SUCCESS: 
                case STOP: {
                    if (!this.isKeyHeld && !this.isMouseButtonHeld) {
                        this.lastPressed = this.getContext().getFocusedWidget();
                        if (this.lastPressed != null) {
                            this.timePressed = Minecraft.func_71386_F();
                        }
                        this.lastMouseButton = keyCode;
                        this.isKeyHeld = true;
                    }
                    return true;
                }
            }
            LocatedWidget pressed = null;
            boolean result = false;
            ObjectListIterator objectListIterator = this.hovering.iterator();
            block9: while (objectListIterator.hasNext()) {
                LocatedWidget widget2 = (LocatedWidget)objectListIterator.next();
                Object patt14342$temp = widget2.getElement();
                if (!(patt14342$temp instanceof Interactable)) continue;
                Interactable interactable = (Interactable)patt14342$temp;
                widget2.applyMatrix(this.getContext());
                switch (interactable.onKeyPressed(typedChar, keyCode)) {
                    case IGNORE: {
                        break;
                    }
                    case ACCEPT: {
                        if (!this.isKeyHeld && !this.isMouseButtonHeld) {
                            this.acceptedInteractions.add(interactable);
                        }
                        pressed = widget2;
                        break;
                    }
                    case STOP: {
                        pressed = null;
                        result = true;
                        widget2.unapplyMatrix(this.getContext());
                        break block9;
                    }
                    case SUCCESS: {
                        if (!this.isKeyHeld && !this.isMouseButtonHeld) {
                            this.acceptedInteractions.add(interactable);
                        }
                        pressed = widget2;
                        result = true;
                        widget2.unapplyMatrix(this.getContext());
                        break block9;
                    }
                }
            }
            if (!this.isKeyHeld && !this.isMouseButtonHeld) {
                this.lastPressed = pressed;
                if (this.lastPressed != null) {
                    this.timePressed = Minecraft.func_71386_F();
                }
                this.lastMouseButton = keyCode;
                this.isKeyHeld = true;
            }
            return result;
        });
    }

    @ApiStatus.OverrideOnly
    public boolean onKeyRelease(char typedChar, int keyCode) {
        return this.doSafeBool(() -> {
            if (this.interactFocused(widget -> ((Interactable)((Object)widget)).onKeyRelease(typedChar, keyCode), false).booleanValue()) {
                return true;
            }
            boolean result = false;
            boolean tryTap = keyCode == this.lastMouseButton && Minecraft.func_71386_F() - this.timePressed < 200L;
            ObjectListIterator objectListIterator = this.hovering.iterator();
            while (objectListIterator.hasNext()) {
                LocatedWidget widget2 = (LocatedWidget)objectListIterator.next();
                Object patt16614$temp = widget2.getElement();
                if (!(patt16614$temp instanceof Interactable)) continue;
                Interactable interactable = (Interactable)patt16614$temp;
                widget2.applyMatrix(this.getContext());
                if (interactable.onKeyRelease(typedChar, keyCode)) {
                    result = true;
                    widget2.unapplyMatrix(this.getContext());
                    break;
                }
                if (tryTap && this.acceptedInteractions.remove(interactable)) {
                    boolean bl;
                    Interactable.Result tabResult = interactable.onKeyTapped(typedChar, keyCode);
                    switch (tabResult) {
                        case SUCCESS: 
                        case STOP: {
                            bl = false;
                            break;
                        }
                        default: {
                            bl = true;
                        }
                    }
                    tryTap = bl;
                }
                widget2.unapplyMatrix(this.getContext());
            }
            this.acceptedInteractions.clear();
            this.lastMouseButton = -1;
            this.timePressed = 0L;
            this.isKeyHeld = false;
            return result;
        });
    }

    @ApiStatus.OverrideOnly
    public boolean onMouseScroll(ModularScreen.UpOrDown scrollDirection, int amount) {
        return this.doSafeBool(() -> {
            if (this.interactFocused(widget -> ((Interactable)((Object)widget)).onMouseScroll(scrollDirection, amount), false).booleanValue()) {
                return true;
            }
            if (this.hovering.isEmpty()) {
                return false;
            }
            ObjectListIterator objectListIterator = this.hovering.iterator();
            while (objectListIterator.hasNext()) {
                LocatedWidget widget2 = (LocatedWidget)objectListIterator.next();
                Object patt18057$temp = widget2.getElement();
                if (!(patt18057$temp instanceof Interactable)) continue;
                Interactable interactable = (Interactable)patt18057$temp;
                widget2.applyMatrix(this.getContext());
                boolean result = interactable.onMouseScroll(scrollDirection, amount);
                widget2.unapplyMatrix(this.getContext());
                if (!result) continue;
                return true;
            }
            return true;
        });
    }

    @ApiStatus.OverrideOnly
    public boolean onMouseDrag(int mouseButton, long timeSinceClick) {
        return this.doSafeBool(() -> {
            Object patt18750$temp;
            if (this.isMouseButtonHeld && mouseButton == this.lastMouseButton && this.lastPressed != null && (patt18750$temp = this.lastPressed.getElement()) instanceof Interactable) {
                Interactable interactable = (Interactable)patt18750$temp;
                this.lastPressed.applyMatrix(this.getContext());
                interactable.onMouseDrag(mouseButton, timeSinceClick);
                this.lastPressed.unapplyMatrix(this.getContext());
                return true;
            }
            return false;
        });
    }

    private <T, W extends IWidget & IFocusedWidget> T interactFocused(Function<W, T> function, T defaultValue) {
        LocatedWidget focused = this.getContext().getFocusedWidget();
        T result = defaultValue;
        Object t = focused.getElement();
        if (t instanceof Interactable) {
            Interactable interactable = (Interactable)t;
            focused.applyMatrix(this.getContext());
            result = function.apply((IWidget)((Object)interactable));
            focused.unapplyMatrix(this.getContext());
        }
        return result;
    }

    public boolean isDraggable() {
        return this.getScreen().getMainPanel() != this;
    }

    public boolean disablePanelsBelow() {
        return false;
    }

    public boolean closeOnOutOfBoundsClick() {
        return false;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public ModularScreen getScreen() {
        if (!this.isValid()) {
            throw new IllegalStateException();
        }
        return this.screen;
    }

    @NotNull
    public ObjectList<LocatedWidget> getHovering() {
        return this.hovering;
    }

    @Nullable
    public IWidget getTopHovering() {
        LocatedWidget lw = this.getTopHoveringLocated(false);
        return lw == null ? null : (IWidget)lw.getElement();
    }

    @Nullable
    public LocatedWidget getTopHoveringLocated(boolean debug) {
        ObjectListIterator objectListIterator = this.hovering.iterator();
        while (objectListIterator.hasNext()) {
            LocatedWidget widget = (LocatedWidget)objectListIterator.next();
            if (!debug && !((IWidget)widget.getElement()).canHover()) continue;
            return widget;
        }
        return null;
    }

    @Override
    public int getDefaultHeight() {
        return 166;
    }

    @Override
    public int getDefaultWidth() {
        return 176;
    }

    final void setPanelGuiContext(@NotNull GuiContext context) {
        this.setContext(context);
        context.getJeiSettings().addJeiExclusionArea(this);
    }

    public boolean isOpening() {
        return this.animator != null && this.animator.isRunningForwards();
    }

    public boolean isClosing() {
        return this.animator != null && this.animator.isRunningBackwards();
    }

    public float getScale() {
        return this.scale;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public final boolean isMainPanel() {
        return this.getScreen().getMainPanel() == this;
    }

    @NotNull
    protected Animator getAnimator() {
        if (this.animator == null) {
            this.animator = new Animator(this.getScreen().getCurrentTheme().getOpenCloseAnimationOverride(), Interpolation.QUINT_OUT).setValueBounds(0.0f, 1.0f).setCallback(val -> {
                this.alpha = (float)val;
                this.scale = (float)val * 0.25f + 0.75f;
            });
        }
        return this.animator;
    }

    public boolean shouldAnimate() {
        return this.getScreen().getCurrentTheme().getOpenCloseAnimationOverride() > 0;
    }

    public ModularPanel bindPlayerInventory() {
        return (ModularPanel)this.child(SlotGroupWidget.playerInventory());
    }

    public ModularPanel bindPlayerInventory(int bottom) {
        return (ModularPanel)this.child(SlotGroupWidget.playerInventory(bottom));
    }

    @Override
    public String toString() {
        return super.toString() + "#" + this.getName();
    }

    public State getState() {
        return this.state;
    }

    public static enum State {
        IDLE,
        OPEN,
        CLOSED,
        DISPOSED,
        WAIT_DISPOSING;

    }
}

