/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen;

import com.cleanroommc.modularui.api.JeiSettings;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.integration.jei.GhostIngredientTarget;
import com.cleanroommc.modularui.integration.jei.JeiGhostIngredientSlot;
import com.cleanroommc.modularui.integration.jei.JeiState;
import com.cleanroommc.modularui.screen.ModularScreen;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;

@SideOnly(value=Side.CLIENT)
public class JeiSettingsImpl
implements JeiSettings {
    private JeiState jeiState = JeiState.DEFAULT;
    private final List<IWidget> jeiExclusionWidgets = new ArrayList<IWidget>();
    private final List<Rectangle> jeiExclusionAreas = new ArrayList<Rectangle>();
    private final List<JeiGhostIngredientSlot<?>> jeiGhostIngredientSlots = new ArrayList();

    @Override
    public void enableJei() {
        this.jeiState = JeiState.ENABLED;
    }

    @Override
    public void disableJei() {
        this.jeiState = JeiState.DISABLED;
    }

    @Override
    public void defaultJei() {
        this.jeiState = JeiState.DEFAULT;
    }

    @Override
    public boolean isJeiEnabled(ModularScreen screen) {
        return this.jeiState.test(screen);
    }

    @Override
    public void addJeiExclusionArea(Rectangle area) {
        if (!this.jeiExclusionAreas.contains(area)) {
            this.jeiExclusionAreas.add(area);
        }
    }

    @Override
    public void removeJeiExclusionArea(Rectangle area) {
        this.jeiExclusionAreas.remove(area);
    }

    @Override
    public void addJeiExclusionArea(IWidget area) {
        if (!this.jeiExclusionWidgets.contains(area)) {
            this.jeiExclusionWidgets.add(area);
        }
    }

    @Override
    public void removeJeiExclusionArea(IWidget area) {
        this.jeiExclusionWidgets.remove(area);
    }

    @Override
    public <W extends IWidget & JeiGhostIngredientSlot<?>> void addJeiGhostIngredientSlot(W slot) {
        this.jeiGhostIngredientSlots.add(slot);
    }

    @Override
    public <W extends IWidget & JeiGhostIngredientSlot<?>> void removeJeiGhostIngredientSlot(W slot) {
        this.jeiGhostIngredientSlots.remove(slot);
    }

    public @UnmodifiableView List<Rectangle> getJeiExclusionAreas() {
        return Collections.unmodifiableList(this.jeiExclusionAreas);
    }

    public @UnmodifiableView List<IWidget> getJeiExclusionWidgets() {
        return Collections.unmodifiableList(this.jeiExclusionWidgets);
    }

    public @UnmodifiableView List<JeiGhostIngredientSlot<?>> getJeiGhostIngredientSlots() {
        return Collections.unmodifiableList(this.jeiGhostIngredientSlots);
    }

    @ApiStatus.Internal
    public List<Rectangle> getAllJeiExclusionAreas() {
        this.jeiExclusionWidgets.removeIf(widget -> !widget.isValid());
        ArrayList<Rectangle> areas = new ArrayList<Rectangle>(this.jeiExclusionAreas);
        areas.addAll(this.jeiExclusionWidgets.stream().filter(IWidget::isEnabled).map(IWidget::getArea).collect(Collectors.toList()));
        return areas;
    }

    @Optional.Method(modid="jei")
    @ApiStatus.Internal
    public <I> List<IGhostIngredientHandler.Target<I>> getAllGhostIngredientTargets(@NotNull I ingredient) {
        ArrayList<IGhostIngredientHandler.Target<I>> ghostHandlerTargets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        Iterator<JeiGhostIngredientSlot<?>> iterator = this.jeiGhostIngredientSlots.iterator();
        while (iterator.hasNext()) {
            JeiGhostIngredientSlot<?> slot = iterator.next();
            IWidget widget = (IWidget)((Object)slot);
            if (!widget.isValid()) {
                iterator.remove();
                continue;
            }
            if (!widget.isEnabled() || slot.castGhostIngredientIfValid(ingredient) == null) continue;
            JeiGhostIngredientSlot<?> slotWithType = slot;
            ghostHandlerTargets.add(new GhostIngredientTarget(widget, slotWithType));
        }
        return ghostHandlerTargets;
    }
}

