/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.integration.jei;

import com.cleanroommc.modularui.api.widget.IGuiElement;
import com.cleanroommc.modularui.integration.jei.JeiIngredientProvider;
import com.cleanroommc.modularui.integration.jei.JeiRecipeTransferHandler;
import com.cleanroommc.modularui.screen.GuiScreenWrapper;
import com.cleanroommc.modularui.screen.ModularContainer;
import com.cleanroommc.modularui.screen.ModularScreen;
import java.awt.Rectangle;
import java.util.List;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.gui.IGhostIngredientHandler;
import mezz.jei.api.gui.IGuiProperties;
import mezz.jei.api.gui.IGuiScreenHandler;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.gui.overlay.GuiProperties;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModularUIHandler
implements IAdvancedGuiHandler<GuiScreenWrapper>,
IGhostIngredientHandler<GuiScreenWrapper>,
IGuiScreenHandler<GuiScreenWrapper>,
IRecipeTransferHandler<ModularContainer> {
    @NotNull
    public Class<GuiScreenWrapper> getGuiContainerClass() {
        return GuiScreenWrapper.class;
    }

    @Nullable
    public List<Rectangle> getGuiExtraAreas(@NotNull GuiScreenWrapper guiContainer) {
        return guiContainer.getScreen().getContext().getJeiSettings().getAllJeiExclusionAreas();
    }

    @Nullable
    public Object getIngredientUnderMouse(@NotNull GuiScreenWrapper guiContainer, int mouseX, int mouseY) {
        Object object;
        IGuiElement hovered = guiContainer.getScreen().getContext().getHovered();
        if (hovered instanceof JeiIngredientProvider) {
            JeiIngredientProvider jip = (JeiIngredientProvider)((Object)hovered);
            object = jip.getIngredient();
        } else {
            object = null;
        }
        return object;
    }

    @NotNull
    public <I> List<IGhostIngredientHandler.Target<I>> getTargets(GuiScreenWrapper gui, @NotNull I ingredient, boolean doStart) {
        return gui.getScreen().getContext().getJeiSettings().getAllGhostIngredientTargets(ingredient);
    }

    public void onComplete() {
    }

    @Nullable
    public IGuiProperties apply(@NotNull GuiScreenWrapper guiScreen) {
        return guiScreen.getScreen().getContext().getJeiSettings().isJeiEnabled(guiScreen.getScreen()) ? GuiProperties.create((GuiContainer)guiScreen) : null;
    }

    @NotNull
    public Class<ModularContainer> getContainerClass() {
        return ModularContainer.class;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(@NotNull ModularContainer container, @NotNull IRecipeLayout recipeLayout, @NotNull EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        ModularScreen screen = ModularScreen.getCurrent();
        if (screen instanceof JeiRecipeTransferHandler) {
            JeiRecipeTransferHandler recipeTransferHandler = (JeiRecipeTransferHandler)((Object)screen);
            return recipeTransferHandler.transferRecipe(recipeLayout, maxTransfer, !doTransfer);
        }
        return null;
    }
}

