/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.factory;

import com.cleanroommc.modularui.api.JeiSettings;
import com.cleanroommc.modularui.api.UIFactory;
import com.cleanroommc.modularui.factory.GuiData;
import com.cleanroommc.modularui.network.NetworkHandler;
import com.cleanroommc.modularui.network.packets.OpenGuiPacket;
import com.cleanroommc.modularui.screen.GuiScreenWrapper;
import com.cleanroommc.modularui.screen.JeiSettingsImpl;
import com.cleanroommc.modularui.screen.ModularContainer;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.value.sync.GuiSyncManager;
import com.cleanroommc.modularui.widget.WidgetTree;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class GuiManager {
    private static final Object2ObjectMap<String, UIFactory<?>> FACTORIES = new Object2ObjectOpenHashMap(16);
    private static GuiScreenWrapper lastMui;
    private static final List<EntityPlayer> openedContainers;

    public static void registerFactory(UIFactory<?> factory) {
        Objects.requireNonNull(factory);
        String name = Objects.requireNonNull(factory.getFactoryName());
        if (name.length() > 32) {
            throw new IllegalArgumentException("The factory name length must not exceed 32!");
        }
        if (FACTORIES.containsKey((Object)name)) {
            throw new IllegalArgumentException("Factory with name '" + name + "' is already registered!");
        }
        FACTORIES.put((Object)name, factory);
    }

    @NotNull
    public static UIFactory<?> getFactory(String name) {
        UIFactory factory = (UIFactory)FACTORIES.get((Object)name);
        if (factory == null) {
            throw new NoSuchElementException();
        }
        return factory;
    }

    public static <T extends GuiData> void open(@NotNull UIFactory<T> factory, @NotNull T guiData, EntityPlayerMP player) {
        if (player instanceof FakePlayer || openedContainers.contains(player)) {
            return;
        }
        openedContainers.add((EntityPlayer)player);
        guiData.setJeiSettings(JeiSettings.DUMMY);
        GuiSyncManager syncManager = new GuiSyncManager((EntityPlayer)player);
        ModularPanel panel = factory.createPanel(guiData, syncManager);
        WidgetTree.collectSyncValues(syncManager, panel);
        ModularContainer container = new ModularContainer(syncManager);
        player.func_71117_bO();
        player.func_71128_l();
        int windowId = player.field_71139_cq;
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        factory.writeGuiData(guiData, buffer);
        NetworkHandler.sendToPlayer(new OpenGuiPacket<T>(windowId, factory, buffer), player);
        player.field_71070_bA = container;
        player.field_71070_bA.field_75152_c = windowId;
        player.field_71070_bA.func_75132_a((IContainerListener)player);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((EntityPlayer)player, (Container)container));
    }

    @SideOnly(value=Side.CLIENT)
    public static <T extends GuiData> void open(int windowId, @NotNull UIFactory<T> factory, @NotNull PacketBuffer data, @NotNull EntityPlayerSP player) {
        T guiData = factory.readGuiData((EntityPlayer)player, data);
        JeiSettingsImpl jeiSettings = new JeiSettingsImpl();
        ((GuiData)guiData).setJeiSettings(jeiSettings);
        GuiSyncManager syncManager = new GuiSyncManager((EntityPlayer)player);
        ModularPanel panel = factory.createPanel(guiData, syncManager);
        WidgetTree.collectSyncValues(syncManager, panel);
        ModularScreen screen = factory.createScreen(guiData, panel);
        screen.getContext().setJeiSettings(jeiSettings);
        GuiScreenWrapper guiScreenWrapper = new GuiScreenWrapper(new ModularContainer(syncManager), screen);
        guiScreenWrapper.field_147002_h.field_75152_c = windowId;
        Minecraft.func_71410_x().func_147108_a((GuiScreen)guiScreenWrapper);
        player.field_71070_bA = guiScreenWrapper.field_147002_h;
    }

    @SideOnly(value=Side.CLIENT)
    static void openScreen(ModularScreen screen, JeiSettingsImpl jeiSettings) {
        screen.getContext().setJeiSettings(jeiSettings);
        GuiScreenWrapper screenWrapper = new GuiScreenWrapper(new ModularContainer(), screen);
        Minecraft.func_71410_x().func_147108_a((GuiScreen)screenWrapper);
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            openedContainers.clear();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onGuiOpen(GuiOpenEvent event) {
        if (lastMui != null && event.getGui() == null) {
            if (lastMui.getScreen().getPanelManager().isOpen()) {
                lastMui.getScreen().getPanelManager().closeAll();
            }
            lastMui.getScreen().getPanelManager().dispose();
            lastMui = null;
        } else {
            GuiScreen guiScreen = event.getGui();
            if (guiScreen instanceof GuiScreenWrapper) {
                GuiScreenWrapper screenWrapper = (GuiScreenWrapper)guiScreen;
                if (lastMui == null) {
                    lastMui = screenWrapper;
                } else if (lastMui == event.getGui()) {
                    lastMui.getScreen().getPanelManager().reopen();
                } else {
                    if (lastMui.getScreen().getPanelManager().isOpen()) {
                        lastMui.getScreen().getPanelManager().closeAll();
                    }
                    lastMui.getScreen().getPanelManager().dispose();
                    lastMui = screenWrapper;
                }
            }
        }
    }

    static {
        openedContainers = new ArrayList<EntityPlayer>(4);
    }
}

