/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.utility;

import ca.wescook.nutrition.api.ItemStackCompareType;
import ca.wescook.nutrition.nutrients.JsonNutrient;
import ca.wescook.nutrition.nutrients.Nutrient;
import ca.wescook.nutrition.utility.CompareUtil;
import ca.wescook.nutrition.utility.Config;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Optional;
import org.apache.commons.io.FileUtils;

public class DataUpdater {
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(JsonNutrient.Food.ItemId.class, (Object)new JsonNutrient.Food.ItemId.Adapter()).enableComplexMapKeySerialization().setPrettyPrinting().create();

    public static void add(Nutrient nutrient, Nutrient.ScaledItemStack scaledItemStack) {
        File nutrientFile = new File(new File(Config.configDirectory, "nutrition/nutrients"), nutrient.name + ".json");
        try {
            JsonReader jsonReader = new JsonReader((Reader)new FileReader(nutrientFile));
            JsonNutrient jsonNutrient = (JsonNutrient)gson.fromJson(jsonReader, JsonNutrient.class);
            JsonNutrient.Food.ItemId itemId = new JsonNutrient.Food.ItemId();
            itemId.id = scaledItemStack.itemStack.func_77973_b().getRegistryName().toString();
            if (scaledItemStack.compareType != ItemStackCompareType.DEFAULT) {
                itemId.meta = scaledItemStack.itemStack.func_77960_j();
            }
            itemId.scale = scaledItemStack.scale;
            jsonNutrient.food.items.add(itemId);
            Collections.sort(jsonNutrient.food.items, (a, b) -> CompareUtil.compareTo(a.id, b.id));
            String json = DataUpdater.toJson(jsonNutrient);
            FileUtils.writeByteArrayToFile((File)nutrientFile, (byte[])json.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void edit(Nutrient nutrient, Nutrient.ScaledItemStack scaledItemStack) {
        File nutrientFile = new File(new File(Config.configDirectory, "nutrition/nutrients"), nutrient.name + ".json");
        try {
            JsonReader jsonReader = new JsonReader((Reader)new FileReader(nutrientFile));
            JsonNutrient jsonNutrient = (JsonNutrient)gson.fromJson(jsonReader, JsonNutrient.class);
            Optional<JsonNutrient.Food.ItemId> first = jsonNutrient.food.items.stream().filter(itemId -> itemId.id.equals(scaledItemStack.itemStack.func_77973_b().getRegistryName().toString()) && itemId.getMeta() == scaledItemStack.itemStack.func_77960_j()).findFirst();
            if (first.isPresent()) {
                JsonNutrient.Food.ItemId itemId2 = first.get();
                itemId2.scale = scaledItemStack.scale;
            }
            String json = DataUpdater.toJson(jsonNutrient);
            FileUtils.writeByteArrayToFile((File)nutrientFile, (byte[])json.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void remove(Nutrient nutrient, Nutrient.ScaledItemStack scaledItemStack) {
        File nutrientFile = new File(new File(Config.configDirectory, "nutrition/nutrients"), nutrient.name + ".json");
        try {
            JsonReader jsonReader = new JsonReader((Reader)new FileReader(nutrientFile));
            JsonNutrient jsonNutrient = (JsonNutrient)gson.fromJson(jsonReader, JsonNutrient.class);
            jsonNutrient.food.items.removeIf(itemId -> itemId.id.equals(scaledItemStack.itemStack.func_77973_b().getRegistryName().toString()) && itemId.getMeta() == scaledItemStack.itemStack.func_77960_j());
            String json = DataUpdater.toJson(jsonNutrient);
            FileUtils.writeByteArrayToFile((File)nutrientFile, (byte[])json.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String toJson(Object src) throws JsonIOException {
        StringWriter writer = new StringWriter();
        try {
            JsonWriter jsonWriter = gson.newJsonWriter(Streams.writerForAppendable((Appendable)writer));
            jsonWriter.setIndent("\t");
            gson.toJson(src, src.getClass(), jsonWriter);
            return writer.toString();
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }
}

