/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.utility;

import ca.wescook.nutrition.api.ItemStackCompareType;
import ca.wescook.nutrition.api.NutritionUtil;
import ca.wescook.nutrition.effects.Effect;
import ca.wescook.nutrition.effects.JsonEffect;
import ca.wescook.nutrition.nutrients.FoodHint;
import ca.wescook.nutrition.nutrients.JsonFoodHint;
import ca.wescook.nutrition.nutrients.JsonNutrient;
import ca.wescook.nutrition.nutrients.Nutrient;
import ca.wescook.nutrition.nutrients.NutrientList;
import ca.wescook.nutrition.utility.Config;
import ca.wescook.nutrition.utility.Log;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraftforge.fml.common.Loader;

public class DataParser {
    public static List<Nutrient> parseNutrients(List<JsonNutrient> jsonNutrients) {
        ArrayList<Nutrient> nutrients = new ArrayList<Nutrient>();
        for (JsonNutrient nutrientRaw : jsonNutrients) {
            if (nutrientRaw.enabled != null && !nutrientRaw.enabled.booleanValue()) continue;
            Nutrient nutrient = new Nutrient();
            try {
                nutrient.name = nutrientRaw.name;
                nutrient.icon = new ItemStack(Item.func_111206_d((String)nutrientRaw.icon));
                nutrient.color = Integer.parseUnsignedInt("ff" + nutrientRaw.color, 16);
            }
            catch (NullPointerException e) {
                Log.fatal("Missing or invalid JSON.  A name, icon, and color are required.");
                throw e;
            }
            if (nutrientRaw.decay == null) {
                nutrient.decay = Config.decayMultiplier;
            } else if (nutrientRaw.decay.floatValue() >= -100.0f && nutrientRaw.decay.floatValue() <= 100.0f) {
                nutrient.decay = nutrientRaw.decay.floatValue();
            } else {
                nutrient.decay = 0.0f;
                Log.error("Decay rate must be between -100 and 100 (" + nutrient.name + ").");
                continue;
            }
            boolean bl = nutrient.visible = nutrientRaw.visible == null || nutrientRaw.visible != false;
            if (nutrientRaw.food.oredict != null) {
                nutrient.foodOreDict = nutrientRaw.food.oredict;
            }
            if (nutrientRaw.food.items != null) {
                Iterator<JsonNutrient.Food.ItemId> iterator = nutrientRaw.food.items.iterator();
                while (iterator.hasNext()) {
                    JsonNutrient.Food.ItemId idScale;
                    String name = idScale.id;
                    idScale = iterator.next();
                    ItemStack itemStack = DataParser.getItemStack(name, idScale.getMeta());
                    if (itemStack == null) {
                        String modid = name.substring(0, name.indexOf(":"));
                        if (!Config.logMissingFood || !Loader.isModLoaded((String)modid)) continue;
                        Log.warn("Food with nutrients doesn't exist: " + name + " (" + nutrient.name + ")");
                        continue;
                    }
                    if (NutritionUtil.isValidFood(itemStack)) {
                        nutrient.addScaledItemStack(new Nutrient.ScaledItemStack(itemStack, (float)idScale.scale, idScale.meta == null ? ItemStackCompareType.DEFAULT : ItemStackCompareType.META_SENSITIVE));
                        continue;
                    }
                    Log.warn(name + " is not a valid food");
                }
            }
            nutrients.add(nutrient);
        }
        return nutrients;
    }

    public static List<Effect> parseEffects(List<JsonEffect> jsonEffects) {
        ArrayList<Effect> effects = new ArrayList<Effect>();
        for (JsonEffect effectRaw : jsonEffects) {
            if (effectRaw.enabled != null && !effectRaw.enabled.booleanValue()) continue;
            Potion potion = Potion.func_180142_b((String)effectRaw.potion);
            if (potion == null) {
                Log.error("Potion '" + effectRaw.potion + "' is not valid (" + effectRaw.name + ").");
                continue;
            }
            Effect effect = new Effect();
            effect.name = effectRaw.name;
            effect.potion = potion;
            effect.minimum = effectRaw.minimum;
            effect.maximum = effectRaw.maximum;
            effect.detect = effectRaw.detect;
            effect.amplifier = effectRaw.amplifier != null ? effectRaw.amplifier : 0;
            effect.cumulativeModifier = effectRaw.cumulative_modifier != null ? effectRaw.cumulative_modifier : 1;
            try {
                effect.particles = effectRaw.particles != null ? Effect.ParticleVisibility.valueOf(effectRaw.particles.toUpperCase()) : Effect.ParticleVisibility.TRANSPARENT;
            }
            catch (IllegalArgumentException exception) {
                Log.error("Particle visibility of '" + effect.name + "' is invalid.  Skipping effect.");
                continue;
            }
            if (effectRaw.nutrients.size() == 0) {
                effect.nutrients.addAll(NutrientList.get());
            } else {
                for (String nutrientName : effectRaw.nutrients) {
                    Nutrient nutrient = NutrientList.getByName(nutrientName);
                    if (nutrient != null) {
                        effect.nutrients.add(nutrient);
                        continue;
                    }
                    Log.error("Nutrient " + nutrientName + " not found (" + effectRaw.name + ").");
                }
            }
            effects.add(effect);
        }
        return effects;
    }

    public static List<FoodHint> parseFoodHints(Optional<JsonFoodHint> jsonFoodHints) {
        ArrayList<FoodHint> res = new ArrayList<FoodHint>();
        if (!jsonFoodHints.isPresent()) {
            return res;
        }
        for (JsonFoodHint.FoodHintRaw foodHintRaw : jsonFoodHints.get().hints) {
            FoodHint foodHint = new FoodHint();
            String name = foodHintRaw.id;
            ItemStack itemStack = DataParser.getItemStack(name, foodHintRaw.getMeta());
            if (itemStack == null) {
                String modid = name.substring(0, name.indexOf(":"));
                if (!Config.logMissingFood || !Loader.isModLoaded((String)modid)) continue;
                Log.warn("Food with nutrients doesn't exist: " + name);
                continue;
            }
            foodHint.itemStack = itemStack;
            foodHint.isValidFood = foodHintRaw.isValidFood;
            foodHint.healAmount = Math.max((float)foodHintRaw.healAmount, 0.0f);
            res.add(foodHint);
        }
        return res;
    }

    @Nullable
    private static ItemStack getItemStack(String name, int metadata) {
        Item item = Item.func_111206_d((String)name);
        if (item == null) {
            return null;
        }
        return new ItemStack(item, 1, metadata);
    }
}

