/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.nutrients;

import ca.wescook.nutrition.api.INutrient;
import ca.wescook.nutrition.api.INutrientItemEntry;
import ca.wescook.nutrition.api.ItemStackCompareType;
import ca.wescook.nutrition.nutrients.NutrientItemEntry;
import ca.wescook.nutrition.utility.Log;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class Nutrient
implements INutrient {
    public String name;
    public ItemStack icon;
    public int color;
    public float decay;
    public boolean visible;
    public List<String> foodOreDict = new ArrayList<String>();
    public List<ScaledItemStack> foodItems = new ArrayList<ScaledItemStack>();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ItemStack getIcon() {
        return this.icon;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public boolean isContainedIn(ItemStack itemStack) {
        for (ScaledItemStack listedFood : this.foodItems) {
            if (!listedFood.isMatch(itemStack)) continue;
            return true;
        }
        for (String listedOreDict : this.foodOreDict) {
            for (ItemStack itemStack1 : OreDictionary.getOres((String)listedOreDict)) {
                if (!itemStack1.func_77969_a(itemStack)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void registerFoodItem(INutrientItemEntry itemEntry) {
        NutrientItemEntry impl = (NutrientItemEntry)itemEntry;
        if (!this.addOrReplaceScaledItemStack(new ScaledItemStack(impl.itemStack, impl.scale, impl.compareType))) {
            Log.warn(impl.itemStack.func_82833_r() + " is duplicated in " + this.getName());
        }
    }

    @Nullable
    public Float getNutrientScale(ItemStack itemStack) {
        for (ScaledItemStack listedFood : this.foodItems) {
            if (!listedFood.isMatch(itemStack)) continue;
            return Float.valueOf(listedFood.scale);
        }
        for (String listedOreDict : this.foodOreDict) {
            for (ItemStack itemStack1 : OreDictionary.getOres((String)listedOreDict)) {
                if (!itemStack1.func_77969_a(itemStack)) continue;
                return Float.valueOf(1.0f);
            }
        }
        return null;
    }

    @Nullable
    public ScaledItemStack getScaledItemStack(ItemStack itemStack) {
        for (ScaledItemStack listedFood : this.foodItems) {
            if (!listedFood.isMatch(itemStack)) continue;
            return listedFood;
        }
        return null;
    }

    public void addScaledItemStack(ScaledItemStack scaledItemStack) {
        this.foodItems.add(scaledItemStack);
    }

    public boolean addOrReplaceScaledItemStack(ScaledItemStack scaledItemStack) {
        int index = Iterables.indexOf(this.foodItems, s -> s.isMatch(scaledItemStack.itemStack));
        if (index >= 0) {
            this.foodItems.set(index, scaledItemStack);
            return false;
        }
        this.foodItems.add(scaledItemStack);
        return true;
    }

    @Nullable
    public ScaledItemStack removeScaledItemStack(ItemStack itemStack) {
        for (int i = 0; i < this.foodItems.size(); ++i) {
            ScaledItemStack listedFood = this.foodItems.get(i);
            if (!listedFood.isMatch(itemStack)) continue;
            this.foodItems.remove(i);
            return listedFood;
        }
        return null;
    }

    public static class ScaledItemStack {
        public final ItemStack itemStack;
        public final float scale;
        public final ItemStackCompareType compareType;

        public ScaledItemStack(ItemStack itemStack, float scale) {
            this(itemStack, scale, ItemStackCompareType.META_SENSITIVE);
        }

        public ScaledItemStack(ItemStack itemStack, float scale, ItemStackCompareType compareType) {
            this.itemStack = itemStack;
            this.scale = scale;
            this.compareType = compareType;
        }

        public boolean isMatch(ItemStack itemStack) {
            boolean bl;
            switch (this.compareType) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case DEFAULT: {
                    if (!itemStack.func_190926_b() && this.itemStack.func_77973_b() == itemStack.func_77973_b()) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case META_SENSITIVE: {
                    bl = this.itemStack.func_77969_a(itemStack);
                    break;
                }
                case ONLY_NBT_SENSITIVE: {
                    bl = ItemStack.func_77970_a((ItemStack)this.itemStack, (ItemStack)itemStack);
                    break;
                }
                case ALL_SENSITIVE: {
                    bl = this.itemStack.func_77969_a(itemStack) && ItemStack.func_77970_a((ItemStack)this.itemStack, (ItemStack)itemStack);
                }
            }
            return bl;
        }
    }
}

