/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.nutrients;

import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class JsonNutrient {
    public String name;
    public String icon;
    public String color;
    public Float decay;
    public Boolean visible;
    public Boolean enabled;
    public Food food = new Food();

    public static class Food {
        public List<String> oredict = new ArrayList<String>();
        public List<ItemId> items = new ArrayList<ItemId>();

        public static class ItemId {
            public String id;
            @Nullable
            public Integer meta = null;
            public double scale = 1.0;

            public int getMeta() {
                return this.meta == null ? 0 : this.meta;
            }

            public static class Adapter
            extends TypeAdapter<ItemId> {
                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public ItemId read(JsonReader reader) throws IOException {
                    if (reader.peek() == JsonToken.NULL) {
                        reader.nextNull();
                        return null;
                    }
                    ItemId idScale = new ItemId();
                    if (reader.peek() == JsonToken.BEGIN_OBJECT) {
                        reader.beginObject();
                        block10: while (reader.hasNext()) {
                            String key;
                            switch (key = reader.nextName()) {
                                case "id": {
                                    idScale.id = reader.nextString();
                                    continue block10;
                                }
                                case "meta": {
                                    idScale.meta = reader.nextInt();
                                    continue block10;
                                }
                                case "scale": {
                                    idScale.scale = reader.nextDouble();
                                    continue block10;
                                }
                            }
                            throw new JsonSyntaxException("Unknown key:" + key);
                        }
                        reader.endObject();
                        if (idScale.id != null) return idScale;
                        throw new JsonSyntaxException("Missing id");
                    }
                    String idAndMeta = reader.nextString();
                    if (StringUtils.countMatches((CharSequence)idAndMeta, (CharSequence)":") == 2) {
                        idScale.id = StringUtils.substringBeforeLast((String)idAndMeta, (String)":");
                        String metaString = StringUtils.substringAfterLast((String)idAndMeta, (String)":");
                        if (!NumberUtils.isCreatable((String)metaString)) throw new JsonSyntaxException(idAndMeta + " does not contain valid metadata");
                        idScale.meta = Integer.decode(metaString);
                        return idScale;
                    } else {
                        idScale.id = idAndMeta;
                    }
                    return idScale;
                }

                public void write(JsonWriter writer, ItemId value) throws IOException {
                    if (value == null) {
                        writer.nullValue();
                        return;
                    }
                    if (value.scale == 1.0) {
                        if (value.meta == null) {
                            writer.value(value.id);
                        } else {
                            writer.value(value.id + ":" + value.meta);
                        }
                    } else {
                        writer.beginObject();
                        writer.name("id").value(value.id);
                        if (value.meta != null) {
                            writer.name("meta").value((Number)value.meta);
                        }
                        if (value.scale != 1.0) {
                            writer.name("scale").value(value.scale);
                        }
                        writer.endObject();
                    }
                }
            }
        }
    }
}

