/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.events;

import ca.wescook.nutrition.api.NutritionUtil;
import ca.wescook.nutrition.nutrients.Nutrient;
import ca.wescook.nutrition.nutrients.NutritionUtilImpl;
import com.google.common.collect.ArrayListMultimap;
import java.util.Collection;
import java.util.Map;
import java.util.StringJoiner;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventTooltip {
    @SubscribeEvent
    public void tooltipEvent(ItemTooltipEvent event) {
        ItemStack itemStack = event.getItemStack();
        if (!NutritionUtil.isValidFood(itemStack)) {
            return;
        }
        ArrayListMultimap nutritionValue2Nutrient = ArrayListMultimap.create();
        for (Map.Entry<Nutrient, Float> entry : NutritionUtilImpl.calculateNutrition(itemStack, event.getEntityPlayer()).entrySet()) {
            nutritionValue2Nutrient.put((Object)entry.getValue(), (Object)entry.getKey());
        }
        for (Float key : nutritionValue2Nutrient.keySet()) {
            event.getToolTip().add(EventTooltip.createTooltip(key.floatValue(), nutritionValue2Nutrient.get((Object)key)));
        }
    }

    private static String createTooltip(float nutritionValue, Collection<Nutrient> nutrients) {
        StringJoiner stringJoiner = new StringJoiner(", ");
        for (Nutrient nutrient : nutrients) {
            if (!nutrient.visible) continue;
            stringJoiner.add(I18n.func_135052_a((String)("nutrient.nutrition:" + nutrient.name), (Object[])new Object[0]));
        }
        String nutrientString = stringJoiner.toString();
        return I18n.func_135052_a((String)"tooltip.nutrition:nutrients", (Object[])new Object[0]) + " " + TextFormatting.DARK_GREEN + nutrientString + TextFormatting.DARK_AQUA + " (" + String.format("%.1f", Float.valueOf(nutritionValue)) + "%)";
    }
}

