/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.compat.ic2;

import ca.wescook.nutrition.api.INutritionFood;
import ca.wescook.nutrition.api.INutritionFoodAdapter;
import ca.wescook.nutrition.api.NutrientApplicationPhase;
import ca.wescook.nutrition.api.NutritionUtil;
import ic2.core.ref.ItemName;
import ic2.core.util.StackUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import org.jetbrains.annotations.Nullable;

public class CompatIC2 {
    public static void init() {
        if (!Loader.isModLoaded((String)"ic2")) {
            return;
        }
        NutritionUtil.register(new Adapter());
    }

    private static class Adapter
    implements INutritionFoodAdapter {
        private Adapter() {
        }

        @Override
        public boolean canApply(ItemStack itemStack) {
            return itemStack.func_77973_b() == ItemName.filled_tin_can.getInstance();
        }

        @Override
        public INutritionFood apply(ItemStack itemStack) {
            return FilledTinCan.INSTANCE;
        }

        private static class FilledTinCan
        implements INutritionFood {
            public static final FilledTinCan INSTANCE = new FilledTinCan();

            private FilledTinCan() {
            }

            @Override
            public int getHealAmount(ItemStack itemStack, @Nullable EntityPlayer player) {
                if (player == null) {
                    return 1;
                }
                return Math.min(StackUtil.getSize((ItemStack)itemStack), 20 - player.func_71024_bL().func_75116_a());
            }

            @Override
            public void setAlwaysEdible(ItemStack itemStack, @Nullable EntityPlayer player) {
            }

            @Override
            public NutrientApplicationPhase getNutrientApplicationPhase(ItemStack itemStack) {
                return NutrientApplicationPhase.ON_RIGHT_CLICK;
            }
        }
    }
}

