/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.selection.mode;

import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.mod.chiselsandbits.ChiselsAndBitsManager;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.selection.mode.AreaSelectionMode;
import com.creativemd.littletiles.common.world.WorldAnimationHandler;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public abstract class SelectionMode {
    private static LinkedHashMap<String, SelectionMode> modes = new LinkedHashMap();
    public static SelectionMode area = new AreaSelectionMode();
    public final String name;

    public static SelectionMode getMode(String id) {
        return modes.get(id);
    }

    public static SelectionMode getOrDefault(String id) {
        return modes.getOrDefault(id, area);
    }

    public static List<String> names() {
        return new ArrayList<String>(modes.keySet());
    }

    public SelectionMode(String name) {
        this.name = "mode.selection." + name;
        modes.put(this.name, this);
    }

    public abstract SelectionResult generateResult(World var1, ItemStack var2);

    public abstract void onLeftClick(EntityPlayer var1, ItemStack var2, BlockPos var3);

    public abstract void onRightClick(EntityPlayer var1, ItemStack var2, BlockPos var3);

    public abstract void clearSelection(ItemStack var1);

    public abstract LittlePreviews getPreviews(World var1, EntityPlayer var2, ItemStack var3, boolean var4, boolean var5, boolean var6, boolean var7) throws LittleActionException;

    public void saveSelection(ItemStack stack) {
    }

    public static class SelectionResult {
        public final World world;
        public BlockPos.MutableBlockPos min = null;
        public BlockPos.MutableBlockPos max = null;
        public int blocks;
        public int ltBlocks = 0;
        public int ltTiles = 0;
        public LittleGridContext minLtContext = null;
        public int cbBlocks = 0;
        public int cbTiles = 0;
        public LittleGridContext minCBContext = null;

        public SelectionResult(World world) {
            this.world = world;
        }

        private void addBlockDirectly(World world, BlockPos pos) {
            IBlockState state;
            LittlePreviews specialPreviews;
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileEntityLittleTiles) {
                ++this.ltBlocks;
                this.ltTiles += ((TileEntityLittleTiles)te).tilesCount();
                this.minLtContext = this.minLtContext == null ? ((TileEntityLittleTiles)te).getContext() : LittleGridContext.max(this.minLtContext, ((TileEntityLittleTiles)te).getContext());
            }
            if ((specialPreviews = ChiselsAndBitsManager.getPreviews(te)) != null) {
                ++this.cbBlocks;
                this.cbTiles += specialPreviews.size();
                this.minCBContext = this.minCBContext == null ? specialPreviews.getContext() : LittleGridContext.max(this.minCBContext, specialPreviews.getContext());
            }
            if (LittleAction.isBlockValid(state = world.func_180495_p(pos))) {
                ++this.blocks;
            }
        }

        public void addBlock(BlockPos pos) {
            if (this.min == null) {
                this.min = new BlockPos.MutableBlockPos(pos);
                this.max = new BlockPos.MutableBlockPos(pos);
            } else {
                this.min.func_181079_c(Math.min(this.min.func_177958_n(), pos.func_177958_n()), Math.min(this.min.func_177956_o(), pos.func_177956_o()), Math.min(this.min.func_177952_p(), pos.func_177952_p()));
                this.max.func_181079_c(Math.max(this.max.func_177958_n(), pos.func_177958_n()), Math.max(this.max.func_177956_o(), pos.func_177956_o()), Math.max(this.max.func_177952_p(), pos.func_177952_p()));
            }
            this.addBlockDirectly(this.world, pos);
        }

        protected void addBlocksWorld(World world, BlockPos pos, BlockPos pos2) {
            int minX = Math.min(pos.func_177958_n(), pos2.func_177958_n());
            int minY = Math.min(pos.func_177956_o(), pos2.func_177956_o());
            int minZ = Math.min(pos.func_177952_p(), pos2.func_177952_p());
            int maxX = Math.max(pos.func_177958_n(), pos2.func_177958_n());
            int maxY = Math.max(pos.func_177956_o(), pos2.func_177956_o());
            int maxZ = Math.max(pos.func_177952_p(), pos2.func_177952_p());
            if (this.min == null) {
                this.min = new BlockPos.MutableBlockPos(minX, minY, minZ);
                this.max = new BlockPos.MutableBlockPos(maxX, maxY, maxZ);
            } else {
                this.min.func_181079_c(Math.min(this.min.func_177958_n(), minX), Math.min(this.min.func_177956_o(), minY), Math.min(this.min.func_177952_p(), minZ));
                this.max.func_181079_c(Math.max(this.max.func_177958_n(), minX), Math.max(this.max.func_177956_o(), minY), Math.max(this.max.func_177952_p(), minZ));
            }
            BlockPos.MutableBlockPos mutPos = new BlockPos.MutableBlockPos();
            for (int posX = minX; posX <= maxX; ++posX) {
                for (int posY = minY; posY <= maxY; ++posY) {
                    for (int posZ = minZ; posZ <= maxZ; ++posZ) {
                        this.addBlockDirectly(world, (BlockPos)mutPos.func_181079_c(posX, posY, posZ));
                    }
                }
            }
        }

        public void addBlocks(BlockPos pos, BlockPos pos2) {
            int minX = Math.min(pos.func_177958_n(), pos2.func_177958_n());
            int minY = Math.min(pos.func_177956_o(), pos2.func_177956_o());
            int minZ = Math.min(pos.func_177952_p(), pos2.func_177952_p());
            int maxX = Math.max(pos.func_177958_n(), pos2.func_177958_n());
            int maxY = Math.max(pos.func_177956_o(), pos2.func_177956_o());
            int maxZ = Math.max(pos.func_177952_p(), pos2.func_177952_p());
            this.addBlocksWorld(this.world, pos, pos2);
            for (EntityAnimation animation : WorldAnimationHandler.getHandler(this.world).findAnimations(new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)(maxX + 1), (double)(maxY + 1), (double)(maxZ + 1)))) {
                this.addBlocksWorld((World)animation.fakeWorld, pos, pos2);
            }
        }

        public Vec3i getSize() {
            return new Vec3i(this.max.func_177958_n() - this.min.func_177958_n(), this.max.func_177956_o() - this.min.func_177956_o(), this.max.func_177952_p() - this.min.func_177952_p());
        }
    }
}

