/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile.math.location;

import com.creativemd.creativecore.common.world.CreativeWorld;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.exception.MissingAnimationException;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.world.WorldAnimationHandler;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StructureLocation {
    public final BlockPos pos;
    public final int index;
    public final UUID worldUUID;

    public StructureLocation(BlockPos pos, int index, UUID world) {
        this.pos = pos;
        this.index = index;
        this.worldUUID = world;
    }

    public StructureLocation(World world, BlockPos pos, int index) {
        this.pos = pos;
        this.index = index;
        this.worldUUID = world instanceof CreativeWorld ? ((CreativeWorld)world).parent.func_110124_au() : null;
    }

    public StructureLocation(LittleStructure structure) {
        this(structure.getWorld(), structure.getPos(), structure.getIndex());
    }

    public StructureLocation(NBTTagCompound nbt) {
        int[] posArray = nbt.func_74759_k("pos");
        if (posArray.length != 3) {
            throw new IllegalArgumentException("Invalid pos array length " + Arrays.toString(posArray));
        }
        this.pos = new BlockPos(posArray[0], posArray[1], posArray[2]);
        this.index = nbt.func_74762_e("index");
        this.worldUUID = nbt.func_74764_b("world") ? UUID.fromString(nbt.func_74779_i("world")) : null;
    }

    public NBTTagCompound write() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74783_a("pos", new int[]{this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p()});
        nbt.func_74768_a("index", this.index);
        if (this.worldUUID != null) {
            nbt.func_74778_a("world", this.worldUUID.toString());
        }
        return nbt;
    }

    public LittleStructure find(World world) throws LittleActionException {
        TileEntity te;
        if (this.worldUUID != null) {
            EntityAnimation animation = WorldAnimationHandler.findAnimation(world.field_72995_K, this.worldUUID);
            if (animation == null) {
                throw new MissingAnimationException(this.worldUUID);
            }
            world = animation.fakeWorld;
        }
        if ((te = world.func_175625_s(this.pos)) instanceof TileEntityLittleTiles) {
            IStructureTileList structure = ((TileEntityLittleTiles)te).getStructure(this.index);
            if (structure != null) {
                return structure.getStructure();
            }
            throw new LittleActionException.StructureNotFoundException();
        }
        throw new LittleActionException.TileEntityNotFoundException();
    }
}

