/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile;

import com.creativemd.creativecore.common.utils.mc.BlockUtils;
import com.creativemd.littletiles.client.render.tile.LittleRenderBox;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.api.block.ISpecialBlockHandler;
import com.creativemd.littletiles.common.api.block.SpecialBlockHandler;
import com.creativemd.littletiles.common.item.ItemBlockTiles;
import com.creativemd.littletiles.common.tile.combine.ICombinable;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxReturnedVolume;
import com.creativemd.littletiles.common.tile.math.box.face.LittleBoxFace;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.parent.IParentTileList;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.registry.LittleTileRegistry;
import com.creativemd.littletiles.common.tile.registry.LittleTileType;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleTile
implements ICombinable {
    private LittleBox box;
    public boolean invisible = false;
    public boolean glowing = false;
    private Block block;
    private int meta;
    private ISpecialBlockHandler handler;
    protected byte cachedTranslucent;
    protected IBlockState state = null;

    public LittleTile() {
    }

    public LittleTile(Block block, int meta) {
        this.setBlock(block, meta);
    }

    public LittleTileType getType() {
        return LittleTileRegistry.getTileType(this.getClass());
    }

    private void updateSpecialHandler() {
        if (!(this.block instanceof BlockAir)) {
            this.handler = SpecialBlockHandler.getSpecialBlockHandler(this.block, this.meta);
        }
        this.updateBlockState();
    }

    public boolean hasSpecialBlockHandler() {
        return this.handler != null;
    }

    protected void setBlock(String defaultName, Block block, int meta) {
        if (block == null || block instanceof BlockAir) {
            this.block = Blocks.field_150350_a;
            this.meta = meta;
            this.handler = MissingBlockHandler.getHandler(defaultName);
        } else {
            this.setBlock(block, meta);
        }
    }

    public void setBlock(Block block, int meta) {
        this.block = block;
        this.meta = meta;
        this.updateSpecialHandler();
    }

    public void setMeta(int meta) {
        this.meta = meta;
        this.updateSpecialHandler();
    }

    public void setBlock(Block block) {
        this.block = block;
        this.updateSpecialHandler();
    }

    public Block getBlock() {
        return this.block;
    }

    public int getMeta() {
        return this.meta;
    }

    public IBlockState getBlockState() {
        if (this.state == null) {
            this.updateBlockState();
        }
        return this.state;
    }

    public void updateBlockState() {
        this.state = BlockUtils.getState((Block)this.block, (int)this.meta);
        if (this.state == null) {
            this.state = this.block.func_176223_P();
        }
    }

    public boolean isTranslucent() {
        if (this.cachedTranslucent == 0) {
            this.updateTranslucent();
        }
        return this.cachedTranslucent == 2;
    }

    public void updateTranslucent() {
        this.cachedTranslucent = !this.getBlockState().func_185904_a().func_76228_b() || !this.getBlockState().func_185904_a().func_76220_a() || !this.getBlockState().func_185914_p() ? (byte)2 : (byte)1;
    }

    public int getSmallestContext(LittleGridContext context) {
        return this.box.getSmallestContext(context);
    }

    public void convertTo(LittleGridContext from, LittleGridContext to) {
        this.box.convertTo(from, to);
    }

    public boolean canBeConvertedToVanilla() {
        if (!this.box.isSolid()) {
            return false;
        }
        if (this.hasSpecialBlockHandler()) {
            return this.handler.canBeConvertedToVanilla(this);
        }
        return true;
    }

    @Override
    public LittleBox getBox() {
        return this.box;
    }

    @Override
    public void setBox(LittleBox box) {
        this.box = box;
    }

    public LittleVec getMinVec() {
        return this.box.getMinVec();
    }

    public int getMaxY() {
        return this.box.maxY;
    }

    public AxisAlignedBB getSelectedBox(BlockPos pos, LittleGridContext context) {
        return this.box.getSelectionBox(context, pos);
    }

    public double getVolume() {
        return this.box.getVolume();
    }

    public double getPercentVolume(LittleGridContext context) {
        return this.box.getPercentVolume(context);
    }

    public LittleVec getSize() {
        return this.box.getSize();
    }

    public boolean doesFillEntireBlock(LittleGridContext context) {
        return this.box.doesFillEntireBlock(context);
    }

    public void fillFace(LittleBoxFace face, LittleGridContext context) {
        LittleBox box = this.box;
        if (face.context != context) {
            box = box.copy();
            box.convertTo(context, face.context);
        }
        box.fill(face);
    }

    public boolean fillInSpace(boolean[][][] filled) {
        if (!this.box.isSolid()) {
            return false;
        }
        boolean changed = false;
        for (int x = this.box.minX; x < this.box.maxX; ++x) {
            for (int y = this.box.minY; y < this.box.maxY; ++y) {
                for (int z = this.box.minZ; z < this.box.maxZ; ++z) {
                    filled[x][y][z] = true;
                    changed = true;
                }
            }
        }
        return changed;
    }

    public boolean fillInSpaceInaccurate(LittleBox otherBox, boolean[][][] filled) {
        return this.box.fillInSpaceInaccurate(otherBox, filled);
    }

    @Override
    public boolean fillInSpace(LittleBox otherBox, boolean[][][] filled) {
        return this.box.fillInSpace(otherBox, filled);
    }

    public boolean intersectsWith(LittleBox box) {
        return LittleBox.intersectsWith(this.box, box);
    }

    public List<LittleBox> cutOut(LittleBox box, @Nullable LittleBoxReturnedVolume volume) {
        return this.box.cutOut(box, volume);
    }

    public List<LittleBox> cutOut(List<LittleBox> boxes, List<LittleBox> cutout, @Nullable LittleBoxReturnedVolume volume) {
        return this.box.cutOut(boxes, cutout, volume);
    }

    public void getIntersectingBox(LittleBox box, List<LittleBox> boxes) {
        if (LittleBox.intersectsWith(box, this.box)) {
            boxes.add(this.box);
        }
    }

    public LittleBox getCompleteBox() {
        return this.box;
    }

    public LittleVec getCenter() {
        return this.box.getCenter();
    }

    public RayTraceResult rayTrace(LittleGridContext context, BlockPos blockPos, Vec3d pos, Vec3d look) {
        return this.box.calculateIntercept(context, blockPos, pos, look);
    }

    public boolean equalsBox(LittleBox box) {
        return this.box.equals(box);
    }

    public boolean canBeCombined(LittleTile tile) {
        if (this.invisible != tile.invisible) {
            return false;
        }
        if (this.glowing != tile.glowing) {
            return false;
        }
        return this.block == tile.block && this.meta == tile.meta;
    }

    @Override
    public boolean canCombine(ICombinable combinable) {
        return this.canBeCombined((LittleTile)combinable) && ((LittleTile)combinable).canBeCombined(this);
    }

    public boolean doesProvideSolidFace(EnumFacing facing) {
        return !this.invisible && this.box.isFacePartiallyFilled(facing) && !this.isTranslucent() && this.block != Blocks.field_180401_cv;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canBeRenderCombined(LittleTile tile) {
        if (this.invisible != tile.invisible) {
            return false;
        }
        if (this.block == tile.block && this.meta == tile.meta && this.block != Blocks.field_180401_cv && tile.block != Blocks.field_180401_cv) {
            return true;
        }
        return this.hasSpecialBlockHandler() && this.handler.canBeRenderCombined(this, tile);
    }

    public boolean doesTouch(LittleTile tile) {
        return this.box.doesTouch(tile.box);
    }

    public NBTTagCompound startNBTGrouping() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.saveTile(nbt);
        nbt.func_82580_o("box");
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)this.box.getNBTIntArray());
        nbt.func_74782_a("boxes", (NBTBase)list);
        return nbt;
    }

    public boolean canBeNBTGrouped(LittleTile tile) {
        return tile.canBeCombined(this) && this.canBeCombined(tile);
    }

    public void groupNBTTile(NBTTagCompound nbt, LittleTile tile) {
        NBTTagList list = nbt.func_150295_c("boxes", 11);
        list.func_74742_a((NBTBase)tile.box.getNBTIntArray());
    }

    public List<NBTTagCompound> extractNBTFromGroup(NBTTagCompound nbt) {
        ArrayList<NBTTagCompound> tags = new ArrayList<NBTTagCompound>();
        NBTTagList list = nbt.func_150295_c("boxes", 11);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound copy = nbt.func_74737_b();
            NBTTagList small = new NBTTagList();
            small.func_74742_a(list.func_179238_g(i));
            copy.func_74782_a("boxes", (NBTBase)small);
            tags.add(copy);
        }
        return tags;
    }

    public void saveTile(NBTTagCompound nbt) {
        this.saveTileCore(nbt);
        this.saveTileExtra(nbt);
    }

    public void saveTileExtra(NBTTagCompound nbt) {
        if (this.invisible) {
            nbt.func_74757_a("invisible", this.invisible);
        }
        if (this.glowing) {
            nbt.func_74757_a("glowing", this.glowing);
        }
        nbt.func_74778_a("block", this.handler instanceof MissingBlockHandler ? ((MissingBlockHandler)this.handler).blockname : ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.block)).toString() + (this.meta != 0 ? ":" + this.meta : ""));
    }

    public void saveTileCore(NBTTagCompound nbt) {
        LittleTileType type = this.getType();
        if (type.saveId) {
            nbt.func_74778_a("tID", type.id);
        }
        nbt.func_74783_a("box", this.box.getArray());
    }

    public void loadTile(NBTTagCompound nbt) {
        this.loadTileCore(nbt);
        this.loadTileExtra(nbt);
    }

    public void loadTileExtra(NBTTagCompound nbt) {
        this.invisible = nbt.func_74767_n("invisible");
        this.glowing = nbt.func_74767_n("glowing");
        if (nbt.func_74764_b("meta")) {
            this.setBlock(nbt.func_74779_i("block"), Block.func_149684_b((String)nbt.func_74779_i("block")), nbt.func_74762_e("meta"));
        } else {
            String[] parts = nbt.func_74779_i("block").split(":");
            if (parts.length == 3) {
                this.setBlock(nbt.func_74779_i("block"), Block.func_149684_b((String)(parts[0] + ":" + parts[1])), Integer.parseInt(parts[2]));
            } else {
                this.setBlock(nbt.func_74779_i("block"), Block.func_149684_b((String)(parts[0] + ":" + parts[1])), 0);
            }
        }
    }

    public void loadTileCore(NBTTagCompound nbt) {
        if (nbt.func_74764_b("bSize")) {
            int count = nbt.func_74762_e("bSize");
            this.box = LittleBox.loadBox("bBox0", nbt);
        } else if (nbt.func_74764_b("boxes")) {
            NBTTagList list = nbt.func_150295_c("boxes", 11);
            this.box = LittleBox.createBox(list.func_150306_c(0));
        } else if (nbt.func_74764_b("box")) {
            this.box = LittleBox.createBox(nbt.func_74759_k("box"));
        }
    }

    @Override
    public LittleTile copy() {
        LittleTile tile = null;
        try {
            tile = (LittleTile)this.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            System.out.println("Invalid LittleTile class=" + this.getClass().getName());
            tile = null;
        }
        if (tile != null) {
            this.copyCore(tile);
            this.copyExtra(tile);
        }
        return tile;
    }

    public void assignTo(LittleTile target) {
        this.copyCore(target);
        this.copyExtra(target);
    }

    public void copyExtra(LittleTile tile) {
        tile.invisible = this.invisible;
        tile.glowing = this.glowing;
        tile.handler = this.handler;
        tile.block = this.block;
        tile.meta = this.meta;
    }

    public void copyCore(LittleTile tile) {
        tile.box = this.box != null ? this.box.copy() : null;
    }

    public ItemStack getDrop(LittleGridContext context) {
        return this.getDropInternal(context);
    }

    protected ItemStack getDropInternal(LittleGridContext context) {
        return ItemBlockTiles.getStackFromPreview(context, this.getPreviewTile());
    }

    public LittlePreview getPreviewTile() {
        LittlePreview preview;
        if (this.hasSpecialBlockHandler() && (preview = this.handler.getPreview(this)) != null) {
            return preview;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        this.saveTileExtra(nbt);
        LittleTileType type = this.getType();
        if (type.saveId) {
            nbt.func_74778_a("tID", type.id);
        }
        return new LittlePreview(this.box.copy(), nbt);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldBeRenderedInLayer(BlockRenderLayer layer) {
        if (FMLClientHandler.instance().hasOptifine() && this.block.canRenderInLayer(this.state, BlockRenderLayer.CUTOUT)) {
            return layer == BlockRenderLayer.CUTOUT_MIPPED;
        }
        try {
            return this.block.canRenderInLayer(this.getBlockState(), layer);
        }
        catch (Exception e) {
            try {
                return this.block.func_180664_k() == layer;
            }
            catch (Exception e2) {
                return layer == BlockRenderLayer.SOLID;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final LittleRenderBox getRenderingCube(LittleGridContext context, BlockRenderLayer layer) {
        if (this.invisible) {
            return null;
        }
        return this.getInternalRenderingCube(context, layer);
    }

    @SideOnly(value=Side.CLIENT)
    protected LittleRenderBox getInternalRenderingCube(LittleGridContext context, BlockRenderLayer layer) {
        if (this.block != Blocks.field_180401_cv) {
            return this.box.getRenderingCube(context, this.block, this.meta);
        }
        return null;
    }

    public SoundType getSound() {
        return this.block.func_185467_w();
    }

    public boolean canSawResizeTile(EnumFacing facing, EntityPlayer player) {
        return true;
    }

    public boolean canBeMoved(EnumFacing facing) {
        return true;
    }

    public float getExplosionResistance() {
        return this.block.func_149638_a(null);
    }

    public void onTileExplodes(IParentTileList parent, Explosion explosion) {
        if (this.hasSpecialBlockHandler()) {
            this.handler.onTileExplodes(parent, this, explosion);
        }
    }

    public void randomDisplayTick(IParentTileList parent, Random rand) {
        if (this.hasSpecialBlockHandler()) {
            this.handler.randomDisplayTick(parent, this, rand);
        } else {
            this.block.func_180655_c(this.getBlockState(), parent.getWorld(), parent.getPos(), rand);
        }
        if (this.block == Blocks.field_180401_cv) {
            this.spawnBarrierParticles(parent.getPos());
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnBarrierParticles(BlockPos pos) {
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack itemstack = mc.field_71439_g.func_184614_ca();
        if (mc.field_71442_b.func_178889_l() == GameType.CREATIVE && !itemstack.func_190926_b() && itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_180401_cv)) {
            mc.field_71441_e.func_175688_a(EnumParticleTypes.BARRIER, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public boolean onBlockActivated(IParentTileList parent, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) throws LittleActionException {
        if (this.hasSpecialBlockHandler()) {
            return this.handler.onBlockActivated(parent, this, playerIn, hand, heldItem, side, hitX, hitY, hitZ);
        }
        return this.block.func_180639_a(parent.getWorld(), parent.getPos(), this.getBlockState(), playerIn, hand, side, hitX, hitY, hitZ);
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        if (this.glowing) {
            return this.glowing ? 14 : 0;
        }
        return this.block.func_149750_m(this.getBlockState());
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        return this.block.getEnchantPowerBonus(world, pos);
    }

    public float getSlipperiness(IBlockAccess world, BlockPos pos, Entity entity) {
        return this.block.getSlipperiness(this.getBlockState(), world, pos, entity);
    }

    public boolean isMaterial(Material material) {
        if (this.hasSpecialBlockHandler()) {
            return this.handler.isMaterial(this, material);
        }
        return material == this.block.func_149688_o(this.state);
    }

    public boolean isLiquid() {
        if (this.hasSpecialBlockHandler()) {
            return this.handler.isLiquid(this);
        }
        return this.getBlockState().func_185904_a().func_76224_d();
    }

    public Vec3d getFogColor(IParentTileList parent, Entity entity, Vec3d originalColor, float partialTicks) {
        if (this.hasSpecialBlockHandler()) {
            return this.handler.getFogColor(parent, this, entity, originalColor, partialTicks);
        }
        return originalColor;
    }

    public Vec3d modifyAcceleration(IParentTileList parent, Entity entityIn, Vec3d motion) {
        if (this.hasSpecialBlockHandler()) {
            return this.handler.modifyAcceleration(parent, this, entityIn, motion);
        }
        return null;
    }

    public boolean shouldCheckForCollision() {
        return true;
    }

    public void onEntityCollidedWithBlock(IParentTileList parent, Entity entityIn) {
        if (this.hasSpecialBlockHandler()) {
            this.handler.onEntityCollidedWithBlock(parent, this, entityIn);
        }
    }

    public boolean hasNoCollision() {
        if (this.hasSpecialBlockHandler()) {
            return this.handler.canWalkThrough(this);
        }
        return false;
    }

    public LittleBox getCollisionBox() {
        if (this.hasSpecialBlockHandler()) {
            return this.handler.getCollisionBox(this, this.box);
        }
        return this.box;
    }

    public static class MissingBlockHandler
    implements ISpecialBlockHandler {
        private static HashMap<String, MissingBlockHandler> handlers = new HashMap();
        public final String blockname;

        public static MissingBlockHandler getHandler(String blockname) {
            MissingBlockHandler handler = handlers.get(blockname);
            if (handler != null) {
                return handler;
            }
            handler = new MissingBlockHandler(blockname);
            handlers.put(blockname, handler);
            return handler;
        }

        private MissingBlockHandler(String blockname) {
            this.blockname = blockname;
        }

        public static void unload() {
            handlers.clear();
        }
    }

    @Deprecated
    public static class LittleTilePosition {
        public BlockPos coord;
        public LittleVec position;

        public LittleTilePosition(BlockPos coord, LittleVec position) {
            this.coord = coord;
            this.position = position;
        }

        public LittleTilePosition(String id, NBTTagCompound nbt) {
            this.coord = new BlockPos(nbt.func_74762_e(id + "coX"), nbt.func_74762_e(id + "coY"), nbt.func_74762_e(id + "coZ"));
            this.position = new LittleVec(id + "po", nbt);
        }

        public LittleTilePosition(NBTTagCompound nbt) {
            this("", nbt);
        }

        public void writeToNBT(String id, NBTTagCompound nbt) {
            nbt.func_74768_a(id + "coX", this.coord.func_177958_n());
            nbt.func_74768_a(id + "coY", this.coord.func_177956_o());
            nbt.func_74768_a(id + "coZ", this.coord.func_177952_p());
            this.position.writeToNBT(id + "po", nbt);
        }

        public void writeToNBT(NBTTagCompound nbt) {
            this.writeToNBT("", nbt);
        }

        public String toString() {
            return "coord:" + this.coord + "|position:" + this.position;
        }

        public LittleTilePosition copy() {
            return new LittleTilePosition(new BlockPos((Vec3i)this.coord), this.position.copy());
        }
    }
}

