/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.type.premade.signal;

import com.creativemd.creativecore.client.rendering.RenderBox;
import com.creativemd.creativecore.common.utils.math.BooleanUtils;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.box.AlignedBox;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.render.tile.LittleRenderBox;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.directional.StructureDirectional;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.signal.component.ISignalStructureComponent;
import com.creativemd.littletiles.common.structure.signal.component.SignalComponentType;
import com.creativemd.littletiles.common.structure.type.premade.signal.LittleSignalCableBase;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tile.place.PlacePreview;
import com.creativemd.littletiles.common.tile.place.PlacePreviewFacing;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.vec.SurroundingBox;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleSignalInput
extends LittleSignalCableBase
implements ISignalStructureComponent {
    private final boolean[] state = new boolean[this.getBandwidth()];
    @StructureDirectional
    public EnumFacing facing;

    public LittleSignalInput(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    @Override
    public boolean canConnect(EnumFacing facing) {
        return facing == this.facing;
    }

    @Override
    public boolean[] getState() {
        return this.state;
    }

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        super.loadFromNBTExtra(nbt);
        BooleanUtils.intToBool((int)nbt.func_74762_e("state"), (boolean[])this.state);
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        super.writeToNBTExtra(nbt);
        nbt.func_74768_a("state", BooleanUtils.boolToInt((boolean[])this.state));
    }

    @Override
    public SignalComponentType getType() {
        return SignalComponentType.INPUT;
    }

    @Override
    public void changed() {
        try {
            if (this.getParent() != null) {
                this.getParent().getStructure().changed(this);
            }
        }
        catch (CorruptedConnectionException | NotYetConnectedException structureException) {
            // empty catch block
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderFace(EnumFacing facing, LittleGridContext context, LittleBox renderBox, int distance, EnumFacing.Axis axis, EnumFacing.Axis one, EnumFacing.Axis two, boolean positive, boolean oneSidedRenderer, List<LittleRenderBox> cubes) {
        super.renderFace(facing, context, renderBox.copy(), distance, axis, one, two, positive, oneSidedRenderer, cubes);
        LittleRenderBox cube = renderBox.getRenderingCube(context, LittleTiles.inputArrow, facing.ordinal());
        cube.keepVU = true;
        cube.allowOverlap = true;
        if (positive) {
            cube.setMin(axis, cube.getMax(axis));
            cube.setMax(axis, cube.getMax(axis) + (float)context.toVanillaGrid(renderBox.getSize(axis)) * 0.7f);
        } else {
            cube.setMax(axis, cube.getMin(axis));
            cube.setMin(axis, cube.getMin(axis) - (float)context.toVanillaGrid(renderBox.getSize(axis)) * 0.7f);
        }
        float shrink = 0.14f;
        float shrinkOne = cube.getSize(one) * shrink;
        float shrinkTwo = cube.getSize(two) * shrink;
        cube.setMin(one, cube.getMin(one) + shrinkOne);
        cube.setMax(one, cube.getMax(one) - shrinkOne);
        cube.setMin(two, cube.getMin(two) + shrinkTwo);
        cube.setMax(two, cube.getMax(two) - shrinkTwo);
        cubes.add(cube);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(SurroundingBox box, LittleBox overallBox, List<LittleRenderBox> cubes) {
        super.render(box, overallBox, cubes);
        AlignedBox cube = new AlignedBox(overallBox.getBox(box.getContext()));
        EnumFacing.Axis axis = this.facing.func_176740_k();
        float sizePercentage = 0.25f;
        EnumFacing.Axis one = RotationUtils.getOne((EnumFacing.Axis)axis);
        EnumFacing.Axis two = RotationUtils.getTwo((EnumFacing.Axis)axis);
        float sizeOne = cube.getSize(one);
        float sizeTwo = cube.getSize(two);
        float sizeAxis = cube.getSize(axis);
        LittleRenderBox top = new LittleRenderBox(cube, null, LittleTiles.dyeableBlock, 0).setColor(this.color);
        top.allowOverlap = true;
        top.setMin(one, top.getMax(one) - sizeOne * sizePercentage);
        cubes.add(top);
        LittleRenderBox bottom = new LittleRenderBox(cube, null, LittleTiles.dyeableBlock, 0).setColor(this.color);
        bottom.allowOverlap = true;
        bottom.setMax(one, bottom.getMin(one) + sizeOne * sizePercentage);
        cubes.add(bottom);
        LittleRenderBox left = new LittleRenderBox(cube, null, LittleTiles.dyeableBlock, 0).setColor(this.color);
        left.allowOverlap = true;
        left.setMin(two, top.getMax(two) - sizeTwo * sizePercentage);
        cubes.add(left);
        LittleRenderBox right = new LittleRenderBox(cube, null, LittleTiles.dyeableBlock, 0).setColor(this.color);
        right.allowOverlap = true;
        right.setMax(two, right.getMin(two) + sizeTwo * sizePercentage);
        cubes.add(right);
        LittleRenderBox behind = new LittleRenderBox(cube, null, LittleTiles.dyeableBlock, 0).setColor(this.color);
        behind.allowOverlap = true;
        float depth = sizeAxis * 0.12f;
        behind.setMin(one, behind.getMin(one) + sizeOne * sizePercentage);
        behind.setMax(one, behind.getMax(one) - sizeOne * sizePercentage);
        behind.setMin(two, behind.getMin(two) + sizeTwo * sizePercentage);
        behind.setMax(two, behind.getMax(two) - sizeTwo * sizePercentage);
        if (this.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            behind.setMax(axis, behind.getMin(axis) + sizeAxis * 0.5f);
        } else {
            behind.setMin(axis, behind.getMax(axis) - sizeAxis * 0.5f);
        }
        cubes.add(behind);
        LittleRenderBox front = new LittleRenderBox(cube, null, LittleTiles.dyeableBlock, 0).setColor(-16740609);
        front.allowOverlap = true;
        front.setMin(one, front.getMin(one) + sizeOne * sizePercentage);
        front.setMax(one, front.getMax(one) - sizeOne * sizePercentage);
        front.setMin(two, front.getMin(two) + sizeTwo * sizePercentage);
        front.setMax(two, front.getMax(two) - sizeTwo * sizePercentage);
        if (this.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            front.setMin(axis, front.getMax(axis) - sizeAxis * 0.5f);
            front.setMax(axis, front.getMax(axis) - depth);
        } else {
            front.setMax(axis, front.getMin(axis) + sizeAxis * 0.5f);
            front.setMin(axis, front.getMin(axis) + depth);
        }
        cubes.add(front);
        float thickness = 1.0E-4f;
        LittleRenderBox frontTop = new LittleRenderBox(cube, null, LittleTiles.dyeableBlock, 0).setColor(-16740609);
        frontTop.allowOverlap = true;
        frontTop.setMin(one, frontTop.getMin(one) + sizeOne * sizePercentage);
        frontTop.setMax(one, frontTop.getMin(one) + thickness);
        frontTop.setMin(two, frontTop.getMin(two) + sizeTwo * sizePercentage);
        frontTop.setMax(two, frontTop.getMax(two) - sizeTwo * sizePercentage);
        if (this.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            frontTop.setMin(axis, frontTop.getMax(axis) - sizeAxis * sizePercentage);
        } else {
            frontTop.setMax(axis, frontTop.getMin(axis) + sizeAxis * sizePercentage);
        }
        cubes.add(frontTop);
        LittleRenderBox frontBottom = new LittleRenderBox(cube, null, LittleTiles.dyeableBlock, 0).setColor(-16740609);
        frontBottom.allowOverlap = true;
        frontBottom.setMax(one, frontBottom.getMax(one) - sizeOne * sizePercentage);
        frontBottom.setMin(one, frontBottom.getMax(one) - thickness);
        frontBottom.setMin(two, frontBottom.getMin(two) + sizeTwo * sizePercentage);
        frontBottom.setMax(two, frontBottom.getMax(two) - sizeTwo * sizePercentage);
        if (this.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            frontBottom.setMin(axis, frontBottom.getMax(axis) - sizeAxis * sizePercentage);
        } else {
            frontBottom.setMax(axis, frontBottom.getMin(axis) + sizeAxis * sizePercentage);
        }
        cubes.add(frontBottom);
        LittleRenderBox frontRight = new LittleRenderBox(cube, null, LittleTiles.dyeableBlock, 0).setColor(-16740609);
        frontRight.allowOverlap = true;
        frontRight.setMin(one, frontRight.getMin(one) + sizeOne * sizePercentage);
        frontRight.setMax(one, frontRight.getMax(one) - sizeOne * sizePercentage);
        frontRight.setMin(two, frontRight.getMin(two) + sizeTwo * sizePercentage);
        frontRight.setMax(two, frontRight.getMin(two) + thickness);
        if (this.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            frontRight.setMin(axis, frontRight.getMax(axis) - sizeAxis * sizePercentage);
        } else {
            frontRight.setMax(axis, frontRight.getMin(axis) + sizeAxis * sizePercentage);
        }
        cubes.add(frontRight);
        LittleRenderBox frontLeft = new LittleRenderBox(cube, null, LittleTiles.dyeableBlock, 0).setColor(-16740609);
        frontLeft.allowOverlap = true;
        frontLeft.setMin(one, frontLeft.getMin(one) + sizeOne * sizePercentage);
        frontLeft.setMax(one, frontLeft.getMax(one) - sizeOne * sizePercentage);
        frontLeft.setMax(two, frontLeft.getMax(two) - sizeTwo * sizePercentage);
        frontLeft.setMin(two, frontLeft.getMax(two) - thickness);
        if (this.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            frontLeft.setMin(axis, frontLeft.getMax(axis) - sizeAxis * sizePercentage);
        } else {
            frontLeft.setMax(axis, frontLeft.getMin(axis) + sizeAxis * sizePercentage);
        }
        cubes.add(frontLeft);
    }

    @Override
    public int getIndex(EnumFacing facing) {
        return 0;
    }

    @Override
    public EnumFacing getFacing(int index) {
        return this.facing;
    }

    @Override
    public int getId() {
        return this.getParent().childId;
    }

    @Override
    public LittleStructure getStructure() {
        try {
            return this.getParent().getStructure();
        }
        catch (CorruptedConnectionException | NotYetConnectedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String info() {
        if (this.getParent() != null) {
            return "i" + this.getId() + ":" + BooleanUtils.print((boolean[])this.getState());
        }
        return "";
    }

    public static class LittleStructureTypeInput
    extends LittleSignalCableBase.LittleStructureTypeNetwork {
        public LittleStructureTypeInput(String id, String category, Class<? extends LittleStructure> structureClass, int attribute, String modid, int bandwidth) {
            super(id, category, structureClass, attribute, modid, bandwidth, 1);
        }

        @Override
        public List<PlacePreview> getSpecialTiles(LittlePreviews previews) {
            List<PlacePreview> result = super.getSpecialTiles(previews);
            EnumFacing facing = (EnumFacing)this.loadDirectional(previews, "facing");
            LittleBox box = previews.getSurroundingBox();
            result.add(new PlacePreviewFacing(box, facing, -16740609));
            return result;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public List<RenderBox> getRenderingCubes(LittlePreviews previews) {
            ArrayList<RenderBox> cubes = new ArrayList<RenderBox>();
            float size = (float)((Math.sqrt(this.bandwidth) * 1.0 / 32.0 + 0.05) * 1.4);
            cubes = new ArrayList();
            cubes.add(new RenderBox(0.0f, 0.5f - size, 0.5f - size, size * 2.0f, 0.5f + size, 0.5f + size, (Block)LittleTiles.dyeableBlock).setColor(this.getColor(previews)));
            cubes.add(new RenderBox(size * 2.0f, 0.5f - size, 0.5f - size, size * 2.5f, 0.5f + size, 0.5f + size, (Block)LittleTiles.dyeableBlock).setColor(-16740609));
            return cubes;
        }

        @Override
        public int getBandwidth() {
            return this.bandwidth;
        }

        @Override
        public void changed() {
        }

        @Override
        public boolean[] getState() {
            return null;
        }

        @Override
        public SignalComponentType getType() {
            return SignalComponentType.INPUT;
        }
    }
}

