/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.type.door;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiIconButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiPanel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiStateButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTabStateButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlClickEvent;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.type.UUIDSupplier;
import com.creativemd.littletiles.client.gui.controls.GuiTileViewer;
import com.creativemd.littletiles.common.entity.AnimationPreview;
import com.creativemd.littletiles.common.entity.DoorController;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.animation.AnimationGuiHandler;
import com.creativemd.littletiles.common.structure.animation.AnimationKey;
import com.creativemd.littletiles.common.structure.animation.AnimationState;
import com.creativemd.littletiles.common.structure.animation.AnimationTimeline;
import com.creativemd.littletiles.common.structure.animation.ValueTimeline;
import com.creativemd.littletiles.common.structure.directional.StructureDirectional;
import com.creativemd.littletiles.common.structure.directional.StructureDirectionalField;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.relative.StructureAbsolute;
import com.creativemd.littletiles.common.structure.relative.StructureRelative;
import com.creativemd.littletiles.common.structure.type.door.LittleDoor;
import com.creativemd.littletiles.common.structure.type.door.LittleDoorBase;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleAbsoluteVec;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.math.vec.LittleVecContext;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tile.place.PlacePreview;
import com.creativemd.littletiles.common.tile.place.PlacePreviewRelativeAxis;
import com.creativemd.littletiles.common.tile.preview.LittleAbsolutePreviews;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.place.Placement;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleAxisDoor
extends LittleDoorBase {
    public AxisDoorRotation doorRotation;
    @StructureDirectional
    public EnumFacing.Axis axis;
    @StructureDirectional(color=-65536)
    public StructureRelative axisCenter;
    private static List<Class<? extends AxisDoorRotation>> rotationTypes = new ArrayList<Class<? extends AxisDoorRotation>>();
    private static List<String> rotationTypeNames = new ArrayList<String>();

    public LittleAxisDoor(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        super.loadFromNBTExtra(nbt);
        this.doorRotation = nbt.func_74764_b("ndirection") ? new DirectionRotation() : LittleAxisDoor.parseRotation(nbt);
    }

    @Override
    protected Object failedLoadingRelative(NBTTagCompound nbt, StructureDirectionalField relative) {
        if (relative.key.equals("axisCenter")) {
            LittleRelativeDoubledAxis doubledRelativeAxis;
            if (nbt.func_74764_b("ax")) {
                LittleVecContext vec = new LittleVecContext("a", nbt);
                doubledRelativeAxis = new LittleRelativeDoubledAxis(vec.getContext(), vec.getVec(), new LittleVec(1, 1, 1));
            } else if (nbt.func_74764_b("av")) {
                LittleVecContext vec = new LittleVecContext("av", nbt);
                doubledRelativeAxis = new LittleRelativeDoubledAxis(vec.getContext(), vec.getVec(), new LittleVec(1, 1, 1));
            } else {
                doubledRelativeAxis = new LittleRelativeDoubledAxis("avec", nbt);
            }
            return new StructureRelative(StructureAbsolute.convertAxisToBox(doubledRelativeAxis.getNonDoubledVec(), doubledRelativeAxis.additional), doubledRelativeAxis.getContext());
        }
        return super.failedLoadingRelative(nbt, relative);
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        super.writeToNBTExtra(nbt);
        this.doorRotation.writeToNBT(nbt);
    }

    @Override
    public StructureAbsolute getAbsoluteAxis() {
        return new StructureAbsolute(new LittleAbsoluteVec(this.getPos(), this.mainBlock.getContext()), this.axisCenter);
    }

    @Override
    public DoorController createController(UUIDSupplier supplier, Placement placement, int completeDuration) {
        return this.doorRotation.createController(supplier, this, completeDuration, this.interpolation);
    }

    @Override
    public void transformDoorPreview(LittleAbsolutePreviews previews) {
        StructureRelative axisCenter = (StructureRelative)previews.getStructureType().loadDirectional(previews, "axisCenter");
        axisCenter.forceContext(previews);
    }

    protected static AxisDoorRotation parseRotation(NBTTagCompound nbt) {
        int index = nbt.func_74762_e("rot-type");
        if (index >= 0 && index < rotationTypes.size()) {
            Class<? extends AxisDoorRotation> rotationType = rotationTypes.get(index);
            try {
                AxisDoorRotation rotation = rotationType.getConstructor(new Class[0]).newInstance(new Object[0]);
                rotation.readFromNBT(nbt);
                return rotation;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return new DirectionRotation();
    }

    protected static AxisDoorRotation createRotation(int index) {
        if (index >= 0 && index < rotationTypes.size()) {
            Class<? extends AxisDoorRotation> rotationType = rotationTypes.get(index);
            try {
                return rotationType.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        throw new RuntimeException("Invalid axis door rotation found index: " + index);
    }

    static {
        rotationTypes.add(DirectionRotation.class);
        rotationTypeNames.add("direction");
        rotationTypes.add(FixedRotation.class);
        rotationTypeNames.add("fixed");
    }

    public static class LittleAxisDoorType
    extends LittleDoor.LittleDoorType {
        public LittleAxisDoorType(String id, String category, Class<? extends LittleStructure> structureClass, int attribute) {
            super(id, category, structureClass, attribute);
        }

        @Override
        protected PlacePreview getPlacePreview(Object value, StructureDirectionalField type, LittlePreviews previews) {
            if (type.key.equals("axisCenter")) {
                return new PlacePreviewRelativeAxis(((StructureRelative)value).getBox(), (StructureRelative)value, type, EnumFacing.Axis.values()[previews.structureNBT.func_74762_e("axis")]);
            }
            return super.getPlacePreview(value, type, previews);
        }

        @Override
        public void flip(LittlePreviews previews, LittleGridContext context, EnumFacing.Axis axis, LittleVec doubledCenter) {
            AxisDoorRotation doorRotation = LittleAxisDoor.parseRotation(previews.structureNBT);
            doorRotation.flip(EnumFacing.Axis.values()[previews.structureNBT.func_74762_e("axis")], axis);
            doorRotation.writeToNBT(previews.structureNBT);
            super.flip(previews, context, axis, doubledCenter);
        }

        @Override
        public void rotate(LittlePreviews previews, LittleGridContext context, Rotation rotation, LittleVec doubledCenter) {
            AxisDoorRotation doorRotation = LittleAxisDoor.parseRotation(previews.structureNBT);
            doorRotation.rotate(EnumFacing.Axis.values()[previews.structureNBT.func_74762_e("axis")], rotation);
            doorRotation.writeToNBT(previews.structureNBT);
            super.rotate(previews, context, rotation, doubledCenter);
        }
    }

    public static class FixedRotation
    extends AxisDoorRotation {
        public double degree;

        @Override
        protected void writeToNBTCore(NBTTagCompound nbt) {
            nbt.func_74780_a("degree", this.degree);
        }

        @Override
        protected void readFromNBT(NBTTagCompound nbt) {
            this.degree = nbt.func_74769_h("degree");
        }

        @Override
        protected void rotate(EnumFacing.Axis doorAxis, Rotation rotation) {
            this.degree = RotationUtils.rotate((Rotation)Rotation.getRotation((EnumFacing.Axis)doorAxis, (boolean)(this.degree > 0.0 ? true : false)), (Rotation)rotation).clockwise ? Math.abs(this.degree) : -Math.abs(this.degree);
        }

        @Override
        protected void flip(EnumFacing.Axis doorAxis, EnumFacing.Axis axis) {
            if (doorAxis != axis) {
                this.degree = -this.degree;
            }
        }

        @Override
        protected DoorController createController(UUIDSupplier supplier, LittleAxisDoor door, int completeDuration, int interpolation) {
            return new DoorController(supplier, new AnimationState().set(AnimationKey.getRotation(door.axis), this.degree), door.stayAnimated ? null : Boolean.valueOf(false), door.duration, completeDuration, interpolation);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected void onSelected(GuiTileViewer viewer, GuiParent parent) {
            viewer.visibleNormalAxis = false;
            if (this.degree == 0.0) {
                this.degree = 90.0;
            }
            parent.addControl((GuiControl)new GuiTextfield("degree", "" + this.degree, 0, 0, 30, 12).setFloatOnly());
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected void parseGui(GuiTileViewer viewer, GuiParent parent) {
            float degree;
            try {
                degree = Float.parseFloat(((GuiTextfield)parent.get((String)"degree")).text);
            }
            catch (NumberFormatException e) {
                degree = 0.0f;
            }
            this.degree = degree;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public boolean shouldUpdateTimeline(GuiControl control) {
            return control.is(new String[]{"degree"});
        }

        @Override
        protected boolean shouldRotatePreviews(LittleAxisDoor door) {
            return false;
        }

        @Override
        public void populateTimeline(AnimationTimeline timeline, int duration, int interpolation, AnimationKey key) {
            timeline.values.add((Object)key, (Object)ValueTimeline.create(interpolation).addPoint(0, 0.0).addPoint(duration, this.degree));
        }
    }

    public static class DirectionRotation
    extends AxisDoorRotation {
        public boolean clockwise;

        @Override
        protected void writeToNBTCore(NBTTagCompound nbt) {
            nbt.func_74757_a("clockwise", this.clockwise);
        }

        @Override
        protected void readFromNBT(NBTTagCompound nbt) {
            this.clockwise = nbt.func_74767_n("clockwise");
        }

        @Override
        protected void rotate(EnumFacing.Axis doorAxis, Rotation rotation) {
            this.clockwise = RotationUtils.rotate((Rotation)Rotation.getRotation((EnumFacing.Axis)doorAxis, (boolean)this.clockwise), (Rotation)rotation).clockwise;
        }

        @Override
        protected void flip(EnumFacing.Axis doorAxis, EnumFacing.Axis axis) {
            if (doorAxis != axis) {
                this.clockwise = !this.clockwise;
            }
        }

        protected Rotation getRotation(EntityPlayer player, LittleAxisDoor door) {
            return Rotation.getRotation((EnumFacing.Axis)door.axis, (boolean)this.clockwise);
        }

        protected Rotation getDefaultRotation(LittleAxisDoor door) {
            return Rotation.getRotation((EnumFacing.Axis)door.axis, (boolean)this.clockwise);
        }

        @Override
        protected DoorController createController(UUIDSupplier supplier, LittleAxisDoor door, int completeDuration, int interpolation) {
            Rotation rotation = this.getRotation(null, door);
            return new DoorController(supplier, new AnimationState(), new AnimationState().set(AnimationKey.getRotation(rotation.axis), rotation.clockwise ? 90.0 : -90.0), door.stayAnimated ? null : Boolean.valueOf(false), door.duration, completeDuration, interpolation);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected void onSelected(GuiTileViewer viewer, GuiParent parent) {
            parent.addControl((GuiControl)new GuiStateButton("direction", this.clockwise ? 0 : 1, 0, 0, 70, new String[]{GuiControl.translate((String)"gui.door.axis.clockwise"), GuiControl.translate((String)"gui.door.axis.counterclockwise")}));
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected void parseGui(GuiTileViewer viewer, GuiParent parent) {
            this.clockwise = ((GuiStateButton)parent.get("direction")).getState() == 0;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public boolean shouldUpdateTimeline(GuiControl control) {
            return control.is(new String[]{"direction"});
        }

        @Override
        protected boolean shouldRotatePreviews(LittleAxisDoor door) {
            return !door.stayAnimated;
        }

        @Override
        public void populateTimeline(AnimationTimeline timeline, int duration, int interpolation, AnimationKey key) {
            timeline.values.add((Object)key, (Object)ValueTimeline.create(interpolation).addPoint(0, 0.0).addPoint(duration, this.clockwise ? 90.0 : -90.0));
        }
    }

    public static abstract class AxisDoorRotation {
        protected abstract void writeToNBTCore(NBTTagCompound var1);

        public void writeToNBT(NBTTagCompound nbt) {
            nbt.func_74768_a("rot-type", rotationTypes.indexOf(this.getClass()));
            this.writeToNBTCore(nbt);
        }

        protected abstract void readFromNBT(NBTTagCompound var1);

        protected abstract void rotate(EnumFacing.Axis var1, Rotation var2);

        protected abstract void flip(EnumFacing.Axis var1, EnumFacing.Axis var2);

        protected abstract boolean shouldRotatePreviews(LittleAxisDoor var1);

        protected abstract DoorController createController(UUIDSupplier var1, LittleAxisDoor var2, int var3, int var4);

        @SideOnly(value=Side.CLIENT)
        public abstract boolean shouldUpdateTimeline(GuiControl var1);

        @SideOnly(value=Side.CLIENT)
        protected abstract void onSelected(GuiTileViewer var1, GuiParent var2);

        @SideOnly(value=Side.CLIENT)
        protected abstract void parseGui(GuiTileViewer var1, GuiParent var2);

        public abstract void populateTimeline(AnimationTimeline var1, int var2, int var3, AnimationKey var4);
    }

    public static class LittleAxisDoorParser
    extends LittleDoorBase.LittleDoorBaseParser {
        public LittleAxisDoorParser(GuiParent parent, AnimationGuiHandler handler) {
            super(parent, handler);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public LittleAxisDoor parseStructure() {
            LittleAxisDoor door = this.createStructure(LittleAxisDoor.class, null);
            GuiTileViewer viewer = (GuiTileViewer)this.parent.get("tileviewer");
            door.axisCenter = new StructureRelative(viewer.getBox(), viewer.getAxisContext());
            door.axis = viewer.getAxis();
            GuiPanel typePanel = (GuiPanel)this.parent.get("typePanel");
            door.doorRotation = LittleAxisDoor.createRotation(((GuiTabStateButton)this.parent.get("doorRotation")).getState());
            door.doorRotation.parseGui(viewer, (GuiParent)typePanel);
            return door;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void createControls(LittlePreviews previews, LittleStructure structure) {
            AxisDoorRotation doorRotation;
            LittleGridContext stackContext;
            LittleAxisDoor door = null;
            if (structure instanceof LittleAxisDoor) {
                door = (LittleAxisDoor)structure;
            }
            LittleGridContext axisContext = stackContext = previews.getContext();
            final GuiTileViewer viewer = new GuiTileViewer("tileviewer", 0, 0, 100, 100, stackContext);
            this.parent.addControl((GuiControl)viewer);
            boolean even = false;
            if (door != null) {
                even = door.axisCenter.isEven();
                viewer.setEven(even);
                door.axisCenter.convertToSmallest();
                axisContext = door.axisCenter.getContext();
                viewer.setViewAxis(door.axis);
                viewer.setAxis(door.axisCenter.getBox(), axisContext);
                doorRotation = door.doorRotation;
            } else {
                viewer.setEven(false);
                viewer.setAxis(new LittleBox(0, 0, 0, 1, 1, 1), viewer.context);
                doorRotation = new DirectionRotation();
            }
            viewer.visibleAxis = true;
            this.parent.addControl((GuiControl)new GuiTabStateButton("doorRotation", rotationTypes.indexOf(doorRotation.getClass()), 110, 0, 12, rotationTypeNames.toArray(new String[0])));
            GuiPanel typePanel = new GuiPanel("typePanel", 110, 20, 80, 25);
            this.parent.addControl((GuiControl)typePanel);
            this.parent.addControl(new GuiIconButton("reset view", 20, 107, 8){

                public void onClicked(int x, int y, int button) {
                    viewer.offsetX.set(0.0);
                    viewer.offsetY.set(0.0);
                    viewer.scale.set(40.0);
                }
            }.setCustomTooltip(new String[]{"reset view"}));
            this.parent.addControl(new GuiIconButton("change view", 40, 107, 7){

                public void onClicked(int x, int y, int button) {
                    switch (viewer.getAxis()) {
                        case X: {
                            viewer.setViewAxis(EnumFacing.Axis.Y);
                            break;
                        }
                        case Y: {
                            viewer.setViewAxis(EnumFacing.Axis.Z);
                            break;
                        }
                        case Z: {
                            viewer.setViewAxis(EnumFacing.Axis.X);
                            break;
                        }
                    }
                    this.updateTimeline();
                }
            }.setCustomTooltip(new String[]{"change view"}));
            this.parent.addControl(new GuiIconButton("flip view", 60, 107, 4){

                public void onClicked(int x, int y, int button) {
                    viewer.setViewDirection(viewer.getViewDirection().func_176734_d());
                }
            }.setCustomTooltip(new String[]{"flip view"}));
            this.parent.addControl((GuiControl)new GuiIconButton("up", 124, 58, 1){

                public void onClicked(int x, int y, int button) {
                    viewer.moveY(GuiScreen.func_146271_m() ? viewer.context.size : 1);
                }
            });
            this.parent.addControl((GuiControl)new GuiIconButton("right", 141, 75, 0){

                public void onClicked(int x, int y, int button) {
                    viewer.moveX(GuiScreen.func_146271_m() ? viewer.context.size : 1);
                }
            });
            this.parent.addControl((GuiControl)new GuiIconButton("left", 107, 75, 2){

                public void onClicked(int x, int y, int button) {
                    viewer.moveX(-(GuiScreen.func_146271_m() ? viewer.context.size : 1));
                }
            });
            this.parent.addControl((GuiControl)new GuiIconButton("down", 124, 75, 3){

                public void onClicked(int x, int y, int button) {
                    viewer.moveY(-(GuiScreen.func_146271_m() ? viewer.context.size : 1));
                }
            });
            this.parent.controls.add(new GuiCheckBox("even", 147, 55, even));
            GuiStateButton contextBox = new GuiStateButton("grid", LittleGridContext.getNames().indexOf(axisContext + ""), 170, 75, 20, 12, LittleGridContext.getNames().toArray(new String[0]));
            this.parent.controls.add(contextBox);
            doorRotation.onSelected(viewer, (GuiParent)typePanel);
            super.createControls(previews, structure);
        }

        @CustomEventSubscribe
        @SideOnly(value=Side.CLIENT)
        public void onAxisChanged(GuiTileViewer.GuiTileViewerAxisChangedEvent event) {
            GuiTileViewer viewer = (GuiTileViewer)event.source;
            this.handler.setCenter(new StructureAbsolute(new BlockPos(0, 75, 0), viewer.getBox().copy(), viewer.getAxisContext()));
        }

        @Override
        @CustomEventSubscribe
        @SideOnly(value=Side.CLIENT)
        public void onChanged(GuiControlChangedEvent event) {
            super.onChanged(event);
            AxisDoorRotation rotation = LittleAxisDoor.createRotation(((GuiTabStateButton)this.parent.get("doorRotation")).getState());
            if (rotation.shouldUpdateTimeline((GuiControl)event.source)) {
                this.updateTimeline();
            } else if (event.source.is(new String[]{"doorRotation"})) {
                GuiPanel typePanel = (GuiPanel)this.parent.get("typePanel");
                typePanel.controls.clear();
                rotation.onSelected((GuiTileViewer)this.parent.get("tileviewer"), (GuiParent)typePanel);
                this.updateTimeline();
            } else if (event.source.is(new String[]{"grid"})) {
                LittleGridContext context;
                GuiStateButton contextBox = (GuiStateButton)event.source;
                try {
                    context = LittleGridContext.get(Integer.parseInt(contextBox.getCaption()));
                }
                catch (NumberFormatException e) {
                    context = LittleGridContext.get();
                }
                GuiTileViewer viewer = (GuiTileViewer)event.source.parent.get("tileviewer");
                LittleBox box = viewer.getBox();
                box.convertTo(viewer.getAxisContext(), context);
                box.maxX = viewer.isEven() ? box.minX + 2 : box.minX + 1;
                box.maxY = viewer.isEven() ? box.minY + 2 : box.minY + 1;
                box.maxZ = viewer.isEven() ? box.minZ + 2 : box.minZ + 1;
                viewer.setAxis(box, context);
            }
        }

        @CustomEventSubscribe
        @SideOnly(value=Side.CLIENT)
        public void onButtonClicked(GuiControlClickEvent event) {
            GuiTileViewer viewer = (GuiTileViewer)event.source.parent.get("tileviewer");
            if (event.source.is(new String[]{"even"})) {
                viewer.setEven(((GuiCheckBox)event.source).value);
            }
        }

        @Override
        public void populateTimeline(AnimationTimeline timeline, int interpolation) {
            GuiTileViewer viewer = (GuiTileViewer)this.parent.get("tileviewer");
            GuiPanel typePanel = (GuiPanel)this.parent.get("typePanel");
            AxisDoorRotation doorRotation = LittleAxisDoor.createRotation(((GuiTabStateButton)this.parent.get("doorRotation")).getState());
            doorRotation.parseGui(viewer, (GuiParent)typePanel);
            doorRotation.populateTimeline(timeline, timeline.duration, interpolation, AnimationKey.getRotation(viewer.getAxis()));
        }

        @Override
        public void onLoaded(AnimationPreview animationPreview) {
            super.onLoaded(animationPreview);
            GuiTileViewer viewer = (GuiTileViewer)this.parent.get("tileviewer");
            this.onAxisChanged(new GuiTileViewer.GuiTileViewerAxisChangedEvent((GuiControl)viewer));
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected LittleStructureType getStructureType() {
            return LittleStructureRegistry.getStructureType(LittleAxisDoor.class);
        }
    }

    @Deprecated
    public static class LittleRelativeDoubledAxis
    extends LittleVecContext {
        public LittleVec additional;

        public LittleRelativeDoubledAxis(LittleGridContext context, LittleVec vec, LittleVec additional) {
            super(vec, context);
            this.additional = additional;
        }

        public LittleRelativeDoubledAxis(String name, NBTTagCompound nbt) {
            int[] array = nbt.func_74759_k(name);
            if (array.length == 3) {
                this.vec = new LittleVec(array[0], array[1], array[2]);
                this.context = LittleGridContext.get();
                this.additional = new LittleVec(this.vec.x % 2, this.vec.y % 2, this.vec.z % 2);
                this.vec.x /= 2;
                this.vec.y /= 2;
                this.vec.z /= 2;
            } else if (array.length == 4) {
                this.vec = new LittleVec(array[0], array[1], array[2]);
                this.context = LittleGridContext.get(array[3]);
                this.additional = new LittleVec(this.vec.x % 2, this.vec.y % 2, this.vec.z % 2);
                this.vec.x /= 2;
                this.vec.y /= 2;
                this.vec.z /= 2;
            } else if (array.length == 7) {
                this.vec = new LittleVec(array[0], array[1], array[2]);
                this.context = LittleGridContext.get(array[3]);
                this.additional = new LittleVec(array[4], array[5], array[6]);
            } else {
                throw new InvalidParameterException("No valid coords given " + nbt);
            }
        }

        public LittleVecContext getNonDoubledVec() {
            return new LittleVecContext(this.vec.copy(), this.context);
        }

        public LittleVec getRotationVec() {
            LittleVec vec = this.vec.copy();
            vec.scale(2);
            vec.add(this.additional);
            return vec;
        }

        @Override
        public LittleRelativeDoubledAxis copy() {
            return new LittleRelativeDoubledAxis(this.context, this.vec.copy(), this.additional.copy());
        }

        @Override
        public void convertTo(LittleGridContext to) {
            LittleVec newVec = this.getRotationVec();
            newVec.convertTo(this.context, to);
            super.convertTo(to);
            this.additional = new LittleVec(newVec.x % 2, newVec.y % 2, newVec.z % 2);
            this.vec = newVec;
            this.vec.x /= 2;
            this.vec.y /= 2;
            this.vec.z /= 2;
        }

        @Override
        public void convertToSmallest() {
            if (this.isEven()) {
                super.convertToSmallest();
            }
        }

        @Override
        public int getSmallestContext() {
            if (this.isEven()) {
                return this.vec.getSmallestContext(this.context);
            }
            return this.context.size;
        }

        @Override
        public boolean equals(Object paramObject) {
            if (paramObject instanceof LittleRelativeDoubledAxis) {
                return super.equals(paramObject) && this.additional.equals(((LittleRelativeDoubledAxis)paramObject).additional);
            }
            return false;
        }

        public boolean isEven() {
            return this.additional.x % 2 == 0;
        }

        @Override
        public void writeToNBT(String name, NBTTagCompound nbt) {
            nbt.func_74783_a(name, new int[]{this.vec.x, this.vec.y, this.vec.z, this.context.size, this.additional.x, this.additional.y, this.additional.z});
        }

        @Override
        public String toString() {
            return "[" + this.vec.x + "," + this.vec.y + "," + this.vec.z + ",grid:" + this.context.size + ",additional:" + this.additional + "]";
        }
    }
}

