/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tile.math.location.StructureLocation;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class LittleUpdateStructurePacket
extends CreativeCorePacket {
    public StructureLocation location;
    public NBTTagCompound structureNBT;

    public LittleUpdateStructurePacket() {
    }

    public LittleUpdateStructurePacket(StructureLocation location, NBTTagCompound structureNBT) {
        this.location = location;
        this.structureNBT = structureNBT;
    }

    public void writeBytes(ByteBuf buf) {
        LittleAction.writeStructureLocation(this.location, buf);
        LittleUpdateStructurePacket.writeNBT((ByteBuf)buf, (NBTTagCompound)this.structureNBT);
    }

    public void readBytes(ByteBuf buf) {
        this.location = LittleAction.readStructureLocation(buf);
        this.structureNBT = LittleUpdateStructurePacket.readNBT((ByteBuf)buf);
    }

    public void executeClient(EntityPlayer player) {
        try {
            LittleStructure structure = this.location.find(player.field_70170_p);
            structure.mainBlock.getTe().updateTiles(x -> x.get(structure.mainBlock).setStructureNBT(this.structureNBT));
        }
        catch (LittleActionException littleActionException) {
            // empty catch block
        }
    }

    public void executeServer(EntityPlayer player) {
        try {
            LittleStructure structure = this.location.find(player.field_70170_p);
            NBTTagCompound nbt = new NBTTagCompound();
            structure.writeToNBT(nbt);
            PacketHandler.sendPacketToPlayer((CreativeCorePacket)new LittleUpdateStructurePacket(this.location, nbt), (EntityPlayerMP)((EntityPlayerMP)player));
        }
        catch (LittleActionException littleActionException) {
            // empty catch block
        }
    }
}

