/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.container;

import com.creativemd.creativecore.common.gui.container.SubContainer;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.item.ItemLittleRecipeAdvanced;
import com.creativemd.littletiles.common.structure.type.premade.LittleStructureBuilder;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SubContainerBuilder
extends SubContainer {
    public LittleStructureBuilder builder;

    public SubContainerBuilder(EntityPlayer player, LittleStructureBuilder builder) {
        super(player);
        this.builder = builder;
    }

    public void createControls() {
        this.addSlotToContainer(new Slot((IInventory)this.builder.inventory, 0, 152, 61));
        this.addPlayerSlotsToContainer(this.player);
    }

    public void onPacketReceive(NBTTagCompound nbt) {
        if (this.player.func_184812_l_() && this.builder.inventory.func_70301_a(0).func_190926_b() || ItemLittleRecipeAdvanced.isRecipe(this.builder.inventory.func_70301_a(0).func_77973_b())) {
            int width = nbt.func_74762_e("width");
            int height = nbt.func_74762_e("height");
            int thickness = nbt.func_74762_e("thickness");
            String[] parts = nbt.func_74779_i("block").split(":");
            Block block = Block.func_149684_b((String)(parts[0] + ":" + parts[1]));
            int meta = parts.length == 3 ? Integer.parseInt(parts[2]) : 0;
            IBlockState state = block.func_176203_a(meta);
            LittleGridContext grid = LittleGridContext.get(nbt.func_74762_e("grid"));
            this.builder.lastBlockState = state;
            this.builder.lastSizeX = width;
            this.builder.lastSizeY = height;
            this.builder.lastThickness = thickness;
            this.builder.lastGrid = grid.size;
            this.builder.lastStructureType = nbt.func_74779_i("type");
            this.builder.updateStructure();
            LittleStructureBuilder.LittleStructureBuilderType type = LittleStructureBuilder.get(this.builder.lastStructureType);
            if (type != null) {
                ItemStack stack = this.builder.inventory.func_70301_a(0);
                if (stack.func_190926_b()) {
                    stack = new ItemStack(LittleTiles.recipeAdvanced);
                    this.builder.inventory.func_70299_a(0, stack);
                }
                NBTTagCompound tileData = new NBTTagCompound();
                tileData.func_74778_a("block", nbt.func_74779_i("block"));
                LittlePreview.savePreview(type.construct(grid, width, height, thickness, tileData), stack);
            }
        }
    }
}

