/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.gui.signal;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.utils.mc.ChatFormatting;
import com.creativemd.littletiles.client.gui.signal.GuiSignalController;
import com.creativemd.littletiles.client.gui.signal.SubGuiDialogSignalMode;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.signal.component.ISignalComponent;
import com.creativemd.littletiles.common.structure.signal.component.SignalComponentType;
import com.creativemd.littletiles.common.structure.signal.input.SignalInputCondition;
import com.creativemd.littletiles.common.structure.signal.logic.SignalLogicOperator;
import com.creativemd.littletiles.common.structure.signal.logic.SignalMode;
import com.creativemd.littletiles.common.structure.signal.logic.SignalTarget;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class SubGuiDialogSignal
extends SubGui {
    public final List<GuiSignalComponent> inputs;
    protected final IConditionConfiguration event;

    public SubGuiDialogSignal(List<GuiSignalComponent> inputs, IConditionConfiguration event) {
        super(300, 200);
        this.inputs = inputs;
        this.event = event;
    }

    public GuiSignalComponent getInput(SignalTarget target) throws ParseException {
        for (GuiSignalComponent component : this.inputs) {
            if (!component.name.equals(target.writeBase())) continue;
            return component;
        }
        throw new ParseException("input not found", 0);
    }

    public void createControls() {
        this.controls.add(new GuiLabel("result", SubGuiDialogSignal.translate((String)"gui.signal.configuration.result"), 0, 0));
        final GuiSignalController controller = new GuiSignalController("controller", 0, 22, 294, 150, this.event.getOutput(), this.inputs);
        this.controls.add(controller);
        ArrayList<String> inputLines = new ArrayList<String>();
        for (GuiSignalComponent entry : this.inputs) {
            inputLines.add(entry.info());
        }
        inputLines.add("[]");
        inputLines.add("number");
        this.controls.add(new GuiComboBox("inputs", 0, 180, 80, inputLines));
        this.controls.add(new GuiButton("add", SubGuiDialogSignal.translate((String)"gui.signal.configuration.add"), 88, 180){

            public void onClicked(int x, int y, int button) {
                GuiComboBox inputsBox = (GuiComboBox)SubGuiDialogSignal.this.get("inputs");
                if (inputsBox.index < SubGuiDialogSignal.this.inputs.size()) {
                    controller.addInput(SubGuiDialogSignal.this.inputs.get(inputsBox.index));
                } else if (inputsBox.index == SubGuiDialogSignal.this.inputs.size()) {
                    controller.addVirtualInput();
                } else {
                    controller.addVirtualNumberInput();
                }
            }
        });
        ArrayList<String> opteratorLines = new ArrayList<String>();
        opteratorLines.add(SignalLogicOperator.AND.display);
        opteratorLines.add(SignalLogicOperator.OR.display);
        opteratorLines.add(SignalLogicOperator.XOR.display);
        opteratorLines.add("not");
        opteratorLines.add(SignalLogicOperator.BITWISE_AND.display);
        opteratorLines.add(SignalLogicOperator.BITWISE_OR.display);
        opteratorLines.add(SignalLogicOperator.BITWISE_XOR.display);
        opteratorLines.add("b-not");
        opteratorLines.add(SignalLogicOperator.ADD.display);
        opteratorLines.add(SignalLogicOperator.SUB.display);
        opteratorLines.add(SignalLogicOperator.MUL.display);
        opteratorLines.add(SignalLogicOperator.DIV.display);
        this.controls.add(new GuiComboBox("operators", 103, 180, 40, opteratorLines));
        this.controls.add(new GuiButton("add", SubGuiDialogSignal.translate((String)"gui.signal.configuration.addop"), 150, 180){

            public void onClicked(int x, int y, int button) {
                GuiComboBox operatorsBox = (GuiComboBox)SubGuiDialogSignal.this.get("operators");
                int index = operatorsBox.index;
                if (index < 3) {
                    controller.addOperator(SignalLogicOperator.values()[index]);
                } else if (index == 3) {
                    controller.addNotOperator(false);
                } else if (index == 7) {
                    controller.addNotOperator(true);
                } else if (index > 7) {
                    controller.addOperator(SignalLogicOperator.values()[index - 2]);
                } else {
                    controller.addOperator(SignalLogicOperator.values()[index - 1]);
                }
            }
        });
        if (this.event.getCondition() != null) {
            controller.setCondition(this.event.getCondition(), this);
        }
        this.controls.add(new GuiLabel("delay", 210, 182));
        this.changed(new GuiControlChangedEvent((GuiControl)controller));
        if (this.event.hasModeConfiguration()) {
            this.controls.add(new GuiButton("mode", 250, 0){

                public void onClicked(int x, int y, int button) {
                    this.openClientLayer(new SubGuiDialogSignalMode(SubGuiDialogSignal.this, SubGuiDialogSignal.this.event));
                }
            });
        }
        this.controls.add(new GuiButton("save", SubGuiDialogSignal.translate((String)"gui.signal.configuration.save"), 270, 180){

            public void onClicked(int x, int y, int button) {
                try {
                    SubGuiDialogSignal.this.event.setCondition(controller.generatePattern());
                    SubGuiDialogSignal.this.event.update();
                    SubGuiDialogSignal.this.closeGui();
                }
                catch (GuiSignalController.GeneratePatternException generatePatternException) {
                    // empty catch block
                }
            }
        });
        this.modeChanged();
    }

    public void modeChanged() {
        if (this.event.hasModeConfiguration()) {
            GuiButton button = (GuiButton)this.get("mode");
            button.setCaption(SubGuiDialogSignal.translate((String)this.event.getModeConfiguration().getMode().translateKey));
            button.posX = 300 - button.width;
        }
    }

    @CustomEventSubscribe
    public void changed(GuiControlChangedEvent event) {
        if (event.source.is(new String[]{"controller"})) {
            GuiLabel label = (GuiLabel)this.get("result");
            GuiLabel delay = (GuiLabel)this.get("delay");
            try {
                SignalInputCondition condition = ((GuiSignalController)event.source).generatePattern();
                label.setCaption(SubGuiDialogSignal.translate((String)"gui.signal.configuration.result") + " " + condition.toString());
                DecimalFormat df = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
                df.setMaximumFractionDigits(5);
                delay.setCaption(df.format(condition.calculateDelay()) + " ticks");
            }
            catch (GuiSignalController.GeneratePatternException e) {
                label.setCaption(SubGuiDialogSignal.translate((String)"gui.signal.configuration.result") + " " + SubGuiDialogSignal.translate((String)e.getMessage()));
                delay.setCaption("0 ticks");
            }
        }
    }

    public static interface IConditionConfiguration {
        public GuiSignalComponent getOutput();

        public SignalInputCondition getCondition();

        public void setCondition(SignalInputCondition var1);

        public boolean hasModeConfiguration();

        public SignalMode.GuiSignalModeConfiguration getModeConfiguration();

        public void setModeConfiguration(SignalMode.GuiSignalModeConfiguration var1);

        public void update();
    }

    public static class GuiSignalComponent {
        public final String name;
        public final String parentName;
        public final boolean input;
        public final boolean external;
        public final int index;
        public final int bandwidth;
        public final String totalName;
        public final SignalMode defaultMode;

        public GuiSignalComponent(String name, String prefix, LittleStructureType.InternalComponent component, boolean input, boolean external, int index, String parentName) {
            this.name = name;
            this.bandwidth = component.bandwidth;
            this.totalName = prefix + component.identifier;
            this.input = input;
            this.external = external;
            this.index = index;
            this.parentName = parentName;
            this.defaultMode = component instanceof LittleStructureType.InternalComponentOutput ? ((LittleStructureType.InternalComponentOutput)component).defaultMode : SignalMode.EQUAL;
        }

        public GuiSignalComponent(String name, String totalName, ISignalComponent component, boolean external, int index, String parentName) {
            this.parentName = parentName;
            this.name = name;
            try {
                this.bandwidth = component.getBandwidth();
            }
            catch (CorruptedConnectionException | NotYetConnectedException e) {
                throw new RuntimeException(e);
            }
            this.totalName = totalName;
            this.input = component.getType() == SignalComponentType.INPUT;
            this.external = external;
            this.index = index;
            this.defaultMode = SignalMode.EQUAL;
        }

        public GuiSignalComponent(String name, String totalName, int bandwidth, SignalComponentType type, boolean external, int index, String parentName) {
            this.parentName = parentName;
            this.name = name;
            this.bandwidth = bandwidth;
            this.totalName = totalName;
            this.input = type == SignalComponentType.INPUT;
            this.external = external;
            this.index = index;
            this.defaultMode = SignalMode.EQUAL;
        }

        public String display() {
            String longName = this.totalName;
            if (this.parentName != null) {
                String[] totalNameSplit = this.totalName.split("\\.");
                longName = this.parentName + "." + totalNameSplit[totalNameSplit.length - 1];
            }
            if (this.name.equals(longName)) {
                return ChatFormatting.BOLD + this.name + " " + ChatFormatting.RESET + this.bandwidth + "-bit";
            }
            return ChatFormatting.BOLD + this.name + " " + longName + " " + ChatFormatting.RESET + this.bandwidth + "-bit";
        }

        public String info() {
            return this.name + " " + this.totalName;
        }
    }
}

