/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.gui.dialogs;

import com.creativemd.creativecore.common.gui.CoreControl;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiListBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiPanel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiScrollBox;
import com.creativemd.creativecore.common.utils.mc.ChatFormatting;
import com.creativemd.littletiles.client.gui.signal.SubGuiDialogSignal;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.signal.component.ISignalComponent;
import com.creativemd.littletiles.common.structure.signal.component.SignalComponentType;
import com.creativemd.littletiles.common.structure.signal.input.SignalInputCondition;
import com.creativemd.littletiles.common.structure.signal.logic.SignalMode;
import com.creativemd.littletiles.common.structure.signal.output.InternalSignalOutput;
import com.creativemd.littletiles.common.structure.signal.output.SignalExternalOutputHandler;
import com.creativemd.littletiles.common.structure.signal.output.SignalOutputHandler;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class SubGuiSignalEvents
extends SubGui {
    public GuiSignalEventsButton button;
    public List<GuiSignalEvent> events;

    public SubGuiSignalEvents(GuiSignalEventsButton button) {
        super(300, 200);
        this.button = button;
        this.events = new ArrayList<GuiSignalEvent>();
        for (GuiSignalEvent event : button.events) {
            this.events.add(event.copy());
        }
    }

    public void addEntry(final GuiSignalEvent event) {
        GuiScrollBox box = (GuiScrollBox)this.get("content");
        GuiPanel panel = new GuiPanel("event", 2, 2, 158, 30);
        panel.addControl((GuiControl)new GuiLabel("label", 0, 0));
        panel.addControl((GuiControl)new GuiLabel("mode", 0, 16));
        panel.addControl((GuiControl)new GuiButton("edit", 84, 14, 30, 10){

            public void onClicked(int x, int y, int button) {
                this.openClientLayer(new SubGuiDialogSignal(SubGuiSignalEvents.this.button.inputs, event));
            }
        });
        panel.addControl((GuiControl)new GuiButton("reset", 122, 14, 30, 10){

            public void onClicked(int x, int y, int button) {
                event.reset();
            }
        });
        box.addControl((GuiControl)panel);
        event.panel = panel;
        event.update();
        this.reloadListBox();
    }

    public void reloadListBox() {
        GuiScrollBox box = (GuiScrollBox)this.get("content");
        int height = 2;
        for (GuiControl control : box.controls) {
            control.posY = height;
            height += control.height + 2;
        }
    }

    public List<String> getComponents(LittlePreviews previews, SignalComponentType type) {
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < previews.childrenCount(); ++i) {
            LittlePreviews child = previews.getChild(i);
            LittleStructureType structure = child.getStructureType();
            if (!(structure instanceof ISignalComponent) || ((ISignalComponent)((Object)structure)).getType() != type) continue;
            String name = child.getStructureName();
            try {
                values.add(ChatFormatting.BOLD + (type == SignalComponentType.INPUT ? "i" : "o") + i + " " + (name != null ? "(" + name + ") " : "") + "" + ChatFormatting.RESET + ((ISignalComponent)((Object)structure)).getBandwidth() + "-bit");
                continue;
            }
            catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                // empty catch block
            }
        }
        return values;
    }

    public void createControls() {
        GuiScrollBox box = new GuiScrollBox("content", 0, 0, 170, 172);
        ArrayList<String> values = new ArrayList<String>();
        values.add("Components:");
        for (SubGuiDialogSignal.GuiSignalComponent component : this.button.inputs) {
            values.add(component.display());
        }
        GuiListBox components = new GuiListBox("components", 180, 0, 120, 180, values);
        this.controls.add(components);
        this.controls.add(box);
        for (GuiSignalEvent event : this.events) {
            this.addEntry(event);
        }
        this.controls.add(new GuiButton("save", 146, 180){

            public void onClicked(int x, int y, int button) {
                SubGuiSignalEvents.this.button.events = SubGuiSignalEvents.this.events;
                SubGuiSignalEvents.this.closeGui();
            }
        });
        this.controls.add(new GuiButton("cancel", 0, 180){

            public void onClicked(int x, int y, int button) {
                SubGuiSignalEvents.this.closeGui();
            }
        });
    }

    public static class GuiSignalEvent
    implements SubGuiDialogSignal.IConditionConfiguration {
        public final SubGuiDialogSignal.GuiSignalComponent component;
        public SignalInputCondition condition;
        public SignalMode.GuiSignalModeConfiguration modeConfig;
        public GuiPanel panel;

        public GuiSignalEvent(SubGuiDialogSignal.GuiSignalComponent component, NBTTagCompound nbt) {
            this.component = component;
            try {
                this.condition = nbt.func_74764_b("con") ? SignalInputCondition.parseInput(nbt.func_74779_i("con")) : null;
            }
            catch (ParseException e) {
                this.condition = null;
            }
            this.modeConfig = SignalMode.getConfig(nbt, component.defaultMode);
        }

        private GuiSignalEvent(SubGuiDialogSignal.GuiSignalComponent component, SignalInputCondition condition, SignalMode.GuiSignalModeConfiguration modeConfig) {
            this.component = component;
            this.condition = condition;
            this.modeConfig = modeConfig;
        }

        public void reset() {
            this.modeConfig = SignalMode.getConfigDefault();
            this.condition = null;
            this.update();
        }

        @Override
        public void update() {
            GuiLabel label = (GuiLabel)this.panel.get("label");
            label.setCaption(this.component.name + ": " + this.condition);
            GuiLabel mode = (GuiLabel)this.panel.get("mode");
            int delay = this.modeConfig.delay;
            if (this.condition != null) {
                delay = Math.max(delay, (int)Math.ceil(this.condition.calculateDelay()));
            }
            mode.setCaption(CoreControl.translate((String)this.modeConfig.getMode().translateKey) + " delay: " + delay);
        }

        public SignalOutputHandler getHandler(ISignalComponent component, LittleStructure structure) {
            if (this.condition != null) {
                return this.modeConfig.getHandler(component, structure);
            }
            return null;
        }

        public GuiSignalEvent copy() {
            return new GuiSignalEvent(this.component, this.condition, this.modeConfig.copy());
        }

        @Override
        public SubGuiDialogSignal.GuiSignalComponent getOutput() {
            return this.component;
        }

        @Override
        public SignalInputCondition getCondition() {
            return this.condition;
        }

        @Override
        public void setCondition(SignalInputCondition condition) {
            this.condition = condition;
        }

        @Override
        public boolean hasModeConfiguration() {
            return true;
        }

        @Override
        public SignalMode.GuiSignalModeConfiguration getModeConfiguration() {
            return this.modeConfig;
        }

        @Override
        public void setModeConfiguration(SignalMode.GuiSignalModeConfiguration config) {
            this.modeConfig = config;
        }
    }

    private static class ComponentSearch {
        public LittlePreviews previews;
        public LittleStructureType type;

        public ComponentSearch(LittlePreviews previews, LittleStructureType type) {
            this.previews = previews;
            this.type = type;
        }

        public List<SubGuiDialogSignal.GuiSignalComponent> search(boolean input, boolean output, boolean includeRelations) {
            ArrayList<SubGuiDialogSignal.GuiSignalComponent> list = new ArrayList<SubGuiDialogSignal.GuiSignalComponent>();
            if (input) {
                this.gatherInputs(this.previews, this.type, "", "", list, includeRelations, true);
            }
            if (output) {
                this.gatherOutputs(this.previews, this.type, "", "", list, includeRelations, true);
            }
            return list;
        }

        protected void addInput(LittlePreviews previews, LittleStructureType type, String prefix, String totalNamePrefix, List<SubGuiDialogSignal.GuiSignalComponent> list, boolean includeRelations) {
            int i;
            String parentName = previews.getStructureName();
            if (type != null && type.inputs != null) {
                for (i = 0; i < type.inputs.size(); ++i) {
                    list.add(new SubGuiDialogSignal.GuiSignalComponent(prefix + "a" + i, totalNamePrefix, type.inputs.get(i), true, false, i, parentName));
                }
            }
            for (i = 0; i < previews.childrenCount(); ++i) {
                LittlePreviews child = previews.getChild(i);
                if (child == this.previews) continue;
                LittleStructureType structure = child.getStructureType();
                String name = child.getStructureName();
                if (structure instanceof ISignalComponent && ((ISignalComponent)((Object)structure)).getType() == SignalComponentType.INPUT) {
                    list.add(new SubGuiDialogSignal.GuiSignalComponent(prefix + "i" + i, totalNamePrefix + (name != null ? name : "i" + i), (ISignalComponent)((Object)structure), true, i, parentName));
                    continue;
                }
                if (!includeRelations) continue;
                this.gatherInputs(child, child.getStructureType(), prefix + "c" + i + ".", totalNamePrefix + (name != null ? name + "." : "c" + i + "."), list, includeRelations, false);
            }
        }

        protected void gatherInputs(LittlePreviews previews, LittleStructureType type, String prefix, String totalNamePrefix, List<SubGuiDialogSignal.GuiSignalComponent> list, boolean includeRelations, boolean searchForParent) {
            if (previews == this.previews) {
                this.addInput(previews, type, "", "", list, includeRelations);
            }
            if (searchForParent && previews.hasParent() && includeRelations) {
                this.gatherInputs(previews.getParent(), previews.getParent().getStructureType(), "p." + prefix, "p." + totalNamePrefix, list, includeRelations, true);
                return;
            }
            if (previews != this.previews) {
                this.addInput(previews, type, prefix, totalNamePrefix, list, includeRelations);
            }
        }

        protected void addOutput(LittlePreviews previews, LittleStructureType type, String prefix, String totalNamePrefix, List<SubGuiDialogSignal.GuiSignalComponent> list, boolean includeRelations) {
            int i;
            String parentName = previews.getStructureName();
            if (type != null && type.outputs != null) {
                for (i = 0; i < type.outputs.size(); ++i) {
                    list.add(new SubGuiDialogSignal.GuiSignalComponent(prefix + "b" + i, totalNamePrefix, type.outputs.get(i), false, false, i, parentName));
                }
            }
            for (i = 0; i < previews.childrenCount(); ++i) {
                LittlePreviews child = previews.getChild(i);
                if (child == this.previews) continue;
                LittleStructureType structure = child.getStructureType();
                String name = child.getStructureName();
                if (structure instanceof ISignalComponent && ((ISignalComponent)((Object)structure)).getType() == SignalComponentType.OUTPUT) {
                    list.add(new SubGuiDialogSignal.GuiSignalComponent(prefix + "o" + i, totalNamePrefix + (name != null ? name : "o" + i), (ISignalComponent)((Object)structure), true, i, parentName));
                    continue;
                }
                if (!includeRelations) continue;
                this.gatherOutputs(child, child.getStructureType(), prefix + "c" + i + ".", totalNamePrefix + (name != null ? name + "." : "c" + i + "."), list, includeRelations, false);
            }
        }

        protected void gatherOutputs(LittlePreviews previews, LittleStructureType type, String prefix, String totalNamePrefix, List<SubGuiDialogSignal.GuiSignalComponent> list, boolean includeRelations, boolean searchForParent) {
            if (previews == this.previews) {
                this.addOutput(previews, type, "", "", list, includeRelations);
            }
            if (searchForParent && previews.hasParent() && includeRelations) {
                this.gatherOutputs(previews.getParent(), previews.getParent().getStructureType(), "p." + prefix, "p." + totalNamePrefix, list, includeRelations, searchForParent);
                return;
            }
            if (previews != this.previews) {
                this.addOutput(previews, type, prefix, totalNamePrefix, list, includeRelations);
            }
        }
    }

    public static class GuiSignalEventsButton
    extends GuiButton {
        public SubGuiSignalEvents gui;
        public LittlePreviews previews;
        public LittleStructureType type;
        public LittleStructure activator;
        public final List<SubGuiDialogSignal.GuiSignalComponent> inputs;
        public final List<SubGuiDialogSignal.GuiSignalComponent> outputs;
        public List<GuiSignalEvent> events;

        public GuiSignalEventsButton(String name, int x, int y, LittlePreviews previews, LittleStructure structure, LittleStructureType type) {
            super(name, GuiSignalEventsButton.translate((String)"gui.signal.events"), x, y, 40, 7);
            this.previews = previews;
            this.activator = structure;
            this.type = type;
            this.events = null;
            ComponentSearch search = new ComponentSearch(previews, type);
            this.inputs = search.search(true, true, true);
            this.outputs = search.search(false, true, false);
            this.events = new ArrayList<GuiSignalEvent>();
            for (SubGuiDialogSignal.GuiSignalComponent output : this.outputs) {
                NBTTagCompound nbt = previews.structureNBT;
                if (output.external) {
                    if (nbt == null) {
                        this.events.add(new GuiSignalEvent(output, new NBTTagCompound()));
                        continue;
                    }
                    boolean found = false;
                    NBTTagList list = nbt.func_150295_c("signal", 10);
                    for (int i = 0; i < list.func_74745_c(); ++i) {
                        NBTTagCompound outputNBT = list.func_150305_b(i);
                        if (outputNBT.func_74762_e("index") != output.index) continue;
                        this.events.add(new GuiSignalEvent(output, outputNBT));
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.events.add(new GuiSignalEvent(output, new NBTTagCompound()));
                    continue;
                }
                this.events.add(new GuiSignalEvent(output, nbt == null ? new NBTTagCompound() : nbt.func_74775_l(output.totalName)));
            }
        }

        public void setEventsInStructure(LittleStructure structure) {
            HashMap<Integer, SignalExternalOutputHandler> map = new HashMap<Integer, SignalExternalOutputHandler>();
            for (GuiSignalEvent event : this.events) {
                if (event.component.external) {
                    if (event.condition == null) continue;
                    map.put(event.component.index, new SignalExternalOutputHandler(null, event.component.index, event.condition, x -> event.getHandler((ISignalComponent)x, structure)));
                    continue;
                }
                InternalSignalOutput output = structure.getOutput(event.component.index);
                output.condition = event.condition;
                output.handler = event.getHandler(output, structure);
            }
            structure.setExternalHandler(map);
        }

        public void onClicked(int x, int y, int button) {
            this.openClientLayer(new SubGuiSignalEvents(this));
        }
    }
}

