/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.gui;

import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.converation.StructureStringUtils;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;

public class SubGuiImport
extends SubGui {
    public GuiTextfield textfield;

    public void createControls() {
        this.textfield = new GuiTextfield("import", "", 10, 30, 150, 14);
        this.controls.add(this.textfield);
        this.controls.add(new GuiButton("Paste", 10, 52){

            public void onClicked(int x, int y, int button) {
                StringSelection stringSelection = new StringSelection(SubGuiImport.this.textfield.text);
                Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable t = clpbrd.getContents((Object)this);
                if (t == null) {
                    return;
                }
                try {
                    SubGuiImport.this.textfield.text = (String)t.getTransferData(DataFlavor.stringFlavor);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.controls.add(new GuiButton("Import", 128, 52){

            public void onClicked(int x, int y, int button) {
                try {
                    NBTTagCompound nbt = JsonToNBT.func_180713_a((String)SubGuiImport.this.textfield.text);
                    try {
                        LittleGridContext.get(nbt);
                    }
                    catch (RuntimeException e) {
                        SubGuiImport.this.openButtonDialogDialog("Invalid grid size " + nbt.func_74762_e("grid"), new String[]{"Ok"});
                        return;
                    }
                    String name = SubGuiImport.this.canImport(LittlePreviews.getPreview(StructureStringUtils.importStructure(nbt), false));
                    if (name.isEmpty() || 2.mc.field_71439_g.func_184812_l_()) {
                        SubGuiImport.this.sendPacketToServer(nbt);
                    } else {
                        SubGuiImport.this.openButtonDialogDialog("Structure Type: " + name + " must be imported in creative mode.", new String[]{"Ok"});
                    }
                }
                catch (NBTException nBTException) {
                    // empty catch block
                }
            }
        });
    }

    private String canImport(LittlePreviews previews) {
        if (previews.getStructureType() != null) {
            LittleStructureType type = previews.getStructureType();
            if (!type.canImport()) {
                return type.id;
            }
            String typeName = "";
            for (LittlePreviews child : previews.getChildren()) {
                typeName = this.canImport(child);
            }
            return typeName;
        }
        return "";
    }
}

