/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.gui;

import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiColorPicker;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBoxTranslated;
import com.creativemd.creativecore.common.gui.controls.gui.GuiScrollBox;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.gui.configure.SubGuiConfigure;
import com.creativemd.littletiles.common.api.ILittleEditor;
import com.creativemd.littletiles.common.item.ItemLittlePaintBrush;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.shape.LittleShape;
import com.creativemd.littletiles.common.util.shape.ShapeRegistry;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.util.Color;

public class SubGuiColorTube
extends SubGuiConfigure {
    public SubGuiColorTube(ItemStack stack) {
        super(140, 173, stack);
    }

    public LittleGridContext getContext() {
        return ((ILittleEditor)this.stack.func_77973_b()).getPositionContext(this.stack);
    }

    public void createControls() {
        Color color = ColorUtils.IntToRGBA((int)ItemLittlePaintBrush.getColor(this.stack));
        this.controls.add(new GuiColorPicker("picker", 2, 2, color, LittleTiles.CONFIG.isTransparencyEnabled(this.getPlayer()), LittleTiles.CONFIG.getMinimumTransparency(this.getPlayer())));
        ArrayList<String> shapes = new ArrayList<String>(ShapeRegistry.allShapeNames());
        GuiComboBoxTranslated box = new GuiComboBoxTranslated("shape", 0, 50, 134, "shape.", shapes);
        LittleShape shape = ItemLittlePaintBrush.getShape(this.stack);
        box.select(shape == null ? "tile" : shape.getKey());
        GuiScrollBox scroll = new GuiScrollBox("settings", 0, 73, 134, 90);
        this.controls.add(box);
        this.controls.add(scroll);
        this.onChange();
    }

    @Override
    public void saveConfiguration() {
        GuiComboBox box = (GuiComboBox)this.get("shape");
        GuiScrollBox scroll = (GuiScrollBox)this.get("settings");
        LittleShape shape = box.getCaption().equals("tile") || box.getCaption().equals("") ? null : ShapeRegistry.getShape(box.getCaption());
        NBTTagCompound nbt = this.stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            this.stack.func_77982_d(nbt);
        }
        nbt.func_74778_a("shape", shape == null ? "tile" : shape.getKey());
        GuiColorPicker picker = (GuiColorPicker)this.get("picker");
        nbt.func_74768_a("color", ColorUtils.RGBAToInt((Color)picker.color));
        if (shape != null) {
            shape.saveCustomSettings((GuiParent)scroll, nbt, this.getContext());
        }
    }

    @CustomEventSubscribe
    public void onComboBoxChange(GuiControlChangedEvent event) {
        if (event.source.is(new String[]{"shape"})) {
            this.onChange();
        }
    }

    public void onChange() {
        LittleShape shape;
        GuiComboBox box = (GuiComboBox)this.get("shape");
        GuiScrollBox scroll = (GuiScrollBox)this.get("settings");
        scroll.controls.clear();
        LittleShape littleShape = shape = box.getCaption().equals("tile") || box.getCaption().equals("") ? null : ShapeRegistry.getShape(box.getCaption());
        if (shape != null) {
            scroll.controls.addAll(shape.getCustomSettings(this.stack.func_77978_p(), this.getContext()));
            scroll.refreshControls();
        }
    }
}

