/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.item;

import appeng.util.item.AESharedItemStack;
import appeng.util.item.ItemStackHashStrategy;
import com.google.common.collect.MapMaker;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public final class AEItemStackRegistry {
    private static final ItemStackHashStrategy HASH_STRATEGY = ItemStackHashStrategy.comparingAllButCount();
    private static final Map<Integer, AESharedItemStack> REGISTRY = new MapMaker().weakValues().makeMap();

    private AEItemStackRegistry() {
    }

    static synchronized AESharedItemStack getRegisteredStack(@Nonnull ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            throw new IllegalArgumentException("stack cannot be empty");
        }
        int hash = HASH_STRATEGY.hashCode(itemStack);
        AESharedItemStack ret = REGISTRY.get(hash);
        if (ret != null) {
            return ret;
        }
        ItemStack itemStackCopy = itemStack.func_77946_l();
        itemStackCopy.func_190920_e(1);
        AESharedItemStack sharedStack = new AESharedItemStack(itemStackCopy);
        REGISTRY.put(hash, sharedStack);
        return sharedStack;
    }
}

