/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.reporting;

import appeng.api.AEApi;
import appeng.api.implementations.parts.IPartStorageMonitor;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.client.render.TesrRenderHelper;
import appeng.core.localization.PlayerMessages;
import appeng.fluids.util.AEFluidStack;
import appeng.me.GridAccessException;
import appeng.parts.reporting.AbstractPartDisplay;
import appeng.util.IWideReadableNumberConverter;
import appeng.util.Platform;
import appeng.util.ReadableNumberConverter;
import appeng.util.item.AEItemStack;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractPartMonitor
extends AbstractPartDisplay
implements IPartStorageMonitor,
IStackWatcherHost {
    private static final IWideReadableNumberConverter NUMBER_CONVERTER = ReadableNumberConverter.INSTANCE;
    private IAEItemStack configuredItem;
    private IAEFluidStack configuredFluid;
    private long configuredAmount;
    private String lastHumanReadableText;
    private boolean isLocked;
    private IStackWatcher myWatcher;

    public AbstractPartMonitor(ItemStack is) {
        super(is);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.isLocked = data.func_74767_n("isLocked");
        NBTTagCompound myItem = data.func_74775_l("configuredItem");
        this.configuredItem = AEItemStack.fromNBT(myItem);
        NBTTagCompound myFluid = data.func_74775_l("configuredFluid");
        this.configuredFluid = AEFluidStack.fromNBT(myFluid);
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("isLocked", this.isLocked);
        NBTTagCompound myItem = new NBTTagCompound();
        if (this.configuredItem != null) {
            this.configuredItem.writeToNBT(myItem);
        }
        NBTTagCompound myFluid = new NBTTagCompound();
        if (this.configuredFluid != null) {
            this.configuredFluid.writeToNBT(myFluid);
        }
        data.func_74782_a("configuredItem", (NBTBase)myItem);
        data.func_74782_a("configuredFluid", (NBTBase)myFluid);
    }

    @Override
    public void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        data.writeBoolean(this.isLocked);
        data.writeBoolean(this.configuredItem != null);
        data.writeBoolean(this.configuredFluid != null);
        if (this.configuredItem != null) {
            this.configuredItem.writeToPacket(data);
        } else if (this.configuredFluid != null) {
            this.configuredFluid.writeToPacket(data);
        }
    }

    @Override
    public boolean readFromStream(ByteBuf data) throws IOException {
        boolean needRedraw = super.readFromStream(data);
        boolean isLocked = data.readBoolean();
        needRedraw = this.isLocked != isLocked;
        this.isLocked = isLocked;
        boolean isItem = data.readBoolean();
        boolean isFluid = data.readBoolean();
        if (isItem) {
            this.configuredItem = AEItemStack.fromPacket(data);
            this.configuredFluid = null;
        } else if (isFluid) {
            this.configuredFluid = AEFluidStack.fromPacket(data);
            this.configuredItem = null;
        } else {
            this.configuredItem = null;
            this.configuredFluid = null;
        }
        return needRedraw;
    }

    @Override
    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (Platform.isClient()) {
            return true;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        if (!Platform.hasPermissions(this.getLocation(), player)) {
            return false;
        }
        if (!this.isLocked) {
            ItemStack eq = player.func_184586_b(hand);
            FluidStack fluidInTank = null;
            if (eq.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)eq.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                fluidInTank = fluidHandlerItem.drain(Integer.MAX_VALUE, false);
            }
            if (fluidInTank == null) {
                this.configuredFluid = null;
                this.configuredItem = !eq.func_190926_b() ? (IAEItemStack)AEItemStack.fromItemStack(eq).setStackSize(0L) : null;
            } else if (fluidInTank.amount > 0) {
                this.configuredFluid = (IAEFluidStack)AEFluidStack.fromFluidStack(fluidInTank).setStackSize(0L);
                this.configuredItem = null;
            }
        } else {
            return super.onPartActivate(player, hand, pos);
        }
        this.configureWatchers();
        this.getHost().markForSave();
        this.getHost().markForUpdate();
        return true;
    }

    @Override
    public boolean onPartShiftActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (Platform.isClient()) {
            return true;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        if (!Platform.hasPermissions(this.getLocation(), player)) {
            return false;
        }
        if (player.func_184586_b(hand).func_190926_b()) {
            this.isLocked = !this.isLocked;
            player.func_145747_a((this.isLocked ? PlayerMessages.isNowLocked : PlayerMessages.isNowUnlocked).get());
            this.getHost().markForSave();
            this.getHost().markForUpdate();
        }
        return true;
    }

    private void configureWatchers() {
        if (this.myWatcher != null) {
            this.myWatcher.reset();
        }
        try {
            if (this.configuredItem != null) {
                if (this.myWatcher != null) {
                    this.myWatcher.add(this.configuredItem);
                }
                this.updateReportingValue(this.getProxy().getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)));
            } else if (this.configuredFluid != null) {
                if (this.myWatcher != null) {
                    this.myWatcher.add(this.configuredFluid);
                }
                this.updateReportingValue(this.getProxy().getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class)));
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private <T extends IAEStack<T>> void updateReportingValue(IMEMonitor<T> monitor) {
        if (this.configuredItem != null) {
            IAEItemStack result = monitor.getStorageList().findPrecise(this.configuredItem);
            this.configuredAmount = result == null ? 0L : result.getStackSize();
            this.configuredItem.setStackSize(this.configuredAmount);
        } else if (this.configuredFluid != null) {
            IAEFluidStack result = monitor.getStorageList().findPrecise(this.configuredFluid);
            this.configuredAmount = result == null ? 0L : result.getStackSize();
            this.configuredFluid.setStackSize(this.configuredAmount);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(double x, double y, double z, float partialTicks, int destroyStage) {
        if ((this.getClientFlags() & 0x14) != 20) {
            return;
        }
        IAEStack<?> ais = this.getDisplayed();
        if (ais == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        EnumFacing facing = this.getSide().getFacing();
        TesrRenderHelper.moveToFace(facing);
        TesrRenderHelper.rotateToFace(facing, this.getSpin());
        if (ais instanceof IAEItemStack) {
            TesrRenderHelper.renderItem2dWithAmount((IAEItemStack)ais, 0.8f, 0.17f);
        }
        if (ais instanceof IAEFluidStack) {
            TesrRenderHelper.renderFluid2dWithAmount((IAEFluidStack)ais, 0.8f, 0.17f);
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean requireDynamicRender() {
        return true;
    }

    @Override
    public IAEStack<?> getDisplayed() {
        if (this.configuredItem != null) {
            return this.configuredItem;
        }
        if (this.configuredFluid != null) {
            return this.configuredFluid;
        }
        return null;
    }

    @Override
    public boolean isLocked() {
        return this.isLocked;
    }

    @Override
    public void updateWatcher(IStackWatcher newWatcher) {
        this.myWatcher = newWatcher;
        this.configureWatchers();
    }

    @MENetworkEventSubscribe
    public void powerStatusChange(MENetworkPowerStatusChange ev) {
        if (this.getProxy().isPowered()) {
            this.configureWatchers();
        }
    }

    @MENetworkEventSubscribe
    public void channelChanged(MENetworkChannelsChanged c) {
        if (this.getProxy().isPowered()) {
            this.configureWatchers();
        }
    }

    @Override
    public void onStackChange(IItemList<?> o, IAEStack<?> fullStack, IAEStack<?> diffStack, IActionSource src, IStorageChannel<?> chan) {
        this.configuredAmount = fullStack.getStackSize();
        if (this.configuredItem != null) {
            this.configuredItem.setStackSize(this.configuredAmount);
        } else if (this.configuredFluid != null) {
            this.configuredFluid.setStackSize(this.configuredAmount);
        }
        this.getHost().markForUpdate();
    }

    @Override
    public boolean showNetworkInfo(RayTraceResult where) {
        return false;
    }

    protected IPartModel selectModel(IPartModel off, IPartModel on, IPartModel hasChannel, IPartModel lockedOff, IPartModel lockedOn, IPartModel lockedHasChannel) {
        if (this.isActive()) {
            if (this.isLocked()) {
                return lockedHasChannel;
            }
            return hasChannel;
        }
        if (this.isPowered()) {
            if (this.isLocked()) {
                return lockedOn;
            }
            return on;
        }
        if (this.isLocked()) {
            return lockedOff;
        }
        return off;
    }
}

