/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.reporting;

import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.parts.IPartModel;
import appeng.api.storage.data.IAEItemStack;
import appeng.core.sync.GuiBridge;
import appeng.parts.reporting.AbstractPartTerminal;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.inv.InvOperation;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;

public abstract class AbstractPartEncoder
extends AbstractPartTerminal {
    protected AppEngInternalInventory crafting;
    protected AppEngInternalInventory output;
    protected AppEngInternalInventory pattern;
    protected boolean craftingMode = true;
    protected boolean substitute = false;

    public AbstractPartEncoder(ItemStack is) {
        super(is);
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        for (ItemStack is : this.pattern) {
            if (is.func_190926_b()) continue;
            drops.add(is);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.pattern.readFromNBT(data, "pattern");
        this.output.readFromNBT(data, "outputList");
        this.crafting.readFromNBT(data, "crafting");
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.pattern.writeToNBT(data, "pattern");
        this.output.writeToNBT(data, "outputList");
        this.crafting.writeToNBT(data, "crafting");
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        if (inv == this.pattern && slot == 1) {
            ICraftingPatternItem pattern;
            ICraftingPatternDetails details;
            ItemStack is = this.pattern.getStackInSlot(1);
            if (!is.func_190926_b() && is.func_77973_b() instanceof ICraftingPatternItem && (details = (pattern = (ICraftingPatternItem)is.func_77973_b()).getPatternForItem(is, this.getHost().getTile().func_145831_w())) != null) {
                IAEItemStack item;
                int x;
                this.setCraftingRecipe(details.isCraftable());
                this.setSubstitution(details.canSubstitute());
                for (x = 0; x < this.crafting.getSlots() && x < details.getInputs().length; ++x) {
                    item = details.getInputs()[x];
                    this.crafting.setStackInSlot(x, item == null ? ItemStack.field_190927_a : item.createItemStack());
                }
                for (x = 0; x < this.output.getSlots(); ++x) {
                    item = x < details.getOutputs().length ? details.getOutputs()[x] : null;
                    this.output.setStackInSlot(x, item == null ? ItemStack.field_190927_a : item.createItemStack());
                }
            }
        } else if (inv == this.crafting) {
            this.fixCraftingRecipes();
        }
        this.getHost().markForSave();
    }

    private void fixCraftingRecipes() {
        if (this.isCraftingRecipe()) {
            for (int x = 0; x < this.crafting.getSlots(); ++x) {
                ItemStack is = this.crafting.getStackInSlot(x);
                if (is.func_190926_b()) continue;
                is.func_190920_e(1);
            }
        }
    }

    public boolean isCraftingRecipe() {
        return this.craftingMode;
    }

    public void setCraftingRecipe(boolean craftingMode) {
        this.craftingMode = craftingMode;
        this.fixCraftingRecipes();
    }

    public boolean isSubstitution() {
        return this.substitute;
    }

    public void setSubstitution(boolean canSubstitute) {
        this.substitute = canSubstitute;
    }

    @Override
    public IItemHandler getInventoryByName(String name) {
        if (name.equals("crafting")) {
            return this.crafting;
        }
        if (name.equals("output")) {
            return this.output;
        }
        if (name.equals("pattern")) {
            return this.pattern;
        }
        return super.getInventoryByName(name);
    }

    @Override
    public GuiBridge getGui(EntityPlayer p) {
        int x = (int)p.field_70165_t;
        int y = (int)p.field_70163_u;
        int z = (int)p.field_70161_v;
        if (this.getHost().getTile() != null) {
            x = this.getTile().func_174877_v().func_177958_n();
            y = this.getTile().func_174877_v().func_177956_o();
            z = this.getTile().func_174877_v().func_177952_p();
        }
        if (this.getGuiBridge().hasPermissions(this.getHost().getTile(), x, y, z, this.getSide(), p)) {
            return this.getGuiBridge();
        }
        return GuiBridge.GUI_ME;
    }

    public abstract GuiBridge getGuiBridge();

    @Override
    @Nonnull
    public abstract IPartModel getStaticModels();
}

