/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cache;

import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridCache;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridStorage;
import appeng.api.networking.events.MENetworkBootingStatusChange;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.ticking.ITickManager;
import appeng.core.AELog;
import appeng.me.cache.helpers.TunnelCollection;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.parts.p2p.PartP2PTunnelME;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Random;

public class P2PCache
implements IGridCache {
    private static final TunnelCollection<PartP2PTunnel> NULL_COLLECTION = new TunnelCollection(null, null);
    private final IGrid myGrid;
    private final Multimap<Short, PartP2PTunnel> inputs = LinkedHashMultimap.create();
    private final Multimap<Short, PartP2PTunnel> outputs = LinkedHashMultimap.create();
    private final Random frequencyGenerator;

    public P2PCache(IGrid g) {
        this.myGrid = g;
        this.frequencyGenerator = new Random(g.hashCode());
    }

    @MENetworkEventSubscribe
    public void bootComplete(MENetworkBootingStatusChange bootStatus) {
        ITickManager tm = (ITickManager)this.myGrid.getCache(ITickManager.class);
        for (PartP2PTunnel me : this.inputs.values()) {
            if (!(me instanceof PartP2PTunnelME)) continue;
            tm.wakeDevice(me.getGridNode());
        }
    }

    @MENetworkEventSubscribe
    public void bootComplete(MENetworkPowerStatusChange power) {
        ITickManager tm = (ITickManager)this.myGrid.getCache(ITickManager.class);
        for (PartP2PTunnel me : this.inputs.values()) {
            if (!(me instanceof PartP2PTunnelME)) continue;
            tm.wakeDevice(me.getGridNode());
        }
    }

    @Override
    public void onUpdateTick() {
    }

    @Override
    public void removeNode(IGridNode node, IGridHost machine) {
        if (machine instanceof PartP2PTunnel) {
            if (machine instanceof PartP2PTunnelME && !node.hasFlag(GridFlags.REQUIRE_CHANNEL)) {
                return;
            }
            PartP2PTunnel t = (PartP2PTunnel)machine;
            if (t.isOutput()) {
                this.outputs.remove((Object)t.getFrequency(), (Object)t);
            } else {
                this.inputs.remove((Object)t.getFrequency(), (Object)t);
            }
            if (this.inputs.get((Object)t.getFrequency()).isEmpty()) {
                this.inputs.removeAll((Object)t.getFrequency());
            }
            if (this.outputs.get((Object)t.getFrequency()).isEmpty()) {
                this.outputs.removeAll((Object)t.getFrequency());
            }
            this.updateTunnel(t.getFrequency(), t.isOutput(), false);
        }
    }

    @Override
    public void addNode(IGridNode node, IGridHost machine) {
        if (machine instanceof PartP2PTunnel) {
            if (machine instanceof PartP2PTunnelME && !node.hasFlag(GridFlags.REQUIRE_CHANNEL)) {
                return;
            }
            PartP2PTunnel t = (PartP2PTunnel)machine;
            if (t.isOutput()) {
                this.outputs.put((Object)t.getFrequency(), (Object)t);
            } else {
                this.inputs.put((Object)t.getFrequency(), (Object)t);
            }
            this.updateTunnel(t.getFrequency(), t.isOutput(), false);
        }
    }

    @Override
    public void onSplit(IGridStorage storageB) {
    }

    @Override
    public void onJoin(IGridStorage storageB) {
    }

    @Override
    public void populateGridStorage(IGridStorage storage) {
    }

    public void removeTunnel(PartP2PTunnel t, short freq) {
        this.outputs.remove((Object)freq, (Object)t);
        this.inputs.remove((Object)freq, (Object)t);
        if (this.inputs.get((Object)t.getFrequency()).isEmpty()) {
            this.inputs.removeAll((Object)t.getFrequency());
        }
        if (this.outputs.get((Object)t.getFrequency()).isEmpty()) {
            this.outputs.removeAll((Object)t.getFrequency());
        }
    }

    private void updateTunnel(short freq, boolean updateOutputs, boolean configChange) {
        for (PartP2PTunnel p : this.outputs.get((Object)freq)) {
            if (configChange) {
                p.onTunnelConfigChange();
            }
            p.onTunnelNetworkChange();
        }
        for (PartP2PTunnel in : this.inputs.get((Object)freq)) {
            if (configChange) {
                in.onTunnelConfigChange();
            }
            in.onTunnelNetworkChange();
        }
    }

    public void updateFreq(PartP2PTunnel t, short newFrequency) {
        if (this.outputs.containsValue((Object)t)) {
            this.outputs.remove((Object)t.getFrequency(), (Object)t);
        }
        if (this.inputs.containsValue((Object)t)) {
            this.inputs.remove((Object)t.getFrequency(), (Object)t);
        }
        t.setFrequency(newFrequency);
        if (t.isOutput()) {
            this.outputs.put((Object)t.getFrequency(), (Object)t);
        } else {
            this.inputs.put((Object)t.getFrequency(), (Object)t);
        }
        this.updateTunnel(t.getFrequency(), t.isOutput(), true);
    }

    public short newFrequency() {
        short newFrequency;
        int cycles = 0;
        do {
            newFrequency = (short)this.frequencyGenerator.nextInt(65536);
            ++cycles;
        } while (newFrequency == 0 || this.inputs.containsKey((Object)newFrequency));
        if (cycles > 25) {
            AELog.debug("Generating a new P2P frequency '%1$d' took %2$d cycles", newFrequency, cycles);
        }
        return newFrequency;
    }

    public TunnelCollection<PartP2PTunnel> getOutputs(short freq, Class<? extends PartP2PTunnel> c) {
        Collection in = this.inputs.get((Object)freq);
        if (in == null) {
            return NULL_COLLECTION;
        }
        for (PartP2PTunnel part : this.inputs.get((Object)freq)) {
            TunnelCollection<PartP2PTunnel> out = part.getCollection(this.outputs.get((Object)freq), c);
            if (out == null) continue;
            return out;
        }
        return NULL_COLLECTION;
    }

    public TunnelCollection<PartP2PTunnel> getInputs(short freq, Class<? extends PartP2PTunnel> c) {
        Collection out = this.outputs.get((Object)freq);
        if (out == null) {
            return NULL_COLLECTION;
        }
        for (PartP2PTunnel part : this.outputs.get((Object)freq)) {
            TunnelCollection<PartP2PTunnel> in = part.getCollection(this.inputs.get((Object)freq), c);
            if (in == null) continue;
            return in;
        }
        return NULL_COLLECTION;
    }
}

