/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.client.gui.widgets;

import appeng.api.storage.data.IAEFluidStack;
import appeng.client.gui.widgets.GuiCustomSlot;
import appeng.client.gui.widgets.ITooltip;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketInventoryAction;
import appeng.fluids.util.IAEFluidTank;
import appeng.helpers.InventoryAction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiFluidTank
extends GuiCustomSlot
implements ITooltip {
    private final IAEFluidTank tank;
    private final int slot;
    private final int width;
    private final int height;
    private boolean darkened = false;

    public GuiFluidTank(IAEFluidTank tank, int slot, int id, int x, int y, int w, int h) {
        super(id, x, y);
        this.tank = tank;
        this.slot = slot;
        this.width = w;
        this.height = h;
    }

    public GuiFluidTank(IAEFluidTank tank, int slot, int id, int x, int y, int w, int h, boolean darkened) {
        super(id, x, y);
        this.tank = tank;
        this.slot = slot;
        this.width = w;
        this.height = h;
        this.darkened = darkened;
    }

    @Override
    public void drawContent(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        IAEFluidStack fs = this.getFluidStack();
        if (fs != null) {
            GlStateManager.func_179084_k();
            GlStateManager.func_179140_f();
            IAEFluidStack fluid = this.tank.getFluidInSlot(this.slot);
            if (fluid != null && fluid.getStackSize() > 0L) {
                mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
                float red = (float)(fluid.getFluid().getColor() >> 16 & 0xFF) / 255.0f;
                float green = (float)(fluid.getFluid().getColor() >> 8 & 0xFF) / 255.0f;
                float blue = (float)(fluid.getFluid().getColor() & 0xFF) / 255.0f;
                if (this.darkened) {
                    red *= 0.4f;
                    green *= 0.4f;
                    blue *= 0.4f;
                }
                GlStateManager.func_179124_c((float)red, (float)green, (float)blue);
                TextureAtlasSprite sprite = mc.func_147117_R().func_110572_b(fluid.getFluid().getStill().toString());
                int scaledHeight = (int)((float)this.height * ((float)fluid.getStackSize() / (float)this.tank.getTankProperties()[this.slot].getCapacity()));
                scaledHeight = Math.min(this.height, scaledHeight);
                int iconHeightRemainder = scaledHeight % 16;
                if (iconHeightRemainder > 0) {
                    this.func_175175_a(this.xPos(), this.yPos() + this.getHeight() - iconHeightRemainder, sprite, 16, iconHeightRemainder);
                }
                for (int i = 0; i < scaledHeight / 16; ++i) {
                    this.func_175175_a(this.xPos(), this.yPos() + this.getHeight() - iconHeightRemainder - (i + 1) * 16, sprite, 16, 16);
                }
            }
        }
    }

    @Override
    public String getMessage() {
        IAEFluidStack fluid = this.tank.getFluidInSlot(this.slot);
        if (fluid != null && fluid.getStackSize() > 0L) {
            String desc = fluid.getFluid().getLocalizedName(fluid.getFluidStack());
            return desc + "\n" + fluid.getStackSize() + "/" + this.tank.getTankProperties()[this.slot].getCapacity() + "mB";
        }
        return null;
    }

    @Override
    public int xPos() {
        return this.x;
    }

    @Override
    public int yPos() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    public IAEFluidStack getFluidStack() {
        return this.tank.getFluidInSlot(this.slot);
    }

    @Override
    public void slotClicked(ItemStack clickStack, int mouseButton) {
        if (this.getFluidStack() != null) {
            NetworkHandler.instance().sendToServer(new PacketInventoryAction(InventoryAction.FILL_ITEM, this.slot, this.id));
        } else {
            NetworkHandler.instance().sendToServer(new PacketInventoryAction(InventoryAction.EMPTY_ITEM, this.slot, this.id));
        }
    }
}

