/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.util.AEColor;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.items.tools.powered.ToolColorApplicator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class PacketColorApplicatorSelectColor
extends AppEngPacket {
    @Nullable
    private AEColor color = null;

    public PacketColorApplicatorSelectColor(ByteBuf stream) {
        if (stream.readBoolean()) {
            byte colorIdx = stream.readByte();
            AEColor[] values = AEColor.values();
            if (colorIdx >= 0 && colorIdx < values.length) {
                this.color = values[colorIdx];
            }
        }
    }

    public PacketColorApplicatorSelectColor(@Nullable AEColor color) {
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        if (color != null) {
            data.writeBoolean(true);
            data.writeByte(color.ordinal());
        } else {
            data.writeBoolean(false);
        }
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        PacketColorApplicatorSelectColor.switchColor(player.func_184614_ca(), this.color);
        PacketColorApplicatorSelectColor.switchColor(player.func_184592_cb(), this.color);
    }

    private static void switchColor(ItemStack stack, AEColor color) {
        Item item;
        if (!stack.func_190926_b() && (item = stack.func_77973_b()) instanceof ToolColorApplicator) {
            ToolColorApplicator colorApp = (ToolColorApplicator)item;
            colorApp.setActiveColor(stack, color);
        }
    }
}

