/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync;

import appeng.core.sync.GuiBridge;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;

public class GuiWrapper {
    public static final GuiWrapper INSTANCE = new GuiWrapper();
    private final Object2ObjectMap<ResourceLocation, Opener> openers = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<IExternalGui, GuiBridge> externalGuis = new Object2ObjectOpenCustomHashMap((Hash.Strategy)new Hash.Strategy<IExternalGui>(){

        public int hashCode(IExternalGui o) {
            return o.getID().hashCode();
        }

        public boolean equals(@Nullable IExternalGui a, @Nullable IExternalGui b) {
            return a == b || a != null && b != null && a.getID().equals((Object)b.getID());
        }
    });

    private GuiWrapper() {
    }

    public synchronized void registerExternalGuiHandler(@Nonnull ResourceLocation id, @Nonnull Opener opener) {
        this.openers.put((Object)id, (Object)opener);
    }

    @Nullable
    public Opener getOpener(ResourceLocation id) {
        return (Opener)this.openers.get((Object)id);
    }

    public GuiBridge wrap(IExternalGui obj) {
        return (GuiBridge)((Object)this.externalGuis.computeIfAbsent((Object)obj, this::create));
    }

    private GuiBridge create(IExternalGui obj) {
        return (GuiBridge)EnumHelper.addEnum(GuiBridge.class, (String)obj.getID().toString(), (Class[])new Class[]{IExternalGui.class}, (Object[])new Object[]{obj});
    }

    @FunctionalInterface
    public static interface Opener {
        public <T extends IExternalGui> void open(T var1, GuiContext var2);
    }

    public static interface IExternalGui {
        public ResourceLocation getID();
    }

    public static class GuiContext {
        public final World world;
        public final EntityPlayer player;
        public final BlockPos pos;
        public final EnumFacing facing;
        public final NBTTagCompound extra;

        public GuiContext(World world, EntityPlayer player, BlockPos pos, EnumFacing face, NBTTagCompound extra) {
            this.world = world;
            this.player = player;
            this.pos = pos;
            this.facing = face;
            this.extra = extra;
        }
    }
}

