/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.implementations.IUpgradeableCellContainer;
import appeng.api.implementations.guiobjects.IPortableCell;
import appeng.api.networking.security.IActionHost;
import appeng.container.implementations.ContainerMEMonitorable;
import appeng.container.interfaces.IInventorySlotAware;
import appeng.container.slot.SlotRestrictedInput;
import appeng.core.AEConfig;
import appeng.core.localization.PlayerMessages;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.parts.automation.StackUpgradeInventory;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.Platform;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import baubles.api.BaublesApi;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;

public class ContainerMEPortableTerminal
extends ContainerMEMonitorable
implements IUpgradeableCellContainer,
IAEAppEngInventory,
IInventorySlotAware {
    protected final WirelessTerminalGuiObject wirelessTerminalGUIObject;
    private final int slot;
    private double powerMultiplier = 0.5;
    private int ticks = 0;
    protected AppEngInternalInventory upgrades;
    protected SlotRestrictedInput magnetSlot;

    public ContainerMEPortableTerminal(InventoryPlayer ip, WirelessTerminalGuiObject guiObject, boolean bindInventory) {
        super(ip, guiObject, guiObject, bindInventory);
        if (guiObject != null) {
            int slotIndex = guiObject.getInventorySlot();
            if (!guiObject.isBaubleSlot()) {
                this.lockPlayerInventorySlot(slotIndex);
            }
            this.slot = slotIndex;
        } else {
            this.slot = -1;
            this.lockPlayerInventorySlot(ip.field_70461_c);
        }
        this.bindPlayerInventory(ip, 0, 0);
        this.wirelessTerminalGUIObject = guiObject;
        this.upgrades = new StackUpgradeInventory(this.wirelessTerminalGUIObject.getItemStack(), this, 2);
        this.loadFromNBT();
        this.setupUpgrades();
    }

    public ContainerMEPortableTerminal(InventoryPlayer ip, IPortableCell guiObject) {
        super(ip, guiObject, guiObject, true);
        if (guiObject != null) {
            int slotIndex = ((IInventorySlotAware)((Object)guiObject)).getInventorySlot();
            if (!((IInventorySlotAware)((Object)guiObject)).isBaubleSlot()) {
                this.lockPlayerInventorySlot(slotIndex);
            }
            this.slot = slotIndex;
        } else {
            this.slot = -1;
            this.lockPlayerInventorySlot(ip.field_70461_c);
        }
        this.wirelessTerminalGUIObject = (WirelessTerminalGuiObject)guiObject;
        this.upgrades = new StackUpgradeInventory(this.wirelessTerminalGUIObject.getItemStack(), this, 2);
        this.loadFromNBT();
        this.setupUpgrades();
    }

    @Override
    public void func_75142_b() {
        if (Platform.isServer()) {
            ItemStack currentItem;
            if (this.wirelessTerminalGUIObject.isBaubleSlot()) {
                currentItem = BaublesApi.getBaublesHandler((EntityPlayer)this.getPlayerInv().field_70458_d).getStackInSlot(this.slot);
            } else {
                ItemStack itemStack = currentItem = this.slot < 0 ? this.getPlayerInv().func_70448_g() : this.getPlayerInv().func_70301_a(this.slot);
            }
            if (currentItem.func_190926_b()) {
                this.setValidContainer(false);
            } else if (!this.wirelessTerminalGUIObject.getItemStack().func_190926_b() && currentItem != this.wirelessTerminalGUIObject.getItemStack()) {
                if (ItemStack.func_179545_c((ItemStack)this.wirelessTerminalGUIObject.getItemStack(), (ItemStack)currentItem)) {
                    if (this.wirelessTerminalGUIObject.isBaubleSlot()) {
                        BaublesApi.getBaublesHandler((EntityPlayer)this.getPlayerInv().field_70458_d).setStackInSlot(this.slot, this.wirelessTerminalGUIObject.getItemStack());
                    } else {
                        this.getPlayerInv().func_70299_a(this.slot, this.wirelessTerminalGUIObject.getItemStack());
                    }
                } else {
                    this.setValidContainer(false);
                }
            }
            ++this.ticks;
            if (this.ticks > 10) {
                double ext = this.wirelessTerminalGUIObject.extractAEPower(this.getPowerMultiplier() * (double)this.ticks, Actionable.MODULATE, PowerMultiplier.CONFIG);
                if (ext < this.getPowerMultiplier() * (double)this.ticks) {
                    if (Platform.isServer() && this.isValidContainer()) {
                        this.getPlayerInv().field_70458_d.func_145747_a(PlayerMessages.DeviceNotPowered.get());
                    }
                    this.setValidContainer(false);
                }
                this.ticks = 0;
            }
            if (!this.wirelessTerminalGUIObject.rangeCheck()) {
                if (Platform.isServer() && this.isValidContainer()) {
                    this.getPlayerInv().field_70458_d.func_145747_a(PlayerMessages.OutOfRange.get());
                }
                this.setValidContainer(false);
            } else {
                this.setPowerMultiplier(AEConfig.instance().wireless_getDrainRate(this.wirelessTerminalGUIObject.getRange()));
            }
            super.func_75142_b();
        }
    }

    @Override
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (slotId >= 0 && slotId < this.field_75151_b.size() && clickTypeIn == ClickType.PICKUP && dragType == 1 && this.field_75151_b.get(slotId) == this.magnetSlot) {
            ItemStack itemStack = this.magnetSlot.func_75211_c();
            if (!this.magnetSlot.func_75211_c().func_190926_b()) {
                NBTTagCompound tag = itemStack.func_77978_p();
                if (tag == null) {
                    tag = new NBTTagCompound();
                }
                if (tag.func_74764_b("enabled")) {
                    boolean e = tag.func_74767_n("enabled");
                    tag.func_74757_a("enabled", !e);
                } else {
                    tag.func_74757_a("enabled", false);
                }
                this.magnetSlot.func_75211_c().func_77982_d(tag);
                this.magnetSlot.func_75218_e();
                return ItemStack.field_190927_a;
            }
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    @Override
    protected IActionHost getActionHost() {
        return this.wirelessTerminalGUIObject;
    }

    private double getPowerMultiplier() {
        return this.powerMultiplier;
    }

    void setPowerMultiplier(double powerMultiplier) {
        this.powerMultiplier = powerMultiplier;
    }

    @Override
    public int availableUpgrades() {
        return 1;
    }

    @Override
    public void setupUpgrades() {
        if (this.wirelessTerminalGUIObject != null) {
            for (int upgradeSlot = 0; upgradeSlot < this.availableUpgrades(); ++upgradeSlot) {
                this.magnetSlot = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, (IItemHandler)this.upgrades, upgradeSlot, 206, 135 + upgradeSlot * 18, this.getInventoryPlayer());
                this.magnetSlot.setNotDraggable();
                this.func_75146_a(this.magnetSlot);
            }
        }
    }

    @Override
    public void saveChanges() {
        if (Platform.isServer()) {
            NBTTagCompound tag = new NBTTagCompound();
            this.upgrades.writeToNBT(tag, "upgrades");
            this.wirelessTerminalGUIObject.saveChanges(tag);
        }
    }

    protected void loadFromNBT() {
        NBTTagCompound data = this.wirelessTerminalGUIObject.getItemStack().func_77978_p();
        if (data != null) {
            this.upgrades.readFromNBT(this.wirelessTerminalGUIObject.getItemStack().func_77978_p().func_74775_l("upgrades"));
        }
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
    }

    @Override
    public int getInventorySlot() {
        return this.wirelessTerminalGUIObject.getInventorySlot();
    }

    @Override
    public boolean isBaubleSlot() {
        return this.wirelessTerminalGUIObject.isBaubleSlot();
    }
}

