/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.AEApi;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IParts;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.gui.implementations.GuiCraftingCPU;
import appeng.client.gui.widgets.GuiScrollbar;
import appeng.client.gui.widgets.GuiTabButton;
import appeng.container.implementations.ContainerCraftingStatus;
import appeng.container.implementations.CraftingCPUStatus;
import appeng.core.AELog;
import appeng.core.localization.GuiText;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketSwitchGuis;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.parts.reporting.PartCraftingTerminal;
import appeng.parts.reporting.PartExpandedProcessingPatternTerminal;
import appeng.parts.reporting.PartPatternTerminal;
import appeng.parts.reporting.PartTerminal;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiCraftingStatus
extends GuiCraftingCPU {
    private static final int CPU_TABLE_WIDTH = 94;
    private static final int CPU_TABLE_HEIGHT = 164;
    private static final int CPU_TABLE_SLOT_XOFF = 100;
    private static final int CPU_TABLE_SLOT_YOFF = 0;
    private static final int CPU_TABLE_SLOT_WIDTH = 67;
    private static final int CPU_TABLE_SLOT_HEIGHT = 23;
    private final ContainerCraftingStatus status;
    private GuiButton selectCPU;
    private GuiScrollbar cpuScrollbar;
    private GuiTabButton originalGuiBtn;
    private GuiBridge originalGui;
    private ItemStack myIcon = ItemStack.field_190927_a;
    private String selectedCPUName = "";

    public GuiCraftingStatus(InventoryPlayer inventoryPlayer, ITerminalHost te) {
        super(new ContainerCraftingStatus(inventoryPlayer, te));
        this.status = (ContainerCraftingStatus)this.field_147002_h;
        Object target = this.status.getTarget();
        IDefinitions definitions = AEApi.instance().definitions();
        IParts parts = definitions.parts();
        if (target instanceof WirelessTerminalGuiObject) {
            this.myIcon = ((WirelessTerminalGuiObject)target).getItemStack();
            this.originalGui = (GuiBridge)AEApi.instance().registries().wireless().getWirelessTerminalHandler(this.myIcon).getGuiHandler(this.myIcon);
        }
        if (target instanceof PartTerminal) {
            this.myIcon = parts.terminal().maybeStack(1).orElse(ItemStack.field_190927_a);
            this.originalGui = GuiBridge.GUI_ME;
        }
        if (target instanceof PartCraftingTerminal) {
            this.myIcon = parts.craftingTerminal().maybeStack(1).orElse(ItemStack.field_190927_a);
            this.originalGui = GuiBridge.GUI_CRAFTING_TERMINAL;
        }
        if (target instanceof PartPatternTerminal) {
            this.myIcon = parts.patternTerminal().maybeStack(1).orElse(ItemStack.field_190927_a);
            this.originalGui = GuiBridge.GUI_PATTERN_TERMINAL;
        }
        if (target instanceof PartExpandedProcessingPatternTerminal) {
            this.myIcon = parts.expandedProcessingPatternTerminal().maybeStack(1).orElse(ItemStack.field_190927_a);
            this.originalGui = GuiBridge.GUI_EXPANDED_PROCESSING_PATTERN_TERMINAL;
        }
    }

    @Override
    protected void func_146284_a(GuiButton btn) throws IOException {
        super.func_146284_a(btn);
        boolean backwards = Mouse.isButtonDown((int)1);
        if (btn == this.originalGuiBtn) {
            NetworkHandler.instance().sendToServer(new PacketSwitchGuis(this.originalGui));
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.selectCPU = new GuiButton(0, this.field_147003_i + 8, this.field_147009_r + this.field_147000_g - 25, 150, 20, GuiText.CraftingCPU.getLocal() + ": " + (Object)((Object)GuiText.NoCraftingCPUs));
        this.selectCPU.field_146124_l = false;
        this.field_146292_n.add(this.selectCPU);
        this.cpuScrollbar = new GuiScrollbar();
        this.cpuScrollbar.setLeft(-16);
        this.cpuScrollbar.setTop(19);
        this.cpuScrollbar.setWidth(12);
        this.cpuScrollbar.setHeight(137);
        if (!this.myIcon.func_190926_b()) {
            this.originalGuiBtn = new GuiTabButton(this.field_147003_i + 213, this.field_147009_r - 4, this.myIcon, this.myIcon.func_82833_r(), this.field_146296_j);
            this.field_146292_n.add(this.originalGuiBtn);
            this.originalGuiBtn.setHideEdge(13);
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float btn) {
        List<CraftingCPUStatus> cpus = this.status.getCPUs();
        this.selectedCPUName = null;
        this.cpuScrollbar.setRange(0, Integer.max(0, cpus.size() - 6), 1);
        for (CraftingCPUStatus cpu : cpus) {
            if (cpu.getSerial() != this.status.selectedCpuSerial) continue;
            this.selectedCPUName = cpu.getName();
        }
        this.updateCPUButtonText();
        super.func_73863_a(mouseX, mouseY, btn);
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        List<CraftingCPUStatus> cpus = this.status.getCPUs();
        int firstCpu = this.cpuScrollbar.getCurrentScroll();
        CraftingCPUStatus hoveredCpu = this.hitCpu(mouseX, mouseY);
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        int TEXT_COLOR = 0x202020;
        for (int i = firstCpu; i < firstCpu + 6; ++i) {
            int uv_x;
            int uv_y;
            int iconIndex;
            CraftingCPUStatus cpu;
            if (i < 0 || i >= cpus.size() || (cpu = cpus.get(i)) == null) continue;
            int x = -85;
            int y = 19 + (i - firstCpu) * 23;
            if (cpu.getSerial() == this.status.selectedCpuSerial) {
                GL11.glColor4f((float)0.0f, (float)0.8352f, (float)1.0f, (float)1.0f);
            } else if (hoveredCpu != null && hoveredCpu.getSerial() == cpu.getSerial()) {
                GL11.glColor4f((float)0.65f, (float)0.9f, (float)1.0f, (float)1.0f);
            } else {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            this.bindTexture("guis/cpu_selector.png");
            this.func_73729_b(x, y, 100, 0, 67, 23);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            String name = cpu.getName();
            if (name == null || name.isEmpty()) {
                name = GuiText.CPUs.getLocal() + " #" + cpu.getSerial();
            }
            if (name.length() > 12) {
                name = name.substring(0, 11) + "..";
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(x + 3), (float)(y + 3), (float)0.0f);
            GL11.glScalef((float)0.8f, (float)0.8f, (float)1.0f);
            font.func_78276_b(name, 0, 0, 0x202020);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(x + 3), (float)(y + 11), (float)0.0f);
            IAEItemStack craftingStack = cpu.getCrafting();
            if (craftingStack != null) {
                iconIndex = 178;
                this.bindTexture("guis/states.png");
                uv_y = 11;
                uv_x = 2;
                GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.func_73729_b(0, 0, 32, 176, 16, 16);
                GL11.glTranslatef((float)18.0f, (float)2.0f, (float)0.0f);
                String amount = Long.toString(craftingStack.getStackSize());
                if (amount.length() > 5) {
                    amount = amount.substring(0, 5) + "..";
                }
                GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                font.func_78276_b(amount, 0, 0, 36864);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslatef((float)(x + 67 - 19), (float)(y + 3), (float)0.0f);
                this.drawItem(0, 0, craftingStack.createItemStack());
            } else {
                iconIndex = 67;
                this.bindTexture("guis/states.png");
                uv_y = 4;
                uv_x = 3;
                GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.func_73729_b(0, 0, 48, 64, 16, 16);
                GL11.glTranslatef((float)18.0f, (float)2.0f, (float)0.0f);
                GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                font.func_78276_b(cpu.formatStorage(), 0, 0, 0x202020);
            }
            GL11.glPopMatrix();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        StringBuilder tooltip = new StringBuilder();
        if (hoveredCpu != null) {
            String name = hoveredCpu.getName();
            if (name != null && !name.isEmpty()) {
                tooltip.append(name);
                tooltip.append('\n');
            } else {
                tooltip.append(GuiText.CPUs.getLocal());
                tooltip.append(" #");
                tooltip.append(hoveredCpu.getSerial());
                tooltip.append('\n');
            }
            IAEItemStack crafting = hoveredCpu.getCrafting();
            if (crafting != null && crafting.getStackSize() > 0L) {
                tooltip.append(GuiText.Crafting.getLocal());
                tooltip.append(": ");
                tooltip.append(crafting.getStackSize());
                tooltip.append(' ');
                tooltip.append(crafting.createItemStack().func_82833_r());
                tooltip.append('\n');
                tooltip.append(hoveredCpu.getRemainingItems());
                tooltip.append(" / ");
                tooltip.append(hoveredCpu.getTotalItems());
                tooltip.append('\n');
            }
            if (hoveredCpu.getStorage() > 0L) {
                tooltip.append(GuiText.Bytes.getLocal());
                tooltip.append(": ");
                tooltip.append(hoveredCpu.formatStorage());
                tooltip.append('\n');
            }
            if (hoveredCpu.getCoprocessors() > 0L) {
                tooltip.append(GuiText.CoProcessors.getLocal());
                tooltip.append(": ");
                tooltip.append(hoveredCpu.getCoprocessors());
                tooltip.append('\n');
            }
        }
        if (this.cpuScrollbar != null) {
            this.cpuScrollbar.draw(this);
        }
        super.drawFG(offsetX, offsetY, mouseX, mouseY);
        if (tooltip.length() > 0) {
            this.drawTooltip(mouseX - offsetX, mouseY - offsetY, tooltip.toString());
        }
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        super.drawBG(offsetX, offsetY, mouseX, mouseY);
        this.bindTexture("guis/cpu_selector.png");
        this.func_73729_b(offsetX - 94, offsetY, 0, 0, 94, 164);
    }

    @Override
    public List<Rectangle> getJEIExclusionArea() {
        Rectangle craftingCPUArea = new Rectangle(this.field_147003_i - 94, this.field_147009_r, 94, 164);
        ArrayList<Rectangle> area = new ArrayList<Rectangle>();
        area.add(craftingCPUArea);
        return area;
    }

    @Override
    protected void func_73864_a(int xCoord, int yCoord, int btn) throws IOException {
        CraftingCPUStatus hit;
        super.func_73864_a(xCoord, yCoord, btn);
        if (this.cpuScrollbar != null) {
            this.cpuScrollbar.click(this, xCoord - this.field_147003_i, yCoord - this.field_147009_r);
        }
        if ((hit = this.hitCpu(xCoord, yCoord)) != null) {
            try {
                NetworkHandler.instance.sendToServer(new PacketValueConfig("Terminal.Cpu.Set", Integer.toString(hit.getSerial())));
            }
            catch (IOException e) {
                AELog.debug(e);
            }
        }
    }

    @Override
    protected void func_146273_a(int x, int y, int c, long d) {
        super.func_146273_a(x, y, c, d);
        if (this.cpuScrollbar != null) {
            this.cpuScrollbar.click(this, x - this.field_147003_i, y - this.field_147009_r);
        }
    }

    @Override
    public void func_146274_d() throws IOException {
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int dwheel = Mouse.getEventDWheel();
        if ((x -= this.field_147003_i - 94) >= 9 && x < 76 && (y -= this.field_147009_r) >= 19 && y < 157 && this.cpuScrollbar != null && dwheel != 0) {
            this.cpuScrollbar.wheel(dwheel);
            return;
        }
        super.func_146274_d();
    }

    private CraftingCPUStatus hitCpu(int x, int y) {
        if ((x -= this.field_147003_i - 94) < 9 || x >= 76 || (y -= this.field_147009_r) < 19 || y >= 157) {
            return null;
        }
        int scrollOffset = this.cpuScrollbar != null ? this.cpuScrollbar.getCurrentScroll() : 0;
        int cpuId = scrollOffset + (y - 19) / 23;
        List<CraftingCPUStatus> cpus = this.status.getCPUs();
        return cpuId >= 0 && cpuId < cpus.size() ? cpus.get(cpuId) : null;
    }

    private void updateCPUButtonText() {
        String btnTextText = GuiText.NoCraftingJobs.getLocal();
        if (this.status.selectedCpuSerial >= 0) {
            if (this.selectedCPUName != null && this.selectedCPUName.length() > 0) {
                String name = this.selectedCPUName.substring(0, Math.min(20, this.selectedCPUName.length()));
                btnTextText = GuiText.CPUs.getLocal() + ": " + name;
            } else {
                btnTextText = GuiText.CPUs.getLocal() + ": #" + this.status.selectedCpuSerial;
            }
        }
        if (this.status.getCPUs().isEmpty()) {
            btnTextText = GuiText.NoCraftingJobs.getLocal();
        }
        this.selectCPU.field_146126_j = btnTextText;
    }

    @Override
    protected String getGuiDisplayName(String in) {
        return in;
    }

    public void postCPUUpdate(CraftingCPUStatus[] cpus) {
        this.status.postCPUUpdate(cpus);
    }
}

